'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _branchView = require('../views/branch-view');

var _branchView2 = _interopRequireDefault(_branchView);

var _branchMenuView = require('../views/branch-menu-view');

var _branchMenuView2 = _interopRequireDefault(_branchMenuView);

var _pushPullView = require('../views/push-pull-view');

var _pushPullView2 = _interopRequireDefault(_pushPullView);

var _changedFilesCountView = require('../views/changed-files-count-view');

var _changedFilesCountView2 = _interopRequireDefault(_changedFilesCountView);

var _githubTileView = require('../views/github-tile-view');

var _githubTileView2 = _interopRequireDefault(_githubTileView);

var _tooltip = require('../atom/tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class StatusBarTileController extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.fetchData = repository => {
      return (0, _yubikiri2.default)({
        currentBranch: repository.getCurrentBranch(),
        branches: repository.getBranches(),
        statusesForChangedFiles: repository.getStatusesForChangedFiles(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        aheadCount: async query => repository.getAheadCount((await query.currentBranch).getName()),
        behindCount: async query => repository.getBehindCount((await query.currentBranch).getName()),
        originExists: async () => (await repository.getRemotes()).withName('origin').isPresent()
      });
    };

    this.handleOpenGitTimingsView = e => {
      e && e.preventDefault();
      this.props.workspace.open('atom-github://debug/timings');
    };

    this.checkout = (branchName, options) => {
      return this.props.repository.checkout(branchName, options);
    };

    this.refBranchViewRoot = new _refHolder2.default();
  }

  getChangedFilesCount(data) {
    const { stagedFiles, unstagedFiles, mergeConflictFiles } = data.statusesForChangedFiles;
    const changedFiles = new Set();

    for (const filePath in unstagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in stagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in mergeConflictFiles) {
      changedFiles.add(filePath);
    }

    return changedFiles.size;
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchData },
      data => data ? this.renderWithData(data) : null
    );
  }

  renderWithData(data) {
    let changedFilesCount, mergeConflictsPresent;
    if (data.statusesForChangedFiles) {
      changedFilesCount = this.getChangedFilesCount(data);
      mergeConflictsPresent = Object.keys(data.statusesForChangedFiles.mergeConflictFiles).length > 0;
    }

    const repoProps = {
      repository: this.props.repository,
      currentBranch: data.currentBranch,
      branches: data.branches,
      currentRemote: data.currentRemote,
      aheadCount: data.aheadCount,
      behindCount: data.behindCount,
      originExists: data.originExists,
      changedFilesCount,
      mergeConflictsPresent
    };

    return _react2.default.createElement(
      _react.Fragment,
      null,
      this.renderTiles(repoProps),
      _react2.default.createElement(_githubTileView2.default, { didClick: this.props.toggleGithubTab }),
      _react2.default.createElement(_changedFilesCountView2.default, {
        didClick: this.props.toggleGitTab,
        changedFilesCount: repoProps.changedFilesCount,
        mergeConflictsPresent: repoProps.mergeConflictsPresent
      })
    );
  }

  renderTiles(repoProps) {
    if (!this.props.repository.showStatusBarTiles()) {
      return null;
    }

    const operationStates = this.props.repository.getOperationStates();
    const pushInProgress = operationStates.isPushInProgress();
    const pullInProgress = operationStates.isPullInProgress();
    const fetchInProgress = operationStates.isFetchInProgress();

    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:fetch', callback: this.fetch(repoProps) }),
        _react2.default.createElement(_commands.Command, { command: 'github:pull', callback: this.pull(repoProps) }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:push',
          callback: () => this.push(repoProps)({ force: false, setUpstream: !repoProps.currentRemote.isPresent() })
        }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:force-push',
          callback: () => this.push(repoProps)({ force: true, setUpstream: !repoProps.currentRemote.isPresent() })
        })
      ),
      _react2.default.createElement(_branchView2.default, {
        refRoot: this.refBranchViewRoot.setter,
        workspace: this.props.workspace,
        checkout: this.checkout,
        currentBranch: repoProps.currentBranch
      }),
      _react2.default.createElement(
        _tooltip2.default,
        {
          manager: this.props.tooltips,
          target: this.refBranchViewRoot,
          trigger: 'click',
          className: 'github-StatusBarTileController-tooltipMenu' },
        _react2.default.createElement(_branchMenuView2.default, {
          workspace: this.props.workspace,
          notificationManager: this.props.notificationManager,
          commandRegistry: this.props.commandRegistry,
          checkout: this.checkout,
          branches: repoProps.branches,
          currentBranch: repoProps.currentBranch
        })
      ),
      _react2.default.createElement(_pushPullView2.default, {
        isSyncing: fetchInProgress || pullInProgress || pushInProgress,
        isFetching: fetchInProgress,
        isPulling: pullInProgress,
        isPushing: pushInProgress,
        push: this.push(repoProps),
        pull: this.pull(repoProps),
        fetch: this.fetch(repoProps),
        tooltipManager: this.props.tooltips,
        currentBranch: repoProps.currentBranch,
        currentRemote: repoProps.currentRemote,
        behindCount: repoProps.behindCount,
        aheadCount: repoProps.aheadCount,
        originExists: repoProps.originExists
      })
    );
  }

  push(data) {
    return ({ force, setUpstream } = {}) => {
      return this.props.repository.push(data.currentBranch.getName(), {
        force,
        setUpstream,
        refSpec: data.currentBranch.getRefSpec('PUSH')
      });
    };
  }

  pull(data) {
    return () => {
      return this.props.repository.pull(data.currentBranch.getName(), {
        refSpec: data.currentBranch.getRefSpec('PULL')
      });
    };
  }

  fetch(data) {
    return () => {
      const upstream = data.currentBranch.getUpstream();
      return this.props.repository.fetch(upstream.getRemoteRef(), {
        remoteName: upstream.getRemoteName()
      });
    };
  }
}
exports.default = StatusBarTileController;
StatusBarTileController.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  confirm: _propTypes2.default.func.isRequired,
  repository: _propTypes2.default.object.isRequired,
  toggleGitTab: _propTypes2.default.func,
  toggleGithubTab: _propTypes2.default.func
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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