(function() {
  var Range, Snippet, TabStopList;

  Range = require('atom').Range;

  TabStopList = require('./tab-stop-list');

  module.exports = Snippet = (function() {
    function Snippet(arg) {
      var bodyTree;
      this.name = arg.name, this.prefix = arg.prefix, this.bodyText = arg.bodyText, this.description = arg.description, this.descriptionMoreURL = arg.descriptionMoreURL, this.rightLabelHTML = arg.rightLabelHTML, this.leftLabel = arg.leftLabel, this.leftLabelHTML = arg.leftLabelHTML, bodyTree = arg.bodyTree;
      this.tabStopList = new TabStopList(this);
      this.body = this.extractTabStops(bodyTree);
    }

    Snippet.prototype.extractTabStops = function(bodyTree) {
      var bodyText, column, extractTabStops, ref, row, tabStopsByIndex;
      tabStopsByIndex = {};
      bodyText = [];
      ref = [0, 0], row = ref[0], column = ref[1];
      extractTabStops = (function(_this) {
        return function(bodyTree) {
          var content, i, index, len, nextLine, range, results, segment, segmentLines, start, substitution, tabStop;
          results = [];
          for (i = 0, len = bodyTree.length; i < len; i++) {
            segment = bodyTree[i];
            if (segment.index != null) {
              index = segment.index, content = segment.content, substitution = segment.substitution;
              if (index === 0) {
                index = 2e308;
              }
              start = [row, column];
              extractTabStops(content);
              range = new Range(start, [row, column]);
              tabStop = _this.tabStopList.findOrCreate({
                index: index,
                snippet: _this
              });
              results.push(tabStop.addInsertion({
                range: range,
                substitution: substitution
              }));
            } else if (typeof segment === 'string') {
              bodyText.push(segment);
              segmentLines = segment.split('\n');
              column += segmentLines.shift().length;
              results.push((function() {
                var results1;
                results1 = [];
                while ((nextLine = segmentLines.shift()) != null) {
                  row += 1;
                  results1.push(column = nextLine.length);
                }
                return results1;
              })());
            } else {
              results.push(void 0);
            }
          }
          return results;
        };
      })(this);
      extractTabStops(bodyTree);
      this.lineCount = row + 1;
      this.insertions = this.tabStopList.getInsertions();
      return bodyText.join('');
    };

    return Snippet;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL3NuaXBwZXRzL2xpYi9zbmlwcGV0LmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUMsUUFBUyxPQUFBLENBQVEsTUFBUjs7RUFDVixXQUFBLEdBQWMsT0FBQSxDQUFRLGlCQUFSOztFQUVkLE1BQU0sQ0FBQyxPQUFQLEdBQ007SUFDUyxpQkFBQyxHQUFEO0FBQ1gsVUFBQTtNQURhLElBQUMsQ0FBQSxXQUFBLE1BQU0sSUFBQyxDQUFBLGFBQUEsUUFBUSxJQUFDLENBQUEsZUFBQSxVQUFVLElBQUMsQ0FBQSxrQkFBQSxhQUFhLElBQUMsQ0FBQSx5QkFBQSxvQkFBb0IsSUFBQyxDQUFBLHFCQUFBLGdCQUFnQixJQUFDLENBQUEsZ0JBQUEsV0FBVyxJQUFDLENBQUEsb0JBQUEsZUFBZTtNQUN4SCxJQUFDLENBQUEsV0FBRCxHQUFlLElBQUksV0FBSixDQUFnQixJQUFoQjtNQUNmLElBQUMsQ0FBQSxJQUFELEdBQVEsSUFBQyxDQUFBLGVBQUQsQ0FBaUIsUUFBakI7SUFGRzs7c0JBSWIsZUFBQSxHQUFpQixTQUFDLFFBQUQ7QUFDZixVQUFBO01BQUEsZUFBQSxHQUFrQjtNQUNsQixRQUFBLEdBQVc7TUFDWCxNQUFnQixDQUFDLENBQUQsRUFBSSxDQUFKLENBQWhCLEVBQUMsWUFBRCxFQUFNO01BR04sZUFBQSxHQUFrQixDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUMsUUFBRDtBQUNoQixjQUFBO0FBQUE7ZUFBQSwwQ0FBQTs7WUFDRSxJQUFHLHFCQUFIO2NBQ0cscUJBQUQsRUFBUSx5QkFBUixFQUFpQjtjQUNqQixJQUFvQixLQUFBLEtBQVMsQ0FBN0I7Z0JBQUEsS0FBQSxHQUFRLE1BQVI7O2NBQ0EsS0FBQSxHQUFRLENBQUMsR0FBRCxFQUFNLE1BQU47Y0FDUixlQUFBLENBQWdCLE9BQWhCO2NBQ0EsS0FBQSxHQUFRLElBQUksS0FBSixDQUFVLEtBQVYsRUFBaUIsQ0FBQyxHQUFELEVBQU0sTUFBTixDQUFqQjtjQUNSLE9BQUEsR0FBVSxLQUFDLENBQUEsV0FBVyxDQUFDLFlBQWIsQ0FBMEI7Z0JBQ2xDLEtBQUEsRUFBTyxLQUQyQjtnQkFFbEMsT0FBQSxFQUFTLEtBRnlCO2VBQTFCOzJCQUlWLE9BQU8sQ0FBQyxZQUFSLENBQXFCO2dCQUNuQixLQUFBLEVBQU8sS0FEWTtnQkFFbkIsWUFBQSxFQUFjLFlBRks7ZUFBckIsR0FWRjthQUFBLE1BY0ssSUFBRyxPQUFPLE9BQVAsS0FBa0IsUUFBckI7Y0FDSCxRQUFRLENBQUMsSUFBVCxDQUFjLE9BQWQ7Y0FDQSxZQUFBLEdBQWUsT0FBTyxDQUFDLEtBQVIsQ0FBYyxJQUFkO2NBQ2YsTUFBQSxJQUFVLFlBQVksQ0FBQyxLQUFiLENBQUEsQ0FBb0IsQ0FBQzs7O0FBQy9CO3VCQUFNLHlDQUFOO2tCQUNFLEdBQUEsSUFBTztnQ0FDUCxNQUFBLEdBQVMsUUFBUSxDQUFDO2dCQUZwQixDQUFBOztvQkFKRzthQUFBLE1BQUE7bUNBQUE7O0FBZlA7O1FBRGdCO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQTtNQXdCbEIsZUFBQSxDQUFnQixRQUFoQjtNQUNBLElBQUMsQ0FBQSxTQUFELEdBQWEsR0FBQSxHQUFNO01BQ25CLElBQUMsQ0FBQSxVQUFELEdBQWMsSUFBQyxDQUFBLFdBQVcsQ0FBQyxhQUFiLENBQUE7YUFFZCxRQUFRLENBQUMsSUFBVCxDQUFjLEVBQWQ7SUFsQ2U7Ozs7O0FBVG5CIiwic291cmNlc0NvbnRlbnQiOlsie1JhbmdlfSA9IHJlcXVpcmUgJ2F0b20nXG5UYWJTdG9wTGlzdCA9IHJlcXVpcmUgJy4vdGFiLXN0b3AtbGlzdCdcblxubW9kdWxlLmV4cG9ydHMgPVxuY2xhc3MgU25pcHBldFxuICBjb25zdHJ1Y3RvcjogKHtAbmFtZSwgQHByZWZpeCwgQGJvZHlUZXh0LCBAZGVzY3JpcHRpb24sIEBkZXNjcmlwdGlvbk1vcmVVUkwsIEByaWdodExhYmVsSFRNTCwgQGxlZnRMYWJlbCwgQGxlZnRMYWJlbEhUTUwsIGJvZHlUcmVlfSkgLT5cbiAgICBAdGFiU3RvcExpc3QgPSBuZXcgVGFiU3RvcExpc3QodGhpcylcbiAgICBAYm9keSA9IEBleHRyYWN0VGFiU3RvcHMoYm9keVRyZWUpXG5cbiAgZXh0cmFjdFRhYlN0b3BzOiAoYm9keVRyZWUpIC0+XG4gICAgdGFiU3RvcHNCeUluZGV4ID0ge31cbiAgICBib2R5VGV4dCA9IFtdXG4gICAgW3JvdywgY29sdW1uXSA9IFswLCAwXVxuXG4gICAgIyByZWN1cnNpdmUgaGVscGVyIGZ1bmN0aW9uOyBtdXRhdGVzIHZhcnMgYWJvdmVcbiAgICBleHRyYWN0VGFiU3RvcHMgPSAoYm9keVRyZWUpID0+XG4gICAgICBmb3Igc2VnbWVudCBpbiBib2R5VHJlZVxuICAgICAgICBpZiBzZWdtZW50LmluZGV4P1xuICAgICAgICAgIHtpbmRleCwgY29udGVudCwgc3Vic3RpdHV0aW9ufSA9IHNlZ21lbnRcbiAgICAgICAgICBpbmRleCA9IEluZmluaXR5IGlmIGluZGV4IGlzIDBcbiAgICAgICAgICBzdGFydCA9IFtyb3csIGNvbHVtbl1cbiAgICAgICAgICBleHRyYWN0VGFiU3RvcHMoY29udGVudClcbiAgICAgICAgICByYW5nZSA9IG5ldyBSYW5nZShzdGFydCwgW3JvdywgY29sdW1uXSlcbiAgICAgICAgICB0YWJTdG9wID0gQHRhYlN0b3BMaXN0LmZpbmRPckNyZWF0ZSh7XG4gICAgICAgICAgICBpbmRleDogaW5kZXgsXG4gICAgICAgICAgICBzbmlwcGV0OiB0aGlzXG4gICAgICAgICAgfSlcbiAgICAgICAgICB0YWJTdG9wLmFkZEluc2VydGlvbih7XG4gICAgICAgICAgICByYW5nZTogcmFuZ2UsXG4gICAgICAgICAgICBzdWJzdGl0dXRpb246IHN1YnN0aXR1dGlvblxuICAgICAgICAgIH0pXG4gICAgICAgIGVsc2UgaWYgdHlwZW9mIHNlZ21lbnQgaXMgJ3N0cmluZydcbiAgICAgICAgICBib2R5VGV4dC5wdXNoKHNlZ21lbnQpXG4gICAgICAgICAgc2VnbWVudExpbmVzID0gc2VnbWVudC5zcGxpdCgnXFxuJylcbiAgICAgICAgICBjb2x1bW4gKz0gc2VnbWVudExpbmVzLnNoaWZ0KCkubGVuZ3RoXG4gICAgICAgICAgd2hpbGUgKG5leHRMaW5lID0gc2VnbWVudExpbmVzLnNoaWZ0KCkpP1xuICAgICAgICAgICAgcm93ICs9IDFcbiAgICAgICAgICAgIGNvbHVtbiA9IG5leHRMaW5lLmxlbmd0aFxuXG4gICAgZXh0cmFjdFRhYlN0b3BzKGJvZHlUcmVlKVxuICAgIEBsaW5lQ291bnQgPSByb3cgKyAxXG4gICAgQGluc2VydGlvbnMgPSBAdGFiU3RvcExpc3QuZ2V0SW5zZXJ0aW9ucygpXG5cbiAgICBib2R5VGV4dC5qb2luKCcnKVxuIl19
