'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RemoteSelectorView extends _react2.default.Component {

  render() {
    const { remotes, currentBranch, selectRemote } = this.props;
    // todo: ask Ash how to test this before merging.
    return _react2.default.createElement(
      'div',
      { className: 'github-RemoteSelector' },
      _react2.default.createElement(
        'p',
        null,
        'This repository has multiple remotes hosted at GitHub.com. Select a remote to see pull requests associated with the ',
        _react2.default.createElement(
          'strong',
          null,
          currentBranch.getName()
        ),
        ' branch.'
      ),
      _react2.default.createElement(
        'ul',
        null,
        Array.from(remotes, remote => _react2.default.createElement(
          'li',
          { key: remote.getName() },
          _react2.default.createElement(
            'button',
            { className: 'btn btn-primary', onClick: e => selectRemote(e, remote) },
            remote.getName(),
            ' (',
            remote.getOwner(),
            '/',
            remote.getRepo(),
            ')'
          )
        ))
      )
    );
  }
}
exports.default = RemoteSelectorView;
RemoteSelectorView.propTypes = {
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  selectRemote: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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