'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _reporterProxy = require('../reporter-proxy');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GithubTileView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handleClick');
  }

  handleClick() {
    (0, _reporterProxy.addEvent)('click', { package: 'github', component: 'GithubTileView' });
    this.props.didClick();
  }

  render() {
    return _react2.default.createElement(
      'button',
      {
        className: 'github-StatusBarTile inline-block',
        onClick: this.handleClick },
      _react2.default.createElement(_octicon2.default, { icon: 'mark-github' }),
      'GitHub'
    );
  }
}
exports.default = GithubTileView;
GithubTileView.propTypes = {
  didClick: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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