'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CreatePullRequestTile extends _react2.default.Component {

  render() {
    if (this.isRepositoryNotFound()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        _react2.default.createElement(
          'strong',
          null,
          'Repository not found'
        ),
        ' for the remote ',
        _react2.default.createElement(
          'code',
          null,
          this.props.remote.getName()
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'link' }),
        'Do you need to update your ',
        _react2.default.createElement(
          'strong',
          null,
          'remote URL'
        ),
        '?'
      );
    }

    if (this.isDetachedHead()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'You are not currently on ',
        _react2.default.createElement(
          'strong',
          null,
          'any branch'
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'git-branch' }),
        _react2.default.createElement(
          'strong',
          null,
          'Create a new branch'
        ),
        '\xA0 to share your work with a pull request.'
      );
    }

    if (this.hasNoDefaultRef()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'The repository at remote ',
        _react2.default.createElement(
          'code',
          null,
          this.props.remote.getName()
        ),
        ' is ',
        _react2.default.createElement(
          'strong',
          null,
          'empty'
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'arrow-up' }),
        _react2.default.createElement(
          'strong',
          null,
          'Push a main branch'
        ),
        ' to begin sharing your work.'
      );
    }

    if (this.isOnDefaultRef()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'You are currently on your repository\'s ',
        _react2.default.createElement(
          'strong',
          null,
          'default branch'
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'git-branch' }),
        _react2.default.createElement(
          'strong',
          null,
          'Checkout or create a new branch'
        ),
        '\xA0 to share your work with a pull request.'
      );
    }

    if (this.isSameAsDefaultRef()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'Your current branch ',
        _react2.default.createElement(
          'strong',
          null,
          'has not moved'
        ),
        ' from the repository\'s default branch.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'git-commit' }),
        _react2.default.createElement(
          'strong',
          null,
          'Make some commits'
        ),
        '\xA0 to share your work with a pull request.'
      );
    }

    let message = 'Open new pull request';
    let disable = false;
    const differentRemote = this.pushesToDifferentRemote();
    if (this.props.pushInProgress) {
      message = 'Pushing...';
      disable = true;
    } else if (!this.hasUpstreamBranch() || differentRemote) {
      message = 'Publish + open new pull request';
    } else if (this.props.aheadCount > 0) {
      message = 'Push + open new pull request';
    }

    return _react2.default.createElement(
      'div',
      null,
      differentRemote && _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'Your current branch is ',
        _react2.default.createElement(
          'strong',
          null,
          'configured'
        ),
        ' to push to the remote ',
        _react2.default.createElement(
          'code',
          null,
          this.props.branches.getHeadBranch().getPush().getRemoteName()
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'cloud-upload' }),
        _react2.default.createElement(
          'strong',
          null,
          'Publish'
        ),
        ' it to ',
        _react2.default.createElement(
          'code',
          null,
          this.props.remote.getName()
        ),
        ' instead?'
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-controls' },
        _react2.default.createElement(
          'button',
          {
            className: 'github-CreatePullRequestTile-createPr btn btn-primary',
            onClick: this.props.onCreatePr,
            disabled: disable },
          message
        )
      )
    );
  }

  isRepositoryNotFound() {
    return !this.props.repository;
  }

  isDetachedHead() {
    return !this.props.branches.getHeadBranch().isPresent();
  }

  hasNoDefaultRef() {
    return !this.props.repository.defaultBranchRef;
  }

  isOnDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }
    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */
    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    return currentBranch.getPush().getRemoteRef() === `${defaultRef.prefix}${defaultRef.name}`;
  }

  isSameAsDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }
    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */
    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    const mainBranches = this.props.branches.getPushSources(this.props.remote.getName(), `${defaultRef.prefix}${defaultRef.name}`);
    return mainBranches.some(branch => branch.getSha() === currentBranch.getSha());
  }

  pushesToDifferentRemote() {
    const p = this.props.branches.getHeadBranch().getPush();
    if (!p.isRemoteTracking()) {
      return false;
    }

    const pushRemoteName = p.getRemoteName();
    return pushRemoteName !== this.props.remote.getName();
  }

  hasUpstreamBranch() {
    return this.props.branches.getHeadBranch().getUpstream().isPresent();
  }
}
exports.default = CreatePullRequestTile;
CreatePullRequestTile.propTypes = {
  repository: _propTypes2.default.shape({
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }),

  remote: _propTypes3.RemotePropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  onCreatePr: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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