/**
 * 
 * @relayHash 0de8f3b80a7115e2fb90301e39c4591d
 */

/* eslint-disable */

'use strict';

/*::
import type { ConcreteRequest } from 'relay-runtime';
type issueDetailView_issue$ref = any;
type issueDetailView_repository$ref = any;
export type issueDetailViewRefetchQueryVariables = {|
  repoId: string,
  issueishId: string,
  timelineCount: number,
  timelineCursor?: ?string,
|};
export type issueDetailViewRefetchQueryResponse = {|
  +repository: ?{|
    +$fragmentRefs: issueDetailView_repository$ref
  |},
  +issue: ?{|
    +$fragmentRefs: issueDetailView_issue$ref
  |},
|};
export type issueDetailViewRefetchQuery = {|
  variables: issueDetailViewRefetchQueryVariables,
  response: issueDetailViewRefetchQueryResponse,
|};
*/

/*
query issueDetailViewRefetchQuery(
  $repoId: ID!
  $issueishId: ID!
  $timelineCount: Int!
  $timelineCursor: String
) {
  repository: node(id: $repoId) {
    __typename
    ...issueDetailView_repository_3D8CP9
    id
  }
  issue: node(id: $issueishId) {
    __typename
    ...issueDetailView_issue_3D8CP9
    id
  }
}

fragment issueDetailView_repository_3D8CP9 on Repository {
  id
  name
  owner {
    __typename
    login
    id
  }
}

fragment issueDetailView_issue_3D8CP9 on Issue {
  __typename
  ... on Node {
    id
  }
  state
  number
  title
  bodyHTML
  author {
    __typename
    login
    avatarUrl
    ... on User {
      url
    }
    ... on Bot {
      url
    }
    ... on Node {
      id
    }
  }
  ...issueTimelineController_issue_3D8CP9
  ... on UniformResourceLocatable {
    url
  }
  ... on Reactable {
    reactionGroups {
      content
      users {
        totalCount
      }
    }
  }
}

fragment issueTimelineController_issue_3D8CP9 on Issue {
  url
  timeline(first: $timelineCount, after: $timelineCursor) {
    pageInfo {
      endCursor
      hasNextPage
    }
    edges {
      cursor
      node {
        __typename
        ...commitsView_nodes
        ...issueCommentView_item
        ...crossReferencedEventsView_nodes
        ... on Node {
          id
        }
      }
    }
  }
}

fragment commitsView_nodes on Commit {
  id
  author {
    name
    user {
      login
      id
    }
  }
  ...commitView_commit
}

fragment issueCommentView_item on IssueComment {
  author {
    __typename
    avatarUrl
    login
    ... on Node {
      id
    }
  }
  bodyHTML
  createdAt
  url
}

fragment crossReferencedEventsView_nodes on CrossReferencedEvent {
  id
  referencedAt
  isCrossRepository
  actor {
    __typename
    login
    avatarUrl
    ... on Node {
      id
    }
  }
  source {
    __typename
    ... on RepositoryNode {
      repository {
        name
        owner {
          __typename
          login
          id
        }
        id
      }
    }
    ... on Node {
      id
    }
  }
  ...crossReferencedEventView_item
}

fragment crossReferencedEventView_item on CrossReferencedEvent {
  id
  isCrossRepository
  source {
    __typename
    ... on Issue {
      number
      title
      url
      issueState: state
    }
    ... on PullRequest {
      number
      title
      url
      prState: state
    }
    ... on RepositoryNode {
      repository {
        name
        isPrivate
        owner {
          __typename
          login
          id
        }
        id
      }
    }
    ... on Node {
      id
    }
  }
}

fragment commitView_commit on Commit {
  author {
    name
    avatarUrl
    user {
      login
      id
    }
  }
  committer {
    name
    avatarUrl
    user {
      login
      id
    }
  }
  authoredByCommitter
  sha: oid
  message
  messageHeadlineHTML
  commitUrl
}
*/

const node /*: ConcreteRequest*/ = function () {
  var v0 = [{
    "kind": "LocalArgument",
    "name": "repoId",
    "type": "ID!",
    "defaultValue": null
  }, {
    "kind": "LocalArgument",
    "name": "issueishId",
    "type": "ID!",
    "defaultValue": null
  }, {
    "kind": "LocalArgument",
    "name": "timelineCount",
    "type": "Int!",
    "defaultValue": null
  }, {
    "kind": "LocalArgument",
    "name": "timelineCursor",
    "type": "String",
    "defaultValue": null
  }],
      v1 = [{
    "kind": "Variable",
    "name": "id",
    "variableName": "repoId",
    "type": "ID!"
  }],
      v2 = [{
    "kind": "Variable",
    "name": "timelineCount",
    "variableName": "timelineCount",
    "type": null
  }, {
    "kind": "Variable",
    "name": "timelineCursor",
    "variableName": "timelineCursor",
    "type": null
  }],
      v3 = [{
    "kind": "Variable",
    "name": "id",
    "variableName": "issueishId",
    "type": "ID!"
  }],
      v4 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "__typename",
    "args": null,
    "storageKey": null
  },
      v5 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "id",
    "args": null,
    "storageKey": null
  },
      v6 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "name",
    "args": null,
    "storageKey": null
  },
      v7 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "login",
    "args": null,
    "storageKey": null
  },
      v8 = {
    "kind": "LinkedField",
    "alias": null,
    "name": "owner",
    "storageKey": null,
    "args": null,
    "concreteType": null,
    "plural": false,
    "selections": [v4, v7, v5]
  },
      v9 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "number",
    "args": null,
    "storageKey": null
  },
      v10 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "title",
    "args": null,
    "storageKey": null
  },
      v11 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "bodyHTML",
    "args": null,
    "storageKey": null
  },
      v12 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "avatarUrl",
    "args": null,
    "storageKey": null
  },
      v13 = {
    "kind": "ScalarField",
    "alias": null,
    "name": "url",
    "args": null,
    "storageKey": null
  },
      v14 = [v13],
      v15 = [{
    "kind": "Variable",
    "name": "after",
    "variableName": "timelineCursor",
    "type": "String"
  }, {
    "kind": "Variable",
    "name": "first",
    "variableName": "timelineCount",
    "type": "Int"
  }],
      v16 = {
    "kind": "LinkedField",
    "alias": null,
    "name": "user",
    "storageKey": null,
    "args": null,
    "concreteType": "User",
    "plural": false,
    "selections": [v7, v5]
  };
  return {
    "kind": "Request",
    "operationKind": "query",
    "name": "issueDetailViewRefetchQuery",
    "id": null,
    "text": "query issueDetailViewRefetchQuery(\n  $repoId: ID!\n  $issueishId: ID!\n  $timelineCount: Int!\n  $timelineCursor: String\n) {\n  repository: node(id: $repoId) {\n    __typename\n    ...issueDetailView_repository_3D8CP9\n    id\n  }\n  issue: node(id: $issueishId) {\n    __typename\n    ...issueDetailView_issue_3D8CP9\n    id\n  }\n}\n\nfragment issueDetailView_repository_3D8CP9 on Repository {\n  id\n  name\n  owner {\n    __typename\n    login\n    id\n  }\n}\n\nfragment issueDetailView_issue_3D8CP9 on Issue {\n  __typename\n  ... on Node {\n    id\n  }\n  state\n  number\n  title\n  bodyHTML\n  author {\n    __typename\n    login\n    avatarUrl\n    ... on User {\n      url\n    }\n    ... on Bot {\n      url\n    }\n    ... on Node {\n      id\n    }\n  }\n  ...issueTimelineController_issue_3D8CP9\n  ... on UniformResourceLocatable {\n    url\n  }\n  ... on Reactable {\n    reactionGroups {\n      content\n      users {\n        totalCount\n      }\n    }\n  }\n}\n\nfragment issueTimelineController_issue_3D8CP9 on Issue {\n  url\n  timeline(first: $timelineCount, after: $timelineCursor) {\n    pageInfo {\n      endCursor\n      hasNextPage\n    }\n    edges {\n      cursor\n      node {\n        __typename\n        ...commitsView_nodes\n        ...issueCommentView_item\n        ...crossReferencedEventsView_nodes\n        ... on Node {\n          id\n        }\n      }\n    }\n  }\n}\n\nfragment commitsView_nodes on Commit {\n  id\n  author {\n    name\n    user {\n      login\n      id\n    }\n  }\n  ...commitView_commit\n}\n\nfragment issueCommentView_item on IssueComment {\n  author {\n    __typename\n    avatarUrl\n    login\n    ... on Node {\n      id\n    }\n  }\n  bodyHTML\n  createdAt\n  url\n}\n\nfragment crossReferencedEventsView_nodes on CrossReferencedEvent {\n  id\n  referencedAt\n  isCrossRepository\n  actor {\n    __typename\n    login\n    avatarUrl\n    ... on Node {\n      id\n    }\n  }\n  source {\n    __typename\n    ... on RepositoryNode {\n      repository {\n        name\n        owner {\n          __typename\n          login\n          id\n        }\n        id\n      }\n    }\n    ... on Node {\n      id\n    }\n  }\n  ...crossReferencedEventView_item\n}\n\nfragment crossReferencedEventView_item on CrossReferencedEvent {\n  id\n  isCrossRepository\n  source {\n    __typename\n    ... on Issue {\n      number\n      title\n      url\n      issueState: state\n    }\n    ... on PullRequest {\n      number\n      title\n      url\n      prState: state\n    }\n    ... on RepositoryNode {\n      repository {\n        name\n        isPrivate\n        owner {\n          __typename\n          login\n          id\n        }\n        id\n      }\n    }\n    ... on Node {\n      id\n    }\n  }\n}\n\nfragment commitView_commit on Commit {\n  author {\n    name\n    avatarUrl\n    user {\n      login\n      id\n    }\n  }\n  committer {\n    name\n    avatarUrl\n    user {\n      login\n      id\n    }\n  }\n  authoredByCommitter\n  sha: oid\n  message\n  messageHeadlineHTML\n  commitUrl\n}\n",
    "metadata": {},
    "fragment": {
      "kind": "Fragment",
      "name": "issueDetailViewRefetchQuery",
      "type": "Query",
      "metadata": null,
      "argumentDefinitions": v0,
      "selections": [{
        "kind": "LinkedField",
        "alias": "repository",
        "name": "node",
        "storageKey": null,
        "args": v1,
        "concreteType": null,
        "plural": false,
        "selections": [{
          "kind": "FragmentSpread",
          "name": "issueDetailView_repository",
          "args": v2
        }]
      }, {
        "kind": "LinkedField",
        "alias": "issue",
        "name": "node",
        "storageKey": null,
        "args": v3,
        "concreteType": null,
        "plural": false,
        "selections": [{
          "kind": "FragmentSpread",
          "name": "issueDetailView_issue",
          "args": v2
        }]
      }]
    },
    "operation": {
      "kind": "Operation",
      "name": "issueDetailViewRefetchQuery",
      "argumentDefinitions": v0,
      "selections": [{
        "kind": "LinkedField",
        "alias": "repository",
        "name": "node",
        "storageKey": null,
        "args": v1,
        "concreteType": null,
        "plural": false,
        "selections": [v4, v5, {
          "kind": "InlineFragment",
          "type": "Repository",
          "selections": [v6, v8]
        }]
      }, {
        "kind": "LinkedField",
        "alias": "issue",
        "name": "node",
        "storageKey": null,
        "args": v3,
        "concreteType": null,
        "plural": false,
        "selections": [v4, v5, {
          "kind": "InlineFragment",
          "type": "Issue",
          "selections": [v4, {
            "kind": "ScalarField",
            "alias": null,
            "name": "state",
            "args": null,
            "storageKey": null
          }, v9, v10, v11, {
            "kind": "LinkedField",
            "alias": null,
            "name": "author",
            "storageKey": null,
            "args": null,
            "concreteType": null,
            "plural": false,
            "selections": [v4, v7, v12, v5, {
              "kind": "InlineFragment",
              "type": "Bot",
              "selections": v14
            }, {
              "kind": "InlineFragment",
              "type": "User",
              "selections": v14
            }]
          }, v13, {
            "kind": "LinkedField",
            "alias": null,
            "name": "timeline",
            "storageKey": null,
            "args": v15,
            "concreteType": "IssueTimelineConnection",
            "plural": false,
            "selections": [{
              "kind": "LinkedField",
              "alias": null,
              "name": "pageInfo",
              "storageKey": null,
              "args": null,
              "concreteType": "PageInfo",
              "plural": false,
              "selections": [{
                "kind": "ScalarField",
                "alias": null,
                "name": "endCursor",
                "args": null,
                "storageKey": null
              }, {
                "kind": "ScalarField",
                "alias": null,
                "name": "hasNextPage",
                "args": null,
                "storageKey": null
              }]
            }, {
              "kind": "LinkedField",
              "alias": null,
              "name": "edges",
              "storageKey": null,
              "args": null,
              "concreteType": "IssueTimelineItemEdge",
              "plural": true,
              "selections": [{
                "kind": "ScalarField",
                "alias": null,
                "name": "cursor",
                "args": null,
                "storageKey": null
              }, {
                "kind": "LinkedField",
                "alias": null,
                "name": "node",
                "storageKey": null,
                "args": null,
                "concreteType": null,
                "plural": false,
                "selections": [v4, v5, {
                  "kind": "InlineFragment",
                  "type": "CrossReferencedEvent",
                  "selections": [{
                    "kind": "ScalarField",
                    "alias": null,
                    "name": "referencedAt",
                    "args": null,
                    "storageKey": null
                  }, {
                    "kind": "ScalarField",
                    "alias": null,
                    "name": "isCrossRepository",
                    "args": null,
                    "storageKey": null
                  }, {
                    "kind": "LinkedField",
                    "alias": null,
                    "name": "actor",
                    "storageKey": null,
                    "args": null,
                    "concreteType": null,
                    "plural": false,
                    "selections": [v4, v7, v12, v5]
                  }, {
                    "kind": "LinkedField",
                    "alias": null,
                    "name": "source",
                    "storageKey": null,
                    "args": null,
                    "concreteType": null,
                    "plural": false,
                    "selections": [v4, {
                      "kind": "LinkedField",
                      "alias": null,
                      "name": "repository",
                      "storageKey": null,
                      "args": null,
                      "concreteType": "Repository",
                      "plural": false,
                      "selections": [v6, v8, v5, {
                        "kind": "ScalarField",
                        "alias": null,
                        "name": "isPrivate",
                        "args": null,
                        "storageKey": null
                      }]
                    }, v5, {
                      "kind": "InlineFragment",
                      "type": "PullRequest",
                      "selections": [v9, v10, v13, {
                        "kind": "ScalarField",
                        "alias": "prState",
                        "name": "state",
                        "args": null,
                        "storageKey": null
                      }]
                    }, {
                      "kind": "InlineFragment",
                      "type": "Issue",
                      "selections": [v9, v10, v13, {
                        "kind": "ScalarField",
                        "alias": "issueState",
                        "name": "state",
                        "args": null,
                        "storageKey": null
                      }]
                    }]
                  }]
                }, {
                  "kind": "InlineFragment",
                  "type": "IssueComment",
                  "selections": [{
                    "kind": "LinkedField",
                    "alias": null,
                    "name": "author",
                    "storageKey": null,
                    "args": null,
                    "concreteType": null,
                    "plural": false,
                    "selections": [v4, v12, v7, v5]
                  }, v11, {
                    "kind": "ScalarField",
                    "alias": null,
                    "name": "createdAt",
                    "args": null,
                    "storageKey": null
                  }, v13]
                }, {
                  "kind": "InlineFragment",
                  "type": "Commit",
                  "selections": [{
                    "kind": "LinkedField",
                    "alias": null,
                    "name": "author",
                    "storageKey": null,
                    "args": null,
                    "concreteType": "GitActor",
                    "plural": false,
                    "selections": [v6, v16, v12]
                  }, {
                    "kind": "LinkedField",
                    "alias": null,
                    "name": "committer",
                    "storageKey": null,
                    "args": null,
                    "concreteType": "GitActor",
                    "plural": false,
                    "selections": [v6, v12, v16]
                  }, {
                    "kind": "ScalarField",
                    "alias": null,
                    "name": "authoredByCommitter",
                    "args": null,
                    "storageKey": null
                  }, {
                    "kind": "ScalarField",
                    "alias": "sha",
                    "name": "oid",
                    "args": null,
                    "storageKey": null
                  }, {
                    "kind": "ScalarField",
                    "alias": null,
                    "name": "message",
                    "args": null,
                    "storageKey": null
                  }, {
                    "kind": "ScalarField",
                    "alias": null,
                    "name": "messageHeadlineHTML",
                    "args": null,
                    "storageKey": null
                  }, {
                    "kind": "ScalarField",
                    "alias": null,
                    "name": "commitUrl",
                    "args": null,
                    "storageKey": null
                  }]
                }]
              }]
            }]
          }, {
            "kind": "LinkedHandle",
            "alias": null,
            "name": "timeline",
            "args": v15,
            "handle": "connection",
            "key": "IssueTimelineController_timeline",
            "filters": null
          }, {
            "kind": "LinkedField",
            "alias": null,
            "name": "reactionGroups",
            "storageKey": null,
            "args": null,
            "concreteType": "ReactionGroup",
            "plural": true,
            "selections": [{
              "kind": "ScalarField",
              "alias": null,
              "name": "content",
              "args": null,
              "storageKey": null
            }, {
              "kind": "LinkedField",
              "alias": null,
              "name": "users",
              "storageKey": null,
              "args": null,
              "concreteType": "ReactingUserConnection",
              "plural": false,
              "selections": [{
                "kind": "ScalarField",
                "alias": null,
                "name": "totalCount",
                "args": null,
                "storageKey": null
              }]
            }]
          }]
        }]
      }]
    }
  };
}();
// prettier-ignore
node /*: any*/.hash = '82666b2748036545eb131b3e34f48e72';
module.exports = node;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlRGV0YWlsVmlld1JlZmV0Y2hRdWVyeS5ncmFwaHFsLmpzIl0sIm5hbWVzIjpbIm5vZGUiLCJ2MCIsInYxIiwidjIiLCJ2MyIsInY0IiwidjUiLCJ2NiIsInY3IiwidjgiLCJ2OSIsInYxMCIsInYxMSIsInYxMiIsInYxMyIsInYxNCIsInYxNSIsInYxNiIsImhhc2giLCJtb2R1bGUiLCJleHBvcnRzIl0sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7QUFLQTs7QUFFQTs7QUFFQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBeUJBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQThNQSxNQUFNQSxLQUFJLHFCQUFKLEdBQTZCLFlBQVU7QUFDN0MsTUFBSUMsS0FBSyxDQUNQO0FBQ0UsWUFBUSxlQURWO0FBRUUsWUFBUSxRQUZWO0FBR0UsWUFBUSxLQUhWO0FBSUUsb0JBQWdCO0FBSmxCLEdBRE8sRUFPUDtBQUNFLFlBQVEsZUFEVjtBQUVFLFlBQVEsWUFGVjtBQUdFLFlBQVEsS0FIVjtBQUlFLG9CQUFnQjtBQUpsQixHQVBPLEVBYVA7QUFDRSxZQUFRLGVBRFY7QUFFRSxZQUFRLGVBRlY7QUFHRSxZQUFRLE1BSFY7QUFJRSxvQkFBZ0I7QUFKbEIsR0FiTyxFQW1CUDtBQUNFLFlBQVEsZUFEVjtBQUVFLFlBQVEsZ0JBRlY7QUFHRSxZQUFRLFFBSFY7QUFJRSxvQkFBZ0I7QUFKbEIsR0FuQk8sQ0FBVDtBQUFBLE1BMEJBQyxLQUFLLENBQ0g7QUFDRSxZQUFRLFVBRFY7QUFFRSxZQUFRLElBRlY7QUFHRSxvQkFBZ0IsUUFIbEI7QUFJRSxZQUFRO0FBSlYsR0FERyxDQTFCTDtBQUFBLE1Ba0NBQyxLQUFLLENBQ0g7QUFDRSxZQUFRLFVBRFY7QUFFRSxZQUFRLGVBRlY7QUFHRSxvQkFBZ0IsZUFIbEI7QUFJRSxZQUFRO0FBSlYsR0FERyxFQU9IO0FBQ0UsWUFBUSxVQURWO0FBRUUsWUFBUSxnQkFGVjtBQUdFLG9CQUFnQixnQkFIbEI7QUFJRSxZQUFRO0FBSlYsR0FQRyxDQWxDTDtBQUFBLE1BZ0RBQyxLQUFLLENBQ0g7QUFDRSxZQUFRLFVBRFY7QUFFRSxZQUFRLElBRlY7QUFHRSxvQkFBZ0IsWUFIbEI7QUFJRSxZQUFRO0FBSlYsR0FERyxDQWhETDtBQUFBLE1Bd0RBQyxLQUFLO0FBQ0gsWUFBUSxhQURMO0FBRUgsYUFBUyxJQUZOO0FBR0gsWUFBUSxZQUhMO0FBSUgsWUFBUSxJQUpMO0FBS0gsa0JBQWM7QUFMWCxHQXhETDtBQUFBLE1BK0RBQyxLQUFLO0FBQ0gsWUFBUSxhQURMO0FBRUgsYUFBUyxJQUZOO0FBR0gsWUFBUSxJQUhMO0FBSUgsWUFBUSxJQUpMO0FBS0gsa0JBQWM7QUFMWCxHQS9ETDtBQUFBLE1Bc0VBQyxLQUFLO0FBQ0gsWUFBUSxhQURMO0FBRUgsYUFBUyxJQUZOO0FBR0gsWUFBUSxNQUhMO0FBSUgsWUFBUSxJQUpMO0FBS0gsa0JBQWM7QUFMWCxHQXRFTDtBQUFBLE1BNkVBQyxLQUFLO0FBQ0gsWUFBUSxhQURMO0FBRUgsYUFBUyxJQUZOO0FBR0gsWUFBUSxPQUhMO0FBSUgsWUFBUSxJQUpMO0FBS0gsa0JBQWM7QUFMWCxHQTdFTDtBQUFBLE1Bb0ZBQyxLQUFLO0FBQ0gsWUFBUSxhQURMO0FBRUgsYUFBUyxJQUZOO0FBR0gsWUFBUSxPQUhMO0FBSUgsa0JBQWMsSUFKWDtBQUtILFlBQVEsSUFMTDtBQU1ILG9CQUFnQixJQU5iO0FBT0gsY0FBVSxLQVBQO0FBUUgsa0JBQWMsQ0FDWkosRUFEWSxFQUVaRyxFQUZZLEVBR1pGLEVBSFk7QUFSWCxHQXBGTDtBQUFBLE1Ba0dBSSxLQUFLO0FBQ0gsWUFBUSxhQURMO0FBRUgsYUFBUyxJQUZOO0FBR0gsWUFBUSxRQUhMO0FBSUgsWUFBUSxJQUpMO0FBS0gsa0JBQWM7QUFMWCxHQWxHTDtBQUFBLE1BeUdBQyxNQUFNO0FBQ0osWUFBUSxhQURKO0FBRUosYUFBUyxJQUZMO0FBR0osWUFBUSxPQUhKO0FBSUosWUFBUSxJQUpKO0FBS0osa0JBQWM7QUFMVixHQXpHTjtBQUFBLE1BZ0hBQyxNQUFNO0FBQ0osWUFBUSxhQURKO0FBRUosYUFBUyxJQUZMO0FBR0osWUFBUSxVQUhKO0FBSUosWUFBUSxJQUpKO0FBS0osa0JBQWM7QUFMVixHQWhITjtBQUFBLE1BdUhBQyxNQUFNO0FBQ0osWUFBUSxhQURKO0FBRUosYUFBUyxJQUZMO0FBR0osWUFBUSxXQUhKO0FBSUosWUFBUSxJQUpKO0FBS0osa0JBQWM7QUFMVixHQXZITjtBQUFBLE1BOEhBQyxNQUFNO0FBQ0osWUFBUSxhQURKO0FBRUosYUFBUyxJQUZMO0FBR0osWUFBUSxLQUhKO0FBSUosWUFBUSxJQUpKO0FBS0osa0JBQWM7QUFMVixHQTlITjtBQUFBLE1BcUlBQyxNQUFNLENBQ0pELEdBREksQ0FySU47QUFBQSxNQXdJQUUsTUFBTSxDQUNKO0FBQ0UsWUFBUSxVQURWO0FBRUUsWUFBUSxPQUZWO0FBR0Usb0JBQWdCLGdCQUhsQjtBQUlFLFlBQVE7QUFKVixHQURJLEVBT0o7QUFDRSxZQUFRLFVBRFY7QUFFRSxZQUFRLE9BRlY7QUFHRSxvQkFBZ0IsZUFIbEI7QUFJRSxZQUFRO0FBSlYsR0FQSSxDQXhJTjtBQUFBLE1Bc0pBQyxNQUFNO0FBQ0osWUFBUSxhQURKO0FBRUosYUFBUyxJQUZMO0FBR0osWUFBUSxNQUhKO0FBSUosa0JBQWMsSUFKVjtBQUtKLFlBQVEsSUFMSjtBQU1KLG9CQUFnQixNQU5aO0FBT0osY0FBVSxLQVBOO0FBUUosa0JBQWMsQ0FDWlQsRUFEWSxFQUVaRixFQUZZO0FBUlYsR0F0Sk47QUFtS0EsU0FBTztBQUNMLFlBQVEsU0FESDtBQUVMLHFCQUFpQixPQUZaO0FBR0wsWUFBUSw2QkFISDtBQUlMLFVBQU0sSUFKRDtBQUtMLFlBQVEseS9GQUxIO0FBTUwsZ0JBQVksRUFOUDtBQU9MLGdCQUFZO0FBQ1YsY0FBUSxVQURFO0FBRVYsY0FBUSw2QkFGRTtBQUdWLGNBQVEsT0FIRTtBQUlWLGtCQUFZLElBSkY7QUFLViw2QkFBdUJMLEVBTGI7QUFNVixvQkFBYyxDQUNaO0FBQ0UsZ0JBQVEsYUFEVjtBQUVFLGlCQUFTLFlBRlg7QUFHRSxnQkFBUSxNQUhWO0FBSUUsc0JBQWMsSUFKaEI7QUFLRSxnQkFBUUMsRUFMVjtBQU1FLHdCQUFnQixJQU5sQjtBQU9FLGtCQUFVLEtBUFo7QUFRRSxzQkFBYyxDQUNaO0FBQ0Usa0JBQVEsZ0JBRFY7QUFFRSxrQkFBUSw0QkFGVjtBQUdFLGtCQUFRQztBQUhWLFNBRFk7QUFSaEIsT0FEWSxFQWlCWjtBQUNFLGdCQUFRLGFBRFY7QUFFRSxpQkFBUyxPQUZYO0FBR0UsZ0JBQVEsTUFIVjtBQUlFLHNCQUFjLElBSmhCO0FBS0UsZ0JBQVFDLEVBTFY7QUFNRSx3QkFBZ0IsSUFObEI7QUFPRSxrQkFBVSxLQVBaO0FBUUUsc0JBQWMsQ0FDWjtBQUNFLGtCQUFRLGdCQURWO0FBRUUsa0JBQVEsdUJBRlY7QUFHRSxrQkFBUUQ7QUFIVixTQURZO0FBUmhCLE9BakJZO0FBTkosS0FQUDtBQWdETCxpQkFBYTtBQUNYLGNBQVEsV0FERztBQUVYLGNBQVEsNkJBRkc7QUFHWCw2QkFBdUJGLEVBSFo7QUFJWCxvQkFBYyxDQUNaO0FBQ0UsZ0JBQVEsYUFEVjtBQUVFLGlCQUFTLFlBRlg7QUFHRSxnQkFBUSxNQUhWO0FBSUUsc0JBQWMsSUFKaEI7QUFLRSxnQkFBUUMsRUFMVjtBQU1FLHdCQUFnQixJQU5sQjtBQU9FLGtCQUFVLEtBUFo7QUFRRSxzQkFBYyxDQUNaRyxFQURZLEVBRVpDLEVBRlksRUFHWjtBQUNFLGtCQUFRLGdCQURWO0FBRUUsa0JBQVEsWUFGVjtBQUdFLHdCQUFjLENBQ1pDLEVBRFksRUFFWkUsRUFGWTtBQUhoQixTQUhZO0FBUmhCLE9BRFksRUFzQlo7QUFDRSxnQkFBUSxhQURWO0FBRUUsaUJBQVMsT0FGWDtBQUdFLGdCQUFRLE1BSFY7QUFJRSxzQkFBYyxJQUpoQjtBQUtFLGdCQUFRTCxFQUxWO0FBTUUsd0JBQWdCLElBTmxCO0FBT0Usa0JBQVUsS0FQWjtBQVFFLHNCQUFjLENBQ1pDLEVBRFksRUFFWkMsRUFGWSxFQUdaO0FBQ0Usa0JBQVEsZ0JBRFY7QUFFRSxrQkFBUSxPQUZWO0FBR0Usd0JBQWMsQ0FDWkQsRUFEWSxFQUVaO0FBQ0Usb0JBQVEsYUFEVjtBQUVFLHFCQUFTLElBRlg7QUFHRSxvQkFBUSxPQUhWO0FBSUUsb0JBQVEsSUFKVjtBQUtFLDBCQUFjO0FBTGhCLFdBRlksRUFTWkssRUFUWSxFQVVaQyxHQVZZLEVBV1pDLEdBWFksRUFZWjtBQUNFLG9CQUFRLGFBRFY7QUFFRSxxQkFBUyxJQUZYO0FBR0Usb0JBQVEsUUFIVjtBQUlFLDBCQUFjLElBSmhCO0FBS0Usb0JBQVEsSUFMVjtBQU1FLDRCQUFnQixJQU5sQjtBQU9FLHNCQUFVLEtBUFo7QUFRRSwwQkFBYyxDQUNaUCxFQURZLEVBRVpHLEVBRlksRUFHWkssR0FIWSxFQUlaUCxFQUpZLEVBS1o7QUFDRSxzQkFBUSxnQkFEVjtBQUVFLHNCQUFRLEtBRlY7QUFHRSw0QkFBY1M7QUFIaEIsYUFMWSxFQVVaO0FBQ0Usc0JBQVEsZ0JBRFY7QUFFRSxzQkFBUSxNQUZWO0FBR0UsNEJBQWNBO0FBSGhCLGFBVlk7QUFSaEIsV0FaWSxFQXFDWkQsR0FyQ1ksRUFzQ1o7QUFDRSxvQkFBUSxhQURWO0FBRUUscUJBQVMsSUFGWDtBQUdFLG9CQUFRLFVBSFY7QUFJRSwwQkFBYyxJQUpoQjtBQUtFLG9CQUFRRSxHQUxWO0FBTUUsNEJBQWdCLHlCQU5sQjtBQU9FLHNCQUFVLEtBUFo7QUFRRSwwQkFBYyxDQUNaO0FBQ0Usc0JBQVEsYUFEVjtBQUVFLHVCQUFTLElBRlg7QUFHRSxzQkFBUSxVQUhWO0FBSUUsNEJBQWMsSUFKaEI7QUFLRSxzQkFBUSxJQUxWO0FBTUUsOEJBQWdCLFVBTmxCO0FBT0Usd0JBQVUsS0FQWjtBQVFFLDRCQUFjLENBQ1o7QUFDRSx3QkFBUSxhQURWO0FBRUUseUJBQVMsSUFGWDtBQUdFLHdCQUFRLFdBSFY7QUFJRSx3QkFBUSxJQUpWO0FBS0UsOEJBQWM7QUFMaEIsZUFEWSxFQVFaO0FBQ0Usd0JBQVEsYUFEVjtBQUVFLHlCQUFTLElBRlg7QUFHRSx3QkFBUSxhQUhWO0FBSUUsd0JBQVEsSUFKVjtBQUtFLDhCQUFjO0FBTGhCLGVBUlk7QUFSaEIsYUFEWSxFQTBCWjtBQUNFLHNCQUFRLGFBRFY7QUFFRSx1QkFBUyxJQUZYO0FBR0Usc0JBQVEsT0FIVjtBQUlFLDRCQUFjLElBSmhCO0FBS0Usc0JBQVEsSUFMVjtBQU1FLDhCQUFnQix1QkFObEI7QUFPRSx3QkFBVSxJQVBaO0FBUUUsNEJBQWMsQ0FDWjtBQUNFLHdCQUFRLGFBRFY7QUFFRSx5QkFBUyxJQUZYO0FBR0Usd0JBQVEsUUFIVjtBQUlFLHdCQUFRLElBSlY7QUFLRSw4QkFBYztBQUxoQixlQURZLEVBUVo7QUFDRSx3QkFBUSxhQURWO0FBRUUseUJBQVMsSUFGWDtBQUdFLHdCQUFRLE1BSFY7QUFJRSw4QkFBYyxJQUpoQjtBQUtFLHdCQUFRLElBTFY7QUFNRSxnQ0FBZ0IsSUFObEI7QUFPRSwwQkFBVSxLQVBaO0FBUUUsOEJBQWMsQ0FDWlgsRUFEWSxFQUVaQyxFQUZZLEVBR1o7QUFDRSwwQkFBUSxnQkFEVjtBQUVFLDBCQUFRLHNCQUZWO0FBR0UsZ0NBQWMsQ0FDWjtBQUNFLDRCQUFRLGFBRFY7QUFFRSw2QkFBUyxJQUZYO0FBR0UsNEJBQVEsY0FIVjtBQUlFLDRCQUFRLElBSlY7QUFLRSxrQ0FBYztBQUxoQixtQkFEWSxFQVFaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxtQkFIVjtBQUlFLDRCQUFRLElBSlY7QUFLRSxrQ0FBYztBQUxoQixtQkFSWSxFQWVaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxPQUhWO0FBSUUsa0NBQWMsSUFKaEI7QUFLRSw0QkFBUSxJQUxWO0FBTUUsb0NBQWdCLElBTmxCO0FBT0UsOEJBQVUsS0FQWjtBQVFFLGtDQUFjLENBQ1pELEVBRFksRUFFWkcsRUFGWSxFQUdaSyxHQUhZLEVBSVpQLEVBSlk7QUFSaEIsbUJBZlksRUE4Qlo7QUFDRSw0QkFBUSxhQURWO0FBRUUsNkJBQVMsSUFGWDtBQUdFLDRCQUFRLFFBSFY7QUFJRSxrQ0FBYyxJQUpoQjtBQUtFLDRCQUFRLElBTFY7QUFNRSxvQ0FBZ0IsSUFObEI7QUFPRSw4QkFBVSxLQVBaO0FBUUUsa0NBQWMsQ0FDWkQsRUFEWSxFQUVaO0FBQ0UsOEJBQVEsYUFEVjtBQUVFLCtCQUFTLElBRlg7QUFHRSw4QkFBUSxZQUhWO0FBSUUsb0NBQWMsSUFKaEI7QUFLRSw4QkFBUSxJQUxWO0FBTUUsc0NBQWdCLFlBTmxCO0FBT0UsZ0NBQVUsS0FQWjtBQVFFLG9DQUFjLENBQ1pFLEVBRFksRUFFWkUsRUFGWSxFQUdaSCxFQUhZLEVBSVo7QUFDRSxnQ0FBUSxhQURWO0FBRUUsaUNBQVMsSUFGWDtBQUdFLGdDQUFRLFdBSFY7QUFJRSxnQ0FBUSxJQUpWO0FBS0Usc0NBQWM7QUFMaEIsdUJBSlk7QUFSaEIscUJBRlksRUF1QlpBLEVBdkJZLEVBd0JaO0FBQ0UsOEJBQVEsZ0JBRFY7QUFFRSw4QkFBUSxhQUZWO0FBR0Usb0NBQWMsQ0FDWkksRUFEWSxFQUVaQyxHQUZZLEVBR1pHLEdBSFksRUFJWjtBQUNFLGdDQUFRLGFBRFY7QUFFRSxpQ0FBUyxTQUZYO0FBR0UsZ0NBQVEsT0FIVjtBQUlFLGdDQUFRLElBSlY7QUFLRSxzQ0FBYztBQUxoQix1QkFKWTtBQUhoQixxQkF4QlksRUF3Q1o7QUFDRSw4QkFBUSxnQkFEVjtBQUVFLDhCQUFRLE9BRlY7QUFHRSxvQ0FBYyxDQUNaSixFQURZLEVBRVpDLEdBRlksRUFHWkcsR0FIWSxFQUlaO0FBQ0UsZ0NBQVEsYUFEVjtBQUVFLGlDQUFTLFlBRlg7QUFHRSxnQ0FBUSxPQUhWO0FBSUUsZ0NBQVEsSUFKVjtBQUtFLHNDQUFjO0FBTGhCLHVCQUpZO0FBSGhCLHFCQXhDWTtBQVJoQixtQkE5Qlk7QUFIaEIsaUJBSFksRUF3R1o7QUFDRSwwQkFBUSxnQkFEVjtBQUVFLDBCQUFRLGNBRlY7QUFHRSxnQ0FBYyxDQUNaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxRQUhWO0FBSUUsa0NBQWMsSUFKaEI7QUFLRSw0QkFBUSxJQUxWO0FBTUUsb0NBQWdCLElBTmxCO0FBT0UsOEJBQVUsS0FQWjtBQVFFLGtDQUFjLENBQ1pULEVBRFksRUFFWlEsR0FGWSxFQUdaTCxFQUhZLEVBSVpGLEVBSlk7QUFSaEIsbUJBRFksRUFnQlpNLEdBaEJZLEVBaUJaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxXQUhWO0FBSUUsNEJBQVEsSUFKVjtBQUtFLGtDQUFjO0FBTGhCLG1CQWpCWSxFQXdCWkUsR0F4Qlk7QUFIaEIsaUJBeEdZLEVBc0laO0FBQ0UsMEJBQVEsZ0JBRFY7QUFFRSwwQkFBUSxRQUZWO0FBR0UsZ0NBQWMsQ0FDWjtBQUNFLDRCQUFRLGFBRFY7QUFFRSw2QkFBUyxJQUZYO0FBR0UsNEJBQVEsUUFIVjtBQUlFLGtDQUFjLElBSmhCO0FBS0UsNEJBQVEsSUFMVjtBQU1FLG9DQUFnQixVQU5sQjtBQU9FLDhCQUFVLEtBUFo7QUFRRSxrQ0FBYyxDQUNaUCxFQURZLEVBRVpVLEdBRlksRUFHWkosR0FIWTtBQVJoQixtQkFEWSxFQWVaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxXQUhWO0FBSUUsa0NBQWMsSUFKaEI7QUFLRSw0QkFBUSxJQUxWO0FBTUUsb0NBQWdCLFVBTmxCO0FBT0UsOEJBQVUsS0FQWjtBQVFFLGtDQUFjLENBQ1pOLEVBRFksRUFFWk0sR0FGWSxFQUdaSSxHQUhZO0FBUmhCLG1CQWZZLEVBNkJaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxxQkFIVjtBQUlFLDRCQUFRLElBSlY7QUFLRSxrQ0FBYztBQUxoQixtQkE3QlksRUFvQ1o7QUFDRSw0QkFBUSxhQURWO0FBRUUsNkJBQVMsS0FGWDtBQUdFLDRCQUFRLEtBSFY7QUFJRSw0QkFBUSxJQUpWO0FBS0Usa0NBQWM7QUFMaEIsbUJBcENZLEVBMkNaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxTQUhWO0FBSUUsNEJBQVEsSUFKVjtBQUtFLGtDQUFjO0FBTGhCLG1CQTNDWSxFQWtEWjtBQUNFLDRCQUFRLGFBRFY7QUFFRSw2QkFBUyxJQUZYO0FBR0UsNEJBQVEscUJBSFY7QUFJRSw0QkFBUSxJQUpWO0FBS0Usa0NBQWM7QUFMaEIsbUJBbERZLEVBeURaO0FBQ0UsNEJBQVEsYUFEVjtBQUVFLDZCQUFTLElBRlg7QUFHRSw0QkFBUSxXQUhWO0FBSUUsNEJBQVEsSUFKVjtBQUtFLGtDQUFjO0FBTGhCLG1CQXpEWTtBQUhoQixpQkF0SVk7QUFSaEIsZUFSWTtBQVJoQixhQTFCWTtBQVJoQixXQXRDWSxFQWlUWjtBQUNFLG9CQUFRLGNBRFY7QUFFRSxxQkFBUyxJQUZYO0FBR0Usb0JBQVEsVUFIVjtBQUlFLG9CQUFRRCxHQUpWO0FBS0Usc0JBQVUsWUFMWjtBQU1FLG1CQUFPLGtDQU5UO0FBT0UsdUJBQVc7QUFQYixXQWpUWSxFQTBUWjtBQUNFLG9CQUFRLGFBRFY7QUFFRSxxQkFBUyxJQUZYO0FBR0Usb0JBQVEsZ0JBSFY7QUFJRSwwQkFBYyxJQUpoQjtBQUtFLG9CQUFRLElBTFY7QUFNRSw0QkFBZ0IsZUFObEI7QUFPRSxzQkFBVSxJQVBaO0FBUUUsMEJBQWMsQ0FDWjtBQUNFLHNCQUFRLGFBRFY7QUFFRSx1QkFBUyxJQUZYO0FBR0Usc0JBQVEsU0FIVjtBQUlFLHNCQUFRLElBSlY7QUFLRSw0QkFBYztBQUxoQixhQURZLEVBUVo7QUFDRSxzQkFBUSxhQURWO0FBRUUsdUJBQVMsSUFGWDtBQUdFLHNCQUFRLE9BSFY7QUFJRSw0QkFBYyxJQUpoQjtBQUtFLHNCQUFRLElBTFY7QUFNRSw4QkFBZ0Isd0JBTmxCO0FBT0Usd0JBQVUsS0FQWjtBQVFFLDRCQUFjLENBQ1o7QUFDRSx3QkFBUSxhQURWO0FBRUUseUJBQVMsSUFGWDtBQUdFLHdCQUFRLFlBSFY7QUFJRSx3QkFBUSxJQUpWO0FBS0UsOEJBQWM7QUFMaEIsZUFEWTtBQVJoQixhQVJZO0FBUmhCLFdBMVRZO0FBSGhCLFNBSFk7QUFSaEIsT0F0Qlk7QUFKSDtBQWhEUixHQUFQO0FBNmJDLENBam1CaUMsRUFBbEM7QUFrbUJBO0FBQ0NoQixJQUFELENBQUssU0FBTCxDQUFnQmtCLElBQWhCLEdBQXVCLGtDQUF2QjtBQUNBQyxPQUFPQyxPQUFQLEdBQWlCcEIsSUFBakIiLCJmaWxlIjoiaXNzdWVEZXRhaWxWaWV3UmVmZXRjaFF1ZXJ5LmdyYXBocWwuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvdmlld3MvX19nZW5lcmF0ZWRfXyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGZsb3dcbiAqIEByZWxheUhhc2ggMGRlOGYzYjgwYTcxMTVlMmZiOTAzMDFlMzljNDU5MWRcbiAqL1xuXG4vKiBlc2xpbnQtZGlzYWJsZSAqL1xuXG4ndXNlIHN0cmljdCc7XG5cbi8qOjpcbmltcG9ydCB0eXBlIHsgQ29uY3JldGVSZXF1ZXN0IH0gZnJvbSAncmVsYXktcnVudGltZSc7XG50eXBlIGlzc3VlRGV0YWlsVmlld19pc3N1ZSRyZWYgPSBhbnk7XG50eXBlIGlzc3VlRGV0YWlsVmlld19yZXBvc2l0b3J5JHJlZiA9IGFueTtcbmV4cG9ydCB0eXBlIGlzc3VlRGV0YWlsVmlld1JlZmV0Y2hRdWVyeVZhcmlhYmxlcyA9IHt8XG4gIHJlcG9JZDogc3RyaW5nLFxuICBpc3N1ZWlzaElkOiBzdHJpbmcsXG4gIHRpbWVsaW5lQ291bnQ6IG51bWJlcixcbiAgdGltZWxpbmVDdXJzb3I/OiA/c3RyaW5nLFxufH07XG5leHBvcnQgdHlwZSBpc3N1ZURldGFpbFZpZXdSZWZldGNoUXVlcnlSZXNwb25zZSA9IHt8XG4gICtyZXBvc2l0b3J5OiA/e3xcbiAgICArJGZyYWdtZW50UmVmczogaXNzdWVEZXRhaWxWaWV3X3JlcG9zaXRvcnkkcmVmXG4gIHx9LFxuICAraXNzdWU6ID97fFxuICAgICskZnJhZ21lbnRSZWZzOiBpc3N1ZURldGFpbFZpZXdfaXNzdWUkcmVmXG4gIHx9LFxufH07XG5leHBvcnQgdHlwZSBpc3N1ZURldGFpbFZpZXdSZWZldGNoUXVlcnkgPSB7fFxuICB2YXJpYWJsZXM6IGlzc3VlRGV0YWlsVmlld1JlZmV0Y2hRdWVyeVZhcmlhYmxlcyxcbiAgcmVzcG9uc2U6IGlzc3VlRGV0YWlsVmlld1JlZmV0Y2hRdWVyeVJlc3BvbnNlLFxufH07XG4qL1xuXG5cbi8qXG5xdWVyeSBpc3N1ZURldGFpbFZpZXdSZWZldGNoUXVlcnkoXG4gICRyZXBvSWQ6IElEIVxuICAkaXNzdWVpc2hJZDogSUQhXG4gICR0aW1lbGluZUNvdW50OiBJbnQhXG4gICR0aW1lbGluZUN1cnNvcjogU3RyaW5nXG4pIHtcbiAgcmVwb3NpdG9yeTogbm9kZShpZDogJHJlcG9JZCkge1xuICAgIF9fdHlwZW5hbWVcbiAgICAuLi5pc3N1ZURldGFpbFZpZXdfcmVwb3NpdG9yeV8zRDhDUDlcbiAgICBpZFxuICB9XG4gIGlzc3VlOiBub2RlKGlkOiAkaXNzdWVpc2hJZCkge1xuICAgIF9fdHlwZW5hbWVcbiAgICAuLi5pc3N1ZURldGFpbFZpZXdfaXNzdWVfM0Q4Q1A5XG4gICAgaWRcbiAgfVxufVxuXG5mcmFnbWVudCBpc3N1ZURldGFpbFZpZXdfcmVwb3NpdG9yeV8zRDhDUDkgb24gUmVwb3NpdG9yeSB7XG4gIGlkXG4gIG5hbWVcbiAgb3duZXIge1xuICAgIF9fdHlwZW5hbWVcbiAgICBsb2dpblxuICAgIGlkXG4gIH1cbn1cblxuZnJhZ21lbnQgaXNzdWVEZXRhaWxWaWV3X2lzc3VlXzNEOENQOSBvbiBJc3N1ZSB7XG4gIF9fdHlwZW5hbWVcbiAgLi4uIG9uIE5vZGUge1xuICAgIGlkXG4gIH1cbiAgc3RhdGVcbiAgbnVtYmVyXG4gIHRpdGxlXG4gIGJvZHlIVE1MXG4gIGF1dGhvciB7XG4gICAgX190eXBlbmFtZVxuICAgIGxvZ2luXG4gICAgYXZhdGFyVXJsXG4gICAgLi4uIG9uIFVzZXIge1xuICAgICAgdXJsXG4gICAgfVxuICAgIC4uLiBvbiBCb3Qge1xuICAgICAgdXJsXG4gICAgfVxuICAgIC4uLiBvbiBOb2RlIHtcbiAgICAgIGlkXG4gICAgfVxuICB9XG4gIC4uLmlzc3VlVGltZWxpbmVDb250cm9sbGVyX2lzc3VlXzNEOENQOVxuICAuLi4gb24gVW5pZm9ybVJlc291cmNlTG9jYXRhYmxlIHtcbiAgICB1cmxcbiAgfVxuICAuLi4gb24gUmVhY3RhYmxlIHtcbiAgICByZWFjdGlvbkdyb3VwcyB7XG4gICAgICBjb250ZW50XG4gICAgICB1c2VycyB7XG4gICAgICAgIHRvdGFsQ291bnRcbiAgICAgIH1cbiAgICB9XG4gIH1cbn1cblxuZnJhZ21lbnQgaXNzdWVUaW1lbGluZUNvbnRyb2xsZXJfaXNzdWVfM0Q4Q1A5IG9uIElzc3VlIHtcbiAgdXJsXG4gIHRpbWVsaW5lKGZpcnN0OiAkdGltZWxpbmVDb3VudCwgYWZ0ZXI6ICR0aW1lbGluZUN1cnNvcikge1xuICAgIHBhZ2VJbmZvIHtcbiAgICAgIGVuZEN1cnNvclxuICAgICAgaGFzTmV4dFBhZ2VcbiAgICB9XG4gICAgZWRnZXMge1xuICAgICAgY3Vyc29yXG4gICAgICBub2RlIHtcbiAgICAgICAgX190eXBlbmFtZVxuICAgICAgICAuLi5jb21taXRzVmlld19ub2Rlc1xuICAgICAgICAuLi5pc3N1ZUNvbW1lbnRWaWV3X2l0ZW1cbiAgICAgICAgLi4uY3Jvc3NSZWZlcmVuY2VkRXZlbnRzVmlld19ub2Rlc1xuICAgICAgICAuLi4gb24gTm9kZSB7XG4gICAgICAgICAgaWRcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxufVxuXG5mcmFnbWVudCBjb21taXRzVmlld19ub2RlcyBvbiBDb21taXQge1xuICBpZFxuICBhdXRob3Ige1xuICAgIG5hbWVcbiAgICB1c2VyIHtcbiAgICAgIGxvZ2luXG4gICAgICBpZFxuICAgIH1cbiAgfVxuICAuLi5jb21taXRWaWV3X2NvbW1pdFxufVxuXG5mcmFnbWVudCBpc3N1ZUNvbW1lbnRWaWV3X2l0ZW0gb24gSXNzdWVDb21tZW50IHtcbiAgYXV0aG9yIHtcbiAgICBfX3R5cGVuYW1lXG4gICAgYXZhdGFyVXJsXG4gICAgbG9naW5cbiAgICAuLi4gb24gTm9kZSB7XG4gICAgICBpZFxuICAgIH1cbiAgfVxuICBib2R5SFRNTFxuICBjcmVhdGVkQXRcbiAgdXJsXG59XG5cbmZyYWdtZW50IGNyb3NzUmVmZXJlbmNlZEV2ZW50c1ZpZXdfbm9kZXMgb24gQ3Jvc3NSZWZlcmVuY2VkRXZlbnQge1xuICBpZFxuICByZWZlcmVuY2VkQXRcbiAgaXNDcm9zc1JlcG9zaXRvcnlcbiAgYWN0b3Ige1xuICAgIF9fdHlwZW5hbWVcbiAgICBsb2dpblxuICAgIGF2YXRhclVybFxuICAgIC4uLiBvbiBOb2RlIHtcbiAgICAgIGlkXG4gICAgfVxuICB9XG4gIHNvdXJjZSB7XG4gICAgX190eXBlbmFtZVxuICAgIC4uLiBvbiBSZXBvc2l0b3J5Tm9kZSB7XG4gICAgICByZXBvc2l0b3J5IHtcbiAgICAgICAgbmFtZVxuICAgICAgICBvd25lciB7XG4gICAgICAgICAgX190eXBlbmFtZVxuICAgICAgICAgIGxvZ2luXG4gICAgICAgICAgaWRcbiAgICAgICAgfVxuICAgICAgICBpZFxuICAgICAgfVxuICAgIH1cbiAgICAuLi4gb24gTm9kZSB7XG4gICAgICBpZFxuICAgIH1cbiAgfVxuICAuLi5jcm9zc1JlZmVyZW5jZWRFdmVudFZpZXdfaXRlbVxufVxuXG5mcmFnbWVudCBjcm9zc1JlZmVyZW5jZWRFdmVudFZpZXdfaXRlbSBvbiBDcm9zc1JlZmVyZW5jZWRFdmVudCB7XG4gIGlkXG4gIGlzQ3Jvc3NSZXBvc2l0b3J5XG4gIHNvdXJjZSB7XG4gICAgX190eXBlbmFtZVxuICAgIC4uLiBvbiBJc3N1ZSB7XG4gICAgICBudW1iZXJcbiAgICAgIHRpdGxlXG4gICAgICB1cmxcbiAgICAgIGlzc3VlU3RhdGU6IHN0YXRlXG4gICAgfVxuICAgIC4uLiBvbiBQdWxsUmVxdWVzdCB7XG4gICAgICBudW1iZXJcbiAgICAgIHRpdGxlXG4gICAgICB1cmxcbiAgICAgIHByU3RhdGU6IHN0YXRlXG4gICAgfVxuICAgIC4uLiBvbiBSZXBvc2l0b3J5Tm9kZSB7XG4gICAgICByZXBvc2l0b3J5IHtcbiAgICAgICAgbmFtZVxuICAgICAgICBpc1ByaXZhdGVcbiAgICAgICAgb3duZXIge1xuICAgICAgICAgIF9fdHlwZW5hbWVcbiAgICAgICAgICBsb2dpblxuICAgICAgICAgIGlkXG4gICAgICAgIH1cbiAgICAgICAgaWRcbiAgICAgIH1cbiAgICB9XG4gICAgLi4uIG9uIE5vZGUge1xuICAgICAgaWRcbiAgICB9XG4gIH1cbn1cblxuZnJhZ21lbnQgY29tbWl0Vmlld19jb21taXQgb24gQ29tbWl0IHtcbiAgYXV0aG9yIHtcbiAgICBuYW1lXG4gICAgYXZhdGFyVXJsXG4gICAgdXNlciB7XG4gICAgICBsb2dpblxuICAgICAgaWRcbiAgICB9XG4gIH1cbiAgY29tbWl0dGVyIHtcbiAgICBuYW1lXG4gICAgYXZhdGFyVXJsXG4gICAgdXNlciB7XG4gICAgICBsb2dpblxuICAgICAgaWRcbiAgICB9XG4gIH1cbiAgYXV0aG9yZWRCeUNvbW1pdHRlclxuICBzaGE6IG9pZFxuICBtZXNzYWdlXG4gIG1lc3NhZ2VIZWFkbGluZUhUTUxcbiAgY29tbWl0VXJsXG59XG4qL1xuXG5jb25zdCBub2RlLyo6IENvbmNyZXRlUmVxdWVzdCovID0gKGZ1bmN0aW9uKCl7XG52YXIgdjAgPSBbXG4gIHtcbiAgICBcImtpbmRcIjogXCJMb2NhbEFyZ3VtZW50XCIsXG4gICAgXCJuYW1lXCI6IFwicmVwb0lkXCIsXG4gICAgXCJ0eXBlXCI6IFwiSUQhXCIsXG4gICAgXCJkZWZhdWx0VmFsdWVcIjogbnVsbFxuICB9LFxuICB7XG4gICAgXCJraW5kXCI6IFwiTG9jYWxBcmd1bWVudFwiLFxuICAgIFwibmFtZVwiOiBcImlzc3VlaXNoSWRcIixcbiAgICBcInR5cGVcIjogXCJJRCFcIixcbiAgICBcImRlZmF1bHRWYWx1ZVwiOiBudWxsXG4gIH0sXG4gIHtcbiAgICBcImtpbmRcIjogXCJMb2NhbEFyZ3VtZW50XCIsXG4gICAgXCJuYW1lXCI6IFwidGltZWxpbmVDb3VudFwiLFxuICAgIFwidHlwZVwiOiBcIkludCFcIixcbiAgICBcImRlZmF1bHRWYWx1ZVwiOiBudWxsXG4gIH0sXG4gIHtcbiAgICBcImtpbmRcIjogXCJMb2NhbEFyZ3VtZW50XCIsXG4gICAgXCJuYW1lXCI6IFwidGltZWxpbmVDdXJzb3JcIixcbiAgICBcInR5cGVcIjogXCJTdHJpbmdcIixcbiAgICBcImRlZmF1bHRWYWx1ZVwiOiBudWxsXG4gIH1cbl0sXG52MSA9IFtcbiAge1xuICAgIFwia2luZFwiOiBcIlZhcmlhYmxlXCIsXG4gICAgXCJuYW1lXCI6IFwiaWRcIixcbiAgICBcInZhcmlhYmxlTmFtZVwiOiBcInJlcG9JZFwiLFxuICAgIFwidHlwZVwiOiBcIklEIVwiXG4gIH1cbl0sXG52MiA9IFtcbiAge1xuICAgIFwia2luZFwiOiBcIlZhcmlhYmxlXCIsXG4gICAgXCJuYW1lXCI6IFwidGltZWxpbmVDb3VudFwiLFxuICAgIFwidmFyaWFibGVOYW1lXCI6IFwidGltZWxpbmVDb3VudFwiLFxuICAgIFwidHlwZVwiOiBudWxsXG4gIH0sXG4gIHtcbiAgICBcImtpbmRcIjogXCJWYXJpYWJsZVwiLFxuICAgIFwibmFtZVwiOiBcInRpbWVsaW5lQ3Vyc29yXCIsXG4gICAgXCJ2YXJpYWJsZU5hbWVcIjogXCJ0aW1lbGluZUN1cnNvclwiLFxuICAgIFwidHlwZVwiOiBudWxsXG4gIH1cbl0sXG52MyA9IFtcbiAge1xuICAgIFwia2luZFwiOiBcIlZhcmlhYmxlXCIsXG4gICAgXCJuYW1lXCI6IFwiaWRcIixcbiAgICBcInZhcmlhYmxlTmFtZVwiOiBcImlzc3VlaXNoSWRcIixcbiAgICBcInR5cGVcIjogXCJJRCFcIlxuICB9XG5dLFxudjQgPSB7XG4gIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gIFwiYWxpYXNcIjogbnVsbCxcbiAgXCJuYW1lXCI6IFwiX190eXBlbmFtZVwiLFxuICBcImFyZ3NcIjogbnVsbCxcbiAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbn0sXG52NSA9IHtcbiAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgXCJhbGlhc1wiOiBudWxsLFxuICBcIm5hbWVcIjogXCJpZFwiLFxuICBcImFyZ3NcIjogbnVsbCxcbiAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbn0sXG52NiA9IHtcbiAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgXCJhbGlhc1wiOiBudWxsLFxuICBcIm5hbWVcIjogXCJuYW1lXCIsXG4gIFwiYXJnc1wiOiBudWxsLFxuICBcInN0b3JhZ2VLZXlcIjogbnVsbFxufSxcbnY3ID0ge1xuICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICBcImFsaWFzXCI6IG51bGwsXG4gIFwibmFtZVwiOiBcImxvZ2luXCIsXG4gIFwiYXJnc1wiOiBudWxsLFxuICBcInN0b3JhZ2VLZXlcIjogbnVsbFxufSxcbnY4ID0ge1xuICBcImtpbmRcIjogXCJMaW5rZWRGaWVsZFwiLFxuICBcImFsaWFzXCI6IG51bGwsXG4gIFwibmFtZVwiOiBcIm93bmVyXCIsXG4gIFwic3RvcmFnZUtleVwiOiBudWxsLFxuICBcImFyZ3NcIjogbnVsbCxcbiAgXCJjb25jcmV0ZVR5cGVcIjogbnVsbCxcbiAgXCJwbHVyYWxcIjogZmFsc2UsXG4gIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgdjQsXG4gICAgdjcsXG4gICAgdjVcbiAgXVxufSxcbnY5ID0ge1xuICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICBcImFsaWFzXCI6IG51bGwsXG4gIFwibmFtZVwiOiBcIm51bWJlclwiLFxuICBcImFyZ3NcIjogbnVsbCxcbiAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbn0sXG52MTAgPSB7XG4gIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gIFwiYWxpYXNcIjogbnVsbCxcbiAgXCJuYW1lXCI6IFwidGl0bGVcIixcbiAgXCJhcmdzXCI6IG51bGwsXG4gIFwic3RvcmFnZUtleVwiOiBudWxsXG59LFxudjExID0ge1xuICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICBcImFsaWFzXCI6IG51bGwsXG4gIFwibmFtZVwiOiBcImJvZHlIVE1MXCIsXG4gIFwiYXJnc1wiOiBudWxsLFxuICBcInN0b3JhZ2VLZXlcIjogbnVsbFxufSxcbnYxMiA9IHtcbiAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgXCJhbGlhc1wiOiBudWxsLFxuICBcIm5hbWVcIjogXCJhdmF0YXJVcmxcIixcbiAgXCJhcmdzXCI6IG51bGwsXG4gIFwic3RvcmFnZUtleVwiOiBudWxsXG59LFxudjEzID0ge1xuICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICBcImFsaWFzXCI6IG51bGwsXG4gIFwibmFtZVwiOiBcInVybFwiLFxuICBcImFyZ3NcIjogbnVsbCxcbiAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbn0sXG52MTQgPSBbXG4gIHYxM1xuXSxcbnYxNSA9IFtcbiAge1xuICAgIFwia2luZFwiOiBcIlZhcmlhYmxlXCIsXG4gICAgXCJuYW1lXCI6IFwiYWZ0ZXJcIixcbiAgICBcInZhcmlhYmxlTmFtZVwiOiBcInRpbWVsaW5lQ3Vyc29yXCIsXG4gICAgXCJ0eXBlXCI6IFwiU3RyaW5nXCJcbiAgfSxcbiAge1xuICAgIFwia2luZFwiOiBcIlZhcmlhYmxlXCIsXG4gICAgXCJuYW1lXCI6IFwiZmlyc3RcIixcbiAgICBcInZhcmlhYmxlTmFtZVwiOiBcInRpbWVsaW5lQ291bnRcIixcbiAgICBcInR5cGVcIjogXCJJbnRcIlxuICB9XG5dLFxudjE2ID0ge1xuICBcImtpbmRcIjogXCJMaW5rZWRGaWVsZFwiLFxuICBcImFsaWFzXCI6IG51bGwsXG4gIFwibmFtZVwiOiBcInVzZXJcIixcbiAgXCJzdG9yYWdlS2V5XCI6IG51bGwsXG4gIFwiYXJnc1wiOiBudWxsLFxuICBcImNvbmNyZXRlVHlwZVwiOiBcIlVzZXJcIixcbiAgXCJwbHVyYWxcIjogZmFsc2UsXG4gIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgdjcsXG4gICAgdjVcbiAgXVxufTtcbnJldHVybiB7XG4gIFwia2luZFwiOiBcIlJlcXVlc3RcIixcbiAgXCJvcGVyYXRpb25LaW5kXCI6IFwicXVlcnlcIixcbiAgXCJuYW1lXCI6IFwiaXNzdWVEZXRhaWxWaWV3UmVmZXRjaFF1ZXJ5XCIsXG4gIFwiaWRcIjogbnVsbCxcbiAgXCJ0ZXh0XCI6IFwicXVlcnkgaXNzdWVEZXRhaWxWaWV3UmVmZXRjaFF1ZXJ5KFxcbiAgJHJlcG9JZDogSUQhXFxuICAkaXNzdWVpc2hJZDogSUQhXFxuICAkdGltZWxpbmVDb3VudDogSW50IVxcbiAgJHRpbWVsaW5lQ3Vyc29yOiBTdHJpbmdcXG4pIHtcXG4gIHJlcG9zaXRvcnk6IG5vZGUoaWQ6ICRyZXBvSWQpIHtcXG4gICAgX190eXBlbmFtZVxcbiAgICAuLi5pc3N1ZURldGFpbFZpZXdfcmVwb3NpdG9yeV8zRDhDUDlcXG4gICAgaWRcXG4gIH1cXG4gIGlzc3VlOiBub2RlKGlkOiAkaXNzdWVpc2hJZCkge1xcbiAgICBfX3R5cGVuYW1lXFxuICAgIC4uLmlzc3VlRGV0YWlsVmlld19pc3N1ZV8zRDhDUDlcXG4gICAgaWRcXG4gIH1cXG59XFxuXFxuZnJhZ21lbnQgaXNzdWVEZXRhaWxWaWV3X3JlcG9zaXRvcnlfM0Q4Q1A5IG9uIFJlcG9zaXRvcnkge1xcbiAgaWRcXG4gIG5hbWVcXG4gIG93bmVyIHtcXG4gICAgX190eXBlbmFtZVxcbiAgICBsb2dpblxcbiAgICBpZFxcbiAgfVxcbn1cXG5cXG5mcmFnbWVudCBpc3N1ZURldGFpbFZpZXdfaXNzdWVfM0Q4Q1A5IG9uIElzc3VlIHtcXG4gIF9fdHlwZW5hbWVcXG4gIC4uLiBvbiBOb2RlIHtcXG4gICAgaWRcXG4gIH1cXG4gIHN0YXRlXFxuICBudW1iZXJcXG4gIHRpdGxlXFxuICBib2R5SFRNTFxcbiAgYXV0aG9yIHtcXG4gICAgX190eXBlbmFtZVxcbiAgICBsb2dpblxcbiAgICBhdmF0YXJVcmxcXG4gICAgLi4uIG9uIFVzZXIge1xcbiAgICAgIHVybFxcbiAgICB9XFxuICAgIC4uLiBvbiBCb3Qge1xcbiAgICAgIHVybFxcbiAgICB9XFxuICAgIC4uLiBvbiBOb2RlIHtcXG4gICAgICBpZFxcbiAgICB9XFxuICB9XFxuICAuLi5pc3N1ZVRpbWVsaW5lQ29udHJvbGxlcl9pc3N1ZV8zRDhDUDlcXG4gIC4uLiBvbiBVbmlmb3JtUmVzb3VyY2VMb2NhdGFibGUge1xcbiAgICB1cmxcXG4gIH1cXG4gIC4uLiBvbiBSZWFjdGFibGUge1xcbiAgICByZWFjdGlvbkdyb3VwcyB7XFxuICAgICAgY29udGVudFxcbiAgICAgIHVzZXJzIHtcXG4gICAgICAgIHRvdGFsQ291bnRcXG4gICAgICB9XFxuICAgIH1cXG4gIH1cXG59XFxuXFxuZnJhZ21lbnQgaXNzdWVUaW1lbGluZUNvbnRyb2xsZXJfaXNzdWVfM0Q4Q1A5IG9uIElzc3VlIHtcXG4gIHVybFxcbiAgdGltZWxpbmUoZmlyc3Q6ICR0aW1lbGluZUNvdW50LCBhZnRlcjogJHRpbWVsaW5lQ3Vyc29yKSB7XFxuICAgIHBhZ2VJbmZvIHtcXG4gICAgICBlbmRDdXJzb3JcXG4gICAgICBoYXNOZXh0UGFnZVxcbiAgICB9XFxuICAgIGVkZ2VzIHtcXG4gICAgICBjdXJzb3JcXG4gICAgICBub2RlIHtcXG4gICAgICAgIF9fdHlwZW5hbWVcXG4gICAgICAgIC4uLmNvbW1pdHNWaWV3X25vZGVzXFxuICAgICAgICAuLi5pc3N1ZUNvbW1lbnRWaWV3X2l0ZW1cXG4gICAgICAgIC4uLmNyb3NzUmVmZXJlbmNlZEV2ZW50c1ZpZXdfbm9kZXNcXG4gICAgICAgIC4uLiBvbiBOb2RlIHtcXG4gICAgICAgICAgaWRcXG4gICAgICAgIH1cXG4gICAgICB9XFxuICAgIH1cXG4gIH1cXG59XFxuXFxuZnJhZ21lbnQgY29tbWl0c1ZpZXdfbm9kZXMgb24gQ29tbWl0IHtcXG4gIGlkXFxuICBhdXRob3Ige1xcbiAgICBuYW1lXFxuICAgIHVzZXIge1xcbiAgICAgIGxvZ2luXFxuICAgICAgaWRcXG4gICAgfVxcbiAgfVxcbiAgLi4uY29tbWl0Vmlld19jb21taXRcXG59XFxuXFxuZnJhZ21lbnQgaXNzdWVDb21tZW50Vmlld19pdGVtIG9uIElzc3VlQ29tbWVudCB7XFxuICBhdXRob3Ige1xcbiAgICBfX3R5cGVuYW1lXFxuICAgIGF2YXRhclVybFxcbiAgICBsb2dpblxcbiAgICAuLi4gb24gTm9kZSB7XFxuICAgICAgaWRcXG4gICAgfVxcbiAgfVxcbiAgYm9keUhUTUxcXG4gIGNyZWF0ZWRBdFxcbiAgdXJsXFxufVxcblxcbmZyYWdtZW50IGNyb3NzUmVmZXJlbmNlZEV2ZW50c1ZpZXdfbm9kZXMgb24gQ3Jvc3NSZWZlcmVuY2VkRXZlbnQge1xcbiAgaWRcXG4gIHJlZmVyZW5jZWRBdFxcbiAgaXNDcm9zc1JlcG9zaXRvcnlcXG4gIGFjdG9yIHtcXG4gICAgX190eXBlbmFtZVxcbiAgICBsb2dpblxcbiAgICBhdmF0YXJVcmxcXG4gICAgLi4uIG9uIE5vZGUge1xcbiAgICAgIGlkXFxuICAgIH1cXG4gIH1cXG4gIHNvdXJjZSB7XFxuICAgIF9fdHlwZW5hbWVcXG4gICAgLi4uIG9uIFJlcG9zaXRvcnlOb2RlIHtcXG4gICAgICByZXBvc2l0b3J5IHtcXG4gICAgICAgIG5hbWVcXG4gICAgICAgIG93bmVyIHtcXG4gICAgICAgICAgX190eXBlbmFtZVxcbiAgICAgICAgICBsb2dpblxcbiAgICAgICAgICBpZFxcbiAgICAgICAgfVxcbiAgICAgICAgaWRcXG4gICAgICB9XFxuICAgIH1cXG4gICAgLi4uIG9uIE5vZGUge1xcbiAgICAgIGlkXFxuICAgIH1cXG4gIH1cXG4gIC4uLmNyb3NzUmVmZXJlbmNlZEV2ZW50Vmlld19pdGVtXFxufVxcblxcbmZyYWdtZW50IGNyb3NzUmVmZXJlbmNlZEV2ZW50Vmlld19pdGVtIG9uIENyb3NzUmVmZXJlbmNlZEV2ZW50IHtcXG4gIGlkXFxuICBpc0Nyb3NzUmVwb3NpdG9yeVxcbiAgc291cmNlIHtcXG4gICAgX190eXBlbmFtZVxcbiAgICAuLi4gb24gSXNzdWUge1xcbiAgICAgIG51bWJlclxcbiAgICAgIHRpdGxlXFxuICAgICAgdXJsXFxuICAgICAgaXNzdWVTdGF0ZTogc3RhdGVcXG4gICAgfVxcbiAgICAuLi4gb24gUHVsbFJlcXVlc3Qge1xcbiAgICAgIG51bWJlclxcbiAgICAgIHRpdGxlXFxuICAgICAgdXJsXFxuICAgICAgcHJTdGF0ZTogc3RhdGVcXG4gICAgfVxcbiAgICAuLi4gb24gUmVwb3NpdG9yeU5vZGUge1xcbiAgICAgIHJlcG9zaXRvcnkge1xcbiAgICAgICAgbmFtZVxcbiAgICAgICAgaXNQcml2YXRlXFxuICAgICAgICBvd25lciB7XFxuICAgICAgICAgIF9fdHlwZW5hbWVcXG4gICAgICAgICAgbG9naW5cXG4gICAgICAgICAgaWRcXG4gICAgICAgIH1cXG4gICAgICAgIGlkXFxuICAgICAgfVxcbiAgICB9XFxuICAgIC4uLiBvbiBOb2RlIHtcXG4gICAgICBpZFxcbiAgICB9XFxuICB9XFxufVxcblxcbmZyYWdtZW50IGNvbW1pdFZpZXdfY29tbWl0IG9uIENvbW1pdCB7XFxuICBhdXRob3Ige1xcbiAgICBuYW1lXFxuICAgIGF2YXRhclVybFxcbiAgICB1c2VyIHtcXG4gICAgICBsb2dpblxcbiAgICAgIGlkXFxuICAgIH1cXG4gIH1cXG4gIGNvbW1pdHRlciB7XFxuICAgIG5hbWVcXG4gICAgYXZhdGFyVXJsXFxuICAgIHVzZXIge1xcbiAgICAgIGxvZ2luXFxuICAgICAgaWRcXG4gICAgfVxcbiAgfVxcbiAgYXV0aG9yZWRCeUNvbW1pdHRlclxcbiAgc2hhOiBvaWRcXG4gIG1lc3NhZ2VcXG4gIG1lc3NhZ2VIZWFkbGluZUhUTUxcXG4gIGNvbW1pdFVybFxcbn1cXG5cIixcbiAgXCJtZXRhZGF0YVwiOiB7fSxcbiAgXCJmcmFnbWVudFwiOiB7XG4gICAgXCJraW5kXCI6IFwiRnJhZ21lbnRcIixcbiAgICBcIm5hbWVcIjogXCJpc3N1ZURldGFpbFZpZXdSZWZldGNoUXVlcnlcIixcbiAgICBcInR5cGVcIjogXCJRdWVyeVwiLFxuICAgIFwibWV0YWRhdGFcIjogbnVsbCxcbiAgICBcImFyZ3VtZW50RGVmaW5pdGlvbnNcIjogdjAsXG4gICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgIHtcbiAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgXCJhbGlhc1wiOiBcInJlcG9zaXRvcnlcIixcbiAgICAgICAgXCJuYW1lXCI6IFwibm9kZVwiLFxuICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgXCJhcmdzXCI6IHYxLFxuICAgICAgICBcImNvbmNyZXRlVHlwZVwiOiBudWxsLFxuICAgICAgICBcInBsdXJhbFwiOiBmYWxzZSxcbiAgICAgICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICBcImtpbmRcIjogXCJGcmFnbWVudFNwcmVhZFwiLFxuICAgICAgICAgICAgXCJuYW1lXCI6IFwiaXNzdWVEZXRhaWxWaWV3X3JlcG9zaXRvcnlcIixcbiAgICAgICAgICAgIFwiYXJnc1wiOiB2MlxuICAgICAgICAgIH1cbiAgICAgICAgXVxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgXCJhbGlhc1wiOiBcImlzc3VlXCIsXG4gICAgICAgIFwibmFtZVwiOiBcIm5vZGVcIixcbiAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGwsXG4gICAgICAgIFwiYXJnc1wiOiB2MyxcbiAgICAgICAgXCJjb25jcmV0ZVR5cGVcIjogbnVsbCxcbiAgICAgICAgXCJwbHVyYWxcIjogZmFsc2UsXG4gICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgXCJraW5kXCI6IFwiRnJhZ21lbnRTcHJlYWRcIixcbiAgICAgICAgICAgIFwibmFtZVwiOiBcImlzc3VlRGV0YWlsVmlld19pc3N1ZVwiLFxuICAgICAgICAgICAgXCJhcmdzXCI6IHYyXG4gICAgICAgICAgfVxuICAgICAgICBdXG4gICAgICB9XG4gICAgXVxuICB9LFxuICBcIm9wZXJhdGlvblwiOiB7XG4gICAgXCJraW5kXCI6IFwiT3BlcmF0aW9uXCIsXG4gICAgXCJuYW1lXCI6IFwiaXNzdWVEZXRhaWxWaWV3UmVmZXRjaFF1ZXJ5XCIsXG4gICAgXCJhcmd1bWVudERlZmluaXRpb25zXCI6IHYwLFxuICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICB7XG4gICAgICAgIFwia2luZFwiOiBcIkxpbmtlZEZpZWxkXCIsXG4gICAgICAgIFwiYWxpYXNcIjogXCJyZXBvc2l0b3J5XCIsXG4gICAgICAgIFwibmFtZVwiOiBcIm5vZGVcIixcbiAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGwsXG4gICAgICAgIFwiYXJnc1wiOiB2MSxcbiAgICAgICAgXCJjb25jcmV0ZVR5cGVcIjogbnVsbCxcbiAgICAgICAgXCJwbHVyYWxcIjogZmFsc2UsXG4gICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgdjQsXG4gICAgICAgICAgdjUsXG4gICAgICAgICAge1xuICAgICAgICAgICAgXCJraW5kXCI6IFwiSW5saW5lRnJhZ21lbnRcIixcbiAgICAgICAgICAgIFwidHlwZVwiOiBcIlJlcG9zaXRvcnlcIixcbiAgICAgICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgICAgIHY2LFxuICAgICAgICAgICAgICB2OFxuICAgICAgICAgICAgXVxuICAgICAgICAgIH1cbiAgICAgICAgXVxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgXCJhbGlhc1wiOiBcImlzc3VlXCIsXG4gICAgICAgIFwibmFtZVwiOiBcIm5vZGVcIixcbiAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGwsXG4gICAgICAgIFwiYXJnc1wiOiB2MyxcbiAgICAgICAgXCJjb25jcmV0ZVR5cGVcIjogbnVsbCxcbiAgICAgICAgXCJwbHVyYWxcIjogZmFsc2UsXG4gICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgdjQsXG4gICAgICAgICAgdjUsXG4gICAgICAgICAge1xuICAgICAgICAgICAgXCJraW5kXCI6IFwiSW5saW5lRnJhZ21lbnRcIixcbiAgICAgICAgICAgIFwidHlwZVwiOiBcIklzc3VlXCIsXG4gICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogW1xuICAgICAgICAgICAgICB2NCxcbiAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcInN0YXRlXCIsXG4gICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgdjksXG4gICAgICAgICAgICAgIHYxMCxcbiAgICAgICAgICAgICAgdjExLFxuICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgXCJuYW1lXCI6IFwiYXV0aG9yXCIsXG4gICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGwsXG4gICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgXCJjb25jcmV0ZVR5cGVcIjogbnVsbCxcbiAgICAgICAgICAgICAgICBcInBsdXJhbFwiOiBmYWxzZSxcbiAgICAgICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogW1xuICAgICAgICAgICAgICAgICAgdjQsXG4gICAgICAgICAgICAgICAgICB2NyxcbiAgICAgICAgICAgICAgICAgIHYxMixcbiAgICAgICAgICAgICAgICAgIHY1LFxuICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJJbmxpbmVGcmFnbWVudFwiLFxuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJCb3RcIixcbiAgICAgICAgICAgICAgICAgICAgXCJzZWxlY3Rpb25zXCI6IHYxNFxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiSW5saW5lRnJhZ21lbnRcIixcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwiVXNlclwiLFxuICAgICAgICAgICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogdjE0XG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICB2MTMsXG4gICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJMaW5rZWRGaWVsZFwiLFxuICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJ0aW1lbGluZVwiLFxuICAgICAgICAgICAgICAgIFwic3RvcmFnZUtleVwiOiBudWxsLFxuICAgICAgICAgICAgICAgIFwiYXJnc1wiOiB2MTUsXG4gICAgICAgICAgICAgICAgXCJjb25jcmV0ZVR5cGVcIjogXCJJc3N1ZVRpbWVsaW5lQ29ubmVjdGlvblwiLFxuICAgICAgICAgICAgICAgIFwicGx1cmFsXCI6IGZhbHNlLFxuICAgICAgICAgICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIkxpbmtlZEZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IFwicGFnZUluZm9cIixcbiAgICAgICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICBcImNvbmNyZXRlVHlwZVwiOiBcIlBhZ2VJbmZvXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicGx1cmFsXCI6IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogW1xuICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJlbmRDdXJzb3JcIixcbiAgICAgICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbiAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJoYXNOZXh0UGFnZVwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbFxuICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJlZGdlc1wiLFxuICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIFwiY29uY3JldGVUeXBlXCI6IFwiSXNzdWVUaW1lbGluZUl0ZW1FZGdlXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicGx1cmFsXCI6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcImN1cnNvclwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbFxuICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcIm5vZGVcIixcbiAgICAgICAgICAgICAgICAgICAgICAgIFwic3RvcmFnZUtleVwiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICBcImNvbmNyZXRlVHlwZVwiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJwbHVyYWxcIjogZmFsc2UsXG4gICAgICAgICAgICAgICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICB2NCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgdjUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJJbmxpbmVGcmFnbWVudFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcIkNyb3NzUmVmZXJlbmNlZEV2ZW50XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJyZWZlcmVuY2VkQXRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic3RvcmFnZUtleVwiOiBudWxsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcImlzQ3Jvc3NSZXBvc2l0b3J5XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJhY3RvclwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiY29uY3JldGVUeXBlXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwicGx1cmFsXCI6IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHY0LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHY3LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHYxMixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2NVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBdXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJMaW5rZWRGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcInNvdXJjZVwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiY29uY3JldGVUeXBlXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwicGx1cmFsXCI6IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHY0LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIkxpbmtlZEZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJyZXBvc2l0b3J5XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJjb25jcmV0ZVR5cGVcIjogXCJSZXBvc2l0b3J5XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInBsdXJhbFwiOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHY2LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2OCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJpc1ByaXZhdGVcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFyZ3NcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBdXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2NSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJJbmxpbmVGcmFnbWVudFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwiUHVsbFJlcXVlc3RcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHY5LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2MTAsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHYxMyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBcInByU3RhdGVcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJzdGF0ZVwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic3RvcmFnZUtleVwiOiBudWxsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIF1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIklubGluZUZyYWdtZW50XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJJc3N1ZVwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHYxMCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjEzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IFwiaXNzdWVTdGF0ZVwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcInN0YXRlXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIF1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIklubGluZUZyYWdtZW50XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwiSXNzdWVDb21tZW50XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJhdXRob3JcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImNvbmNyZXRlVHlwZVwiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInBsdXJhbFwiOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2NCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2MTIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjVcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHYxMSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJjcmVhdGVkQXRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic3RvcmFnZUtleVwiOiBudWxsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjEzXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiSW5saW5lRnJhZ21lbnRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJDb21taXRcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInNlbGVjdGlvbnNcIjogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJMaW5rZWRGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcImF1dGhvclwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiY29uY3JldGVUeXBlXCI6IFwiR2l0QWN0b3JcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJwbHVyYWxcIjogZmFsc2UsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjYsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjE2LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHYxMlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBdXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJMaW5rZWRGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcImNvbW1pdHRlclwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiY29uY3JldGVUeXBlXCI6IFwiR2l0QWN0b3JcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJwbHVyYWxcIjogZmFsc2UsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic2VsZWN0aW9uc1wiOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjYsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdjEyLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHYxNlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBdXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcImF1dGhvcmVkQnlDb21taXR0ZXJcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic3RvcmFnZUtleVwiOiBudWxsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFsaWFzXCI6IFwic2hhXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmFtZVwiOiBcIm9pZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFyZ3NcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IFwibWVzc2FnZVwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFyZ3NcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IFwibWVzc2FnZUhlYWRsaW5lSFRNTFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImFyZ3NcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzdG9yYWdlS2V5XCI6IG51bGxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIlNjYWxhckZpZWxkXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IFwiY29tbWl0VXJsXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIF1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIF1cbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIFwia2luZFwiOiBcIkxpbmtlZEhhbmRsZVwiLFxuICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJ0aW1lbGluZVwiLFxuICAgICAgICAgICAgICAgIFwiYXJnc1wiOiB2MTUsXG4gICAgICAgICAgICAgICAgXCJoYW5kbGVcIjogXCJjb25uZWN0aW9uXCIsXG4gICAgICAgICAgICAgICAgXCJrZXlcIjogXCJJc3N1ZVRpbWVsaW5lQ29udHJvbGxlcl90aW1lbGluZVwiLFxuICAgICAgICAgICAgICAgIFwiZmlsdGVyc1wiOiBudWxsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJMaW5rZWRGaWVsZFwiLFxuICAgICAgICAgICAgICAgIFwiYWxpYXNcIjogbnVsbCxcbiAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJyZWFjdGlvbkdyb3Vwc1wiLFxuICAgICAgICAgICAgICAgIFwic3RvcmFnZUtleVwiOiBudWxsLFxuICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgIFwiY29uY3JldGVUeXBlXCI6IFwiUmVhY3Rpb25Hcm91cFwiLFxuICAgICAgICAgICAgICAgIFwicGx1cmFsXCI6IHRydWUsXG4gICAgICAgICAgICAgICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiU2NhbGFyRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJjb250ZW50XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYXJnc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbFxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgXCJraW5kXCI6IFwiTGlua2VkRmllbGRcIixcbiAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJ1c2Vyc1wiLFxuICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIFwiY29uY3JldGVUeXBlXCI6IFwiUmVhY3RpbmdVc2VyQ29ubmVjdGlvblwiLFxuICAgICAgICAgICAgICAgICAgICBcInBsdXJhbFwiOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgXCJzZWxlY3Rpb25zXCI6IFtcbiAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcImtpbmRcIjogXCJTY2FsYXJGaWVsZFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJhbGlhc1wiOiBudWxsLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IFwidG90YWxDb3VudFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJhcmdzXCI6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgICAgICBcInN0b3JhZ2VLZXlcIjogbnVsbFxuICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIF1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgXVxuICAgICAgICAgIH1cbiAgICAgICAgXVxuICAgICAgfVxuICAgIF1cbiAgfVxufTtcbn0pKCk7XG4vLyBwcmV0dGllci1pZ25vcmVcbihub2RlLyo6IGFueSovKS5oYXNoID0gJzgyNjY2YjI3NDgwMzY1NDVlYjEzMWIzZTM0ZjQ4ZTcyJztcbm1vZHVsZS5leHBvcnRzID0gbm9kZTtcbiJdfQ==