'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Git is asynchronously initializing a new repository in this working directory.
 */
class Initializing extends _state2.default {
  async start() {
    await this.doInit(this.workdir());

    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directInit(workdir) {
    return this.git().init(workdir);
  }
}

exports.default = Initializing;
_state2.default.register(Initializing);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluaXRpYWxpemluZy5qcyJdLCJuYW1lcyI6WyJJbml0aWFsaXppbmciLCJTdGF0ZSIsInN0YXJ0IiwiZG9Jbml0Iiwid29ya2RpciIsInRyYW5zaXRpb25UbyIsInNob3dHaXRUYWJMb2FkaW5nIiwiZGlyZWN0SW5pdCIsImdpdCIsImluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7OztBQUVBOzs7QUFHZSxNQUFNQSxZQUFOLFNBQTJCQyxlQUEzQixDQUFpQztBQUM5QyxRQUFNQyxLQUFOLEdBQWM7QUFDWixVQUFNLEtBQUtDLE1BQUwsQ0FBWSxLQUFLQyxPQUFMLEVBQVosQ0FBTjs7QUFFQSxVQUFNLEtBQUtDLFlBQUwsQ0FBa0IsU0FBbEIsQ0FBTjtBQUNEOztBQUVEQyxzQkFBb0I7QUFDbEIsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLGFBQVdILE9BQVgsRUFBb0I7QUFDbEIsV0FBTyxLQUFLSSxHQUFMLEdBQVdDLElBQVgsQ0FBZ0JMLE9BQWhCLENBQVA7QUFDRDtBQWI2Qzs7a0JBQTNCSixZO0FBZ0JyQkMsZ0JBQU1TLFFBQU4sQ0FBZVYsWUFBZiIsImZpbGUiOiJpbml0aWFsaXppbmcuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvbW9kZWxzL3JlcG9zaXRvcnktc3RhdGVzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0YXRlIGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIEdpdCBpcyBhc3luY2hyb25vdXNseSBpbml0aWFsaXppbmcgYSBuZXcgcmVwb3NpdG9yeSBpbiB0aGlzIHdvcmtpbmcgZGlyZWN0b3J5LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBJbml0aWFsaXppbmcgZXh0ZW5kcyBTdGF0ZSB7XG4gIGFzeW5jIHN0YXJ0KCkge1xuICAgIGF3YWl0IHRoaXMuZG9Jbml0KHRoaXMud29ya2RpcigpKTtcblxuICAgIGF3YWl0IHRoaXMudHJhbnNpdGlvblRvKCdMb2FkaW5nJyk7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGRpcmVjdEluaXQod29ya2Rpcikge1xuICAgIHJldHVybiB0aGlzLmdpdCgpLmluaXQod29ya2Rpcik7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoSW5pdGlhbGl6aW5nKTtcbiJdfQ==