/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.results;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.ui.results.ColoredFilter;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProfilerStorage;

public final class PackageColorer {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.results.Bundle");
    private static final String FILTERS_REFLECTION = messages.getString("PackageColorer_FiltersReflection");
    private static final String FILTERS_JPA = messages.getString("PackageColorer_FiltersJpa");
    private static final String FILTERS_SERVERS = messages.getString("PackageColorer_FiltersServers");
    private static final String FILTERS_JAVASE = messages.getString("PackageColorer_FiltersJavaSe");
    private static final String FILTERS_JAVAEE = messages.getString("PackageColorer_FiltersJavaEe");
    private static final String FILTERS_FILE = "filters";
    private static final List<ColoredFilter> COLORS = PackageColorer.loadColors();

    public static boolean registerColor(ColoredFilter coloredFilter) {
        if (COLORS.contains((Object)coloredFilter)) {
            return false;
        }
        return COLORS.add(coloredFilter);
    }

    public static boolean unregisterColor(ColoredFilter coloredFilter) {
        return COLORS.remove((Object)coloredFilter);
    }

    public static boolean hasRegisteredColors() {
        return !COLORS.isEmpty();
    }

    public static List<ColoredFilter> getRegisteredColors() {
        ArrayList<ColoredFilter> arrayList = new ArrayList<ColoredFilter>();
        for (ColoredFilter coloredFilter : COLORS) {
            arrayList.add(new ColoredFilter(coloredFilter));
        }
        return arrayList;
    }

    public static void setRegisteredColors(List<ColoredFilter> list) {
        if (!COLORS.equals(list)) {
            COLORS.clear();
            COLORS.addAll(list);
        }
    }

    public static Color getForeground(String string) {
        if (!ProfilerIDESettings.getInstance().isSourcesColoringEnabled()) {
            return null;
        }
        for (ColoredFilter coloredFilter : COLORS) {
            if (!coloredFilter.passes(string)) continue;
            return coloredFilter.getColor();
        }
        return null;
    }

    private static List<ColoredFilter> loadColors() {
        ArrayList<ColoredFilter> arrayList = new ArrayList<ColoredFilter>(){

            @Override
            public boolean add(ColoredFilter coloredFilter) {
                boolean bl = super.add(coloredFilter);
                if (bl && COLORS != null) {
                    PackageColorer.storeColors();
                }
                return bl;
            }

            @Override
            public boolean addAll(Collection<? extends ColoredFilter> collection) {
                boolean bl = super.addAll(collection);
                if (bl && COLORS != null) {
                    PackageColorer.storeColors();
                }
                return bl;
            }

            @Override
            public boolean remove(Object object) {
                boolean bl = super.remove(object);
                if (bl && COLORS != null) {
                    PackageColorer.storeColors();
                }
                return bl;
            }
        };
        Properties properties = new Properties();
        try {
            ProfilerStorage.loadGlobalProperties((Properties)properties, (String)FILTERS_FILE);
        }
        catch (IOException iOException) {
            Logger.getLogger(PackageColorer.class.getName()).log(Level.INFO, null, iOException);
        }
        if (!properties.isEmpty()) {
            int n = 0;
            try {
                while (true) {
                    arrayList.add(new ColoredFilter(properties, Integer.toString(n++) + "_"));
                }
            }
            catch (GenericFilter.InvalidFilterIdException invalidFilterIdException) {
                // empty catch block
            }
        }
        if (arrayList.isEmpty()) {
            PackageColorer.createDefaultFilters((List<ColoredFilter>)arrayList);
        }
        return arrayList;
    }

    private static void storeColors() {
        final Properties properties = new Properties();
        final List<ColoredFilter> list = PackageColorer.getRegisteredColors();
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        ((ColoredFilter)((Object)list.get(i))).store(properties, Integer.toString(i) + "_");
                        continue;
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(PackageColorer.class.getName()).log(Level.INFO, null, throwable);
                    }
                }
                try {
                    ProfilerStorage.saveGlobalProperties((Properties)properties, (String)PackageColorer.FILTERS_FILE);
                }
                catch (IOException iOException) {
                    Logger.getLogger(PackageColorer.class.getName()).log(Level.INFO, null, iOException);
                }
                return null;
            }
        }.execute();
    }

    private static void createDefaultFilters(List<ColoredFilter> list) {
        String string = new String("org.eclipse.persistence., org.hibernate., org.apache.openjpa.");
        list.add(new ColoredFilter(FILTERS_JPA, string, new Color(135, 135, 135)));
        String string2 = new String("javax.servlet., com.sun.enterprise., com.sun.ejb., org.jboss.weld., org.jboss.logging., org.springframework.");
        list.add(new ColoredFilter(FILTERS_JAVAEE, string2, new Color(135, 135, 135)));
        String string3 = new String("org.glassfish., com.sun.appserv., com.sun.gjc., weblogic., com.oracle.weblogic., com.bea., org.apache.tomcat., org.apache.catalina., org.jboss.as., org.eclipse.jetty.");
        list.add(new ColoredFilter(FILTERS_SERVERS, string3, new Color(135, 135, 135)));
        String string4 = new String("java.lang.reflect., sun.reflect., com.sun.proxy.");
        list.add(new ColoredFilter(FILTERS_REFLECTION, string4, new Color(180, 180, 180)));
        String string5 = new String("apple.laf., apple.awt., com.apple., com.sun., java., javax., sun., sunw., org.omg.");
        list.add(new ColoredFilter(FILTERS_JAVASE, string5, new Color(135, 135, 135)));
    }
}

