/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.IOException;

public class L2HTextSubscript
extends ControlSequence {
    public static final int[][] UNICODE_SUBSCRIPTS = new int[][]{{48, 8320}, {49, 8321}, {50, 8322}, {51, 8323}, {52, 8324}, {53, 8325}, {54, 8326}, {55, 8327}, {56, 8328}, {57, 8329}, {43, 8330}, {45, 8331}, {8722, 8331}, {61, 8332}, {40, 8333}, {41, 8333}, {97, 8336}, {101, 8337}, {111, 8338}, {120, 8339}, {601, 8340}, {104, 8341}, {107, 8342}, {108, 8343}, {109, 8344}, {110, 8345}, {112, 8346}, {115, 8347}, {116, 8348}, {106, 11388}};

    public L2HTextSubscript() {
        this("textsubscript");
    }

    public L2HTextSubscript(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HTextSubscript(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        if (((L2HConverter)teXParser.getListener()).supportUnicodeScript() && this.hasUnicodeSupport(teXObject)) {
            teXObjectList.push(this.convert(teXParser, teXObject));
        } else {
            teXObjectList.push(new HtmlTag("</sub>"));
            teXObjectList.push(teXObject);
            teXObjectList.push(new HtmlTag("<sub>"));
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        if (((L2HConverter)teXParser.getListener()).supportUnicodeScript() && this.hasUnicodeSupport(teXObject)) {
            teXParser.push(this.convert(teXParser, teXObject));
        } else {
            teXParser.push(new HtmlTag("</sub>"));
            teXParser.push(teXObject);
            teXParser.push(new HtmlTag("<sub>"));
        }
    }

    private TeXObject convert(TeXParser teXParser, TeXObject teXObject) {
        if (teXObject instanceof CharObject) {
            return this.getUnicode(teXParser, (CharObject)teXObject);
        }
        if (teXObject instanceof TeXNumber) {
            return this.convert(teXParser, teXParser.getListener().createString(teXObject.toString(teXParser)));
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        for (int i = 0; i < teXObjectList.size(); ++i) {
            teXObjectList.set(i, this.convert(teXParser, (TeXObject)teXObjectList.get(i)));
        }
        return teXObjectList;
    }

    private CharObject getUnicode(TeXParser teXParser, CharObject charObject) {
        int n = charObject.getCharCode();
        for (int i = 0; i < UNICODE_SUBSCRIPTS.length; ++i) {
            if (UNICODE_SUBSCRIPTS[i][0] != n) continue;
            return teXParser.getListener().getOther(UNICODE_SUBSCRIPTS[i][1]);
        }
        throw new IllegalArgumentException("Unknown conversion to subscript: " + charObject);
    }

    private boolean hasUnicodeSupport(TeXObject teXObject) {
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof MathGroup)) {
            for (TeXObject teXObject2 : (TeXObjectList)teXObject) {
                if (this.hasUnicodeSupport(teXObject2)) continue;
                return false;
            }
            return true;
        }
        if (teXObject instanceof TeXNumber) {
            return true;
        }
        if (teXObject instanceof CharObject) {
            int n = ((CharObject)teXObject).getCharCode();
            for (int i = 0; i < UNICODE_SUBSCRIPTS.length; ++i) {
                if (UNICODE_SUBSCRIPTS[i][0] != n) continue;
                return true;
            }
        }
        return false;
    }
}

