/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.io.IOException;
import org.openoffice.xmerge.util.Resources;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class OfficeDocumentException
extends IOException {
    public OfficeDocumentException(SAXException e) {
        super(OfficeDocumentException.constructMessage(e));
        if (e.getException() != null) {
            this.initCause(e.getException());
        } else {
            this.initCause(e);
        }
    }

    private static String constructMessage(SAXException e) {
        Exception ex;
        StringBuffer message = new StringBuffer();
        if (e instanceof SAXParseException) {
            String msgParseError = Resources.getInstance().getString("PARSE_ERROR");
            String msgLine = Resources.getInstance().getString("LINE");
            String msgColumn = Resources.getInstance().getString("COLUMN");
            String msgPublicId = Resources.getInstance().getString("PUBLIC_ID");
            String msgSystemId = Resources.getInstance().getString("SYSTEM_ID");
            SAXParseException spe = (SAXParseException)e;
            message.append(msgParseError);
            message.append(": ");
            message.append(msgLine);
            message.append(": ");
            message.append(spe.getLineNumber());
            message.append(", ");
            message.append(msgColumn);
            message.append(": ");
            message.append(spe.getColumnNumber());
            message.append(", ");
            message.append(msgSystemId);
            message.append(": ");
            message.append(spe.getSystemId());
            message.append(", ");
            message.append(msgPublicId);
            message.append(": ");
            message.append(spe.getPublicId());
            message.append("\n");
        }
        if ((ex = e.getException()) != null) {
            message.append(ex.getMessage());
        }
        return message.toString();
    }

    public OfficeDocumentException(String s) {
        super(s);
    }

    public OfficeDocumentException(Exception e) {
        super(e.getMessage());
        this.initCause(e);
    }
}

