/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;

public class MacPkgBundler
extends MacBaseInstallerBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacPkgBundler.class.getName());
    public static final String MAC_BUNDLER_PREFIX = "package/macosx" + File.separator;
    private static final String DEFAULT_BACKGROUND_IMAGE = "background_pkg.png";
    private static final String TEMPLATE_PREINSTALL_SCRIPT = "preinstall.template";
    private static final String TEMPLATE_POSTINSTALL_SCRIPT = "postinstall.template";
    private static final BundlerParamInfo<File> PACKAGES_ROOT = new StandardBundlerParam<File>(I18N.getString("param.packages-root.name"), I18N.getString("param.packages-root.description"), "mac.pkg.packagesRoot", File.class, params -> {
        File packagesRoot = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "packages");
        packagesRoot.mkdirs();
        return packagesRoot;
    }, (s, p) -> new File((String)s));
    protected final BundlerParamInfo<File> SCRIPTS_DIR = new StandardBundlerParam<File>(I18N.getString("param.scripts-dir.name"), I18N.getString("param.scripts-dir.description"), "mac.pkg.scriptsDir", File.class, params -> {
        File scriptsDir = new File((File)CONFIG_ROOT.fetchFrom((Map<String, ? super Object>)params), "scripts");
        scriptsDir.mkdirs();
        return scriptsDir;
    }, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<String> DEVELOPER_ID_INSTALLER_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-developer-id-installer.name"), I18N.getString("param.signing-key-developer-id-installer.description"), "mac.signing-key-developer-id-installer", String.class, params -> MacBaseInstallerBundler.findKey("Developer ID Installer: " + (String)SIGNING_KEY_USER.fetchFrom((Map<String, ? super Object>)params), (String)SIGNING_KEYCHAIN.fetchFrom((Map<String, ? super Object>)params), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)params)), (s, p) -> s);
    public static final BundlerParamInfo<String> INSTALLER_SUFFIX = new StandardBundlerParam<String>(I18N.getString("param.installer-suffix.name"), I18N.getString("param.installer-suffix.description"), "mac.pkg.installerName.suffix", String.class, params -> "", (s, p) -> s);

    public MacPkgBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> params, File outdir) {
        File appImageDir;
        block37: {
            File configScript;
            Log.info(MessageFormat.format(I18N.getString("message.building-pkg"), StandardBundlerParam.APP_NAME.fetchFrom(params)));
            if (!outdir.isDirectory() && !outdir.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outdir.getAbsolutePath()));
            }
            if (!outdir.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outdir.getAbsolutePath()));
            }
            appImageDir = null;
            appImageDir = this.prepareAppBundle(params);
            if (appImageDir == null || !this.prepareConfigFiles(params)) break block37;
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
                File daemonImageDir = (File)this.DAEMON_IMAGE_BUILD_ROOT.fetchFrom(params);
                daemonImageDir.mkdirs();
                this.prepareDaemonBundle(params);
            }
            if ((configScript = this.getConfig_Script(params)).exists()) {
                Log.info(MessageFormat.format(I18N.getString("message.running-script"), configScript.getAbsolutePath()));
                IOUtils.run("bash", configScript, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
            }
            File file = this.createPKG(params, outdir, appImageDir);
            try {
                if (appImageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(appImageDir);
                } else if (appImageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                    this.cleanupConfigFiles(params);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex) {
                Log.debug(ex);
                return null;
            }
            return file;
        }
        File configScript = null;
        try {
            if (appImageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(appImageDir);
            } else if (appImageDir != null) {
                Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
            }
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                this.cleanupConfigFiles(params);
            } else {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
            }
        }
        catch (FileNotFoundException ex) {
            Log.debug(ex);
            return null;
        }
        return configScript;
        catch (IOException ex) {
            File file;
            try {
                Log.verbose(ex);
                file = null;
            }
            catch (Throwable throwable) {
                try {
                    if (appImageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(appImageDir);
                    } else if (appImageDir != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
                    }
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                        this.cleanupConfigFiles(params);
                    } else {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException ex2) {
                    Log.debug(ex2);
                    return null;
                }
                throw throwable;
            }
            try {
                if (appImageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(appImageDir);
                } else if (appImageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                    this.cleanupConfigFiles(params);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex3) {
                Log.debug(ex3);
                return null;
            }
            return file;
        }
    }

    private File getPackages_AppPackage(Map<String, ? super Object> params) {
        return new File(PACKAGES_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + "-app.pkg");
    }

    private File getPackages_DaemonPackage(Map<String, ? super Object> params) {
        return new File(PACKAGES_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + "-daemon.pkg");
    }

    private void cleanupPackagesFiles(Map<String, ? super Object> params) {
        if (this.getPackages_AppPackage(params) != null) {
            this.getPackages_AppPackage(params).delete();
        }
        if (this.getPackages_DaemonPackage(params) != null) {
            this.getPackages_DaemonPackage(params).delete();
        }
    }

    private File getConfig_DistributionXMLFile(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), "distribution.dist");
    }

    private File getConfig_BackgroundImage(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "-background.png");
    }

    private File getScripts_PreinstallFile(Map<String, ? super Object> params) {
        return new File(this.SCRIPTS_DIR.fetchFrom(params), "preinstall");
    }

    private File getScripts_PostinstallFile(Map<String, ? super Object> params) {
        return new File(this.SCRIPTS_DIR.fetchFrom(params), "postinstall");
    }

    private void cleanupPackageScripts(Map<String, ? super Object> params) {
        if (this.getScripts_PreinstallFile(params) != null) {
            this.getScripts_PreinstallFile(params).delete();
        }
        if (this.getScripts_PostinstallFile(params) != null) {
            this.getScripts_PostinstallFile(params).delete();
        }
    }

    private void cleanupConfigFiles(Map<String, ? super Object> params) {
        if (this.getConfig_DistributionXMLFile(params) != null) {
            this.getConfig_DistributionXMLFile(params).delete();
        }
        if (this.getConfig_BackgroundImage(params) != null) {
            this.getConfig_BackgroundImage(params).delete();
        }
    }

    private String getAppIdentifier(Map<String, ? super Object> params) {
        return (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params);
    }

    private String getDaemonIdentifier(Map<String, ? super Object> params) {
        return (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params) + ".daemon";
    }

    private void preparePackageScripts(Map<String, ? super Object> params) throws IOException {
        Log.verbose(I18N.getString("message.preparing-scripts"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("DEPLOY_DAEMON_IDENTIFIER", this.getDaemonIdentifier(params));
        data.put("DEPLOY_LAUNCHD_PLIST_FILE", ((String)StandardBundlerParam.IDENTIFIER.fetchFrom(params)).toLowerCase() + ".launchd.plist");
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getScripts_PreinstallFile(params)));
        String content = this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getScripts_PreinstallFile(params).getName(), I18N.getString("resource.pkg-preinstall-script"), TEMPLATE_PREINSTALL_SCRIPT, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        this.getScripts_PreinstallFile(params).setExecutable(true, false);
        w = new BufferedWriter(new FileWriter(this.getScripts_PostinstallFile(params)));
        content = this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getScripts_PostinstallFile(params).getName(), I18N.getString("resource.pkg-postinstall-script"), TEMPLATE_POSTINSTALL_SCRIPT, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        this.getScripts_PostinstallFile(params).setExecutable(true, false);
    }

    private void prepareDistributionXMLFile(Map<String, ? super Object> params) throws IOException {
        File f = this.getConfig_DistributionXMLFile(params);
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-distribution-dist"), f.getAbsolutePath()));
        PrintStream out = new PrintStream(f);
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        out.println("<installer-gui-script minSpecVersion=\"1\">");
        out.println("<title>" + (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "</title>");
        out.println("<background file=\"" + this.getConfig_BackgroundImage(params).getName() + "\" mime-type=\"image/png\" alignment=\"bottomleft\"  scaling=\"none\"/>");
        if (!((List)StandardBundlerParam.LICENSE_FILE.fetchFrom(params)).isEmpty()) {
            File licFile = null;
            List licFiles = (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(params);
            if (licFiles.isEmpty()) {
                return;
            }
            String licFileStr = (String)licFiles.get(0);
            for (RelativeFileSet rfs : (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params)) {
                if (!rfs.contains(licFileStr)) continue;
                licFile = new File(rfs.getBaseDirectory(), licFileStr);
                break;
            }
            if (licFile != null) {
                out.println("<license file=\"" + licFile.getAbsolutePath() + "\" mime-type=\"text/rtf\"/>");
            }
        }
        String appId = this.getAppIdentifier(params);
        String daemonId = this.getDaemonIdentifier(params);
        out.println("<pkg-ref id=\"" + appId + "\"/>");
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
            out.println("<pkg-ref id=\"" + daemonId + "\"/>");
        }
        out.println("<options customize=\"never\" require-scripts=\"false\"/>");
        out.println("<choices-outline>");
        out.println("    <line choice=\"default\">");
        out.println("        <line choice=\"" + appId + "\"/>");
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
            out.println("        <line choice=\"" + daemonId + "\"/>");
        }
        out.println("    </line>");
        out.println("</choices-outline>");
        out.println("<choice id=\"default\"/>");
        out.println("<choice id=\"" + appId + "\" visible=\"false\">");
        out.println("    <pkg-ref id=\"" + appId + "\"/>");
        out.println("</choice>");
        out.println("<pkg-ref id=\"" + appId + "\" version=\"" + (String)StandardBundlerParam.VERSION.fetchFrom(params) + "\" onConclusion=\"none\">" + URLEncoder.encode(this.getPackages_AppPackage(params).getName(), "UTF-8") + "</pkg-ref>");
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
            out.println("<choice id=\"" + daemonId + "\" visible=\"false\">");
            out.println("    <pkg-ref id=\"" + daemonId + "\"/>");
            out.println("</choice>");
            out.println("<pkg-ref id=\"" + daemonId + "\" version=\"" + (String)StandardBundlerParam.VERSION.fetchFrom(params) + "\" onConclusion=\"none\">" + URLEncoder.encode(this.getPackages_DaemonPackage(params).getName(), "UTF-8") + "</pkg-ref>");
        }
        out.println("</installer-gui-script>");
        out.close();
    }

    private boolean prepareConfigFiles(Map<String, ? super Object> params) throws IOException {
        File imageTarget = this.getConfig_BackgroundImage(params);
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + imageTarget.getName(), I18N.getString("resource.pkg-background-image"), DEFAULT_BACKGROUND_IMAGE, imageTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        this.prepareDistributionXMLFile(params);
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_Script(params).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        return true;
    }

    private File getConfig_Script(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "-post-image.sh");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPKG(Map<String, ? super Object> params, File outdir, File appLocation) {
        try {
            String daemonLocation = this.DAEMON_IMAGE_BUILD_ROOT.fetchFrom(params) + "/" + (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".daemon";
            File appPKG = this.getPackages_AppPackage(params);
            File daemonPKG = this.getPackages_DaemonPackage(params);
            ProcessBuilder pb = new ProcessBuilder("pkgbuild", "--component", appLocation.toString(), "--install-location", "/Applications", appPKG.getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
                this.preparePackageScripts(params);
                pb = new ProcessBuilder("pkgbuild", "--identifier", (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".daemon", "--root", daemonLocation, "--scripts", this.SCRIPTS_DIR.fetchFrom(params).getAbsolutePath(), daemonPKG.getAbsolutePath());
                IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
            }
            File finalPKG = new File(outdir, (String)INSTALLER_NAME.fetchFrom(params) + INSTALLER_SUFFIX.fetchFrom(params) + ".pkg");
            outdir.mkdirs();
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add("productbuild");
            commandLine.add("--resources");
            commandLine.add(((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath());
            if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(params)).orElse(Boolean.TRUE).booleanValue()) {
                String keychainName;
                String signingIdentity = DEVELOPER_ID_INSTALLER_SIGNING_KEY.fetchFrom(params);
                if (signingIdentity != null) {
                    commandLine.add("--sign");
                    commandLine.add(signingIdentity);
                }
                if ((keychainName = (String)SIGNING_KEYCHAIN.fetchFrom(params)) != null && !keychainName.isEmpty()) {
                    commandLine.add("--keychain");
                    commandLine.add(keychainName);
                }
            }
            commandLine.add("--distribution");
            commandLine.add(this.getConfig_DistributionXMLFile(params).getAbsolutePath());
            commandLine.add("--package-path");
            commandLine.add(PACKAGES_ROOT.fetchFrom(params).getAbsolutePath());
            commandLine.add(finalPKG.getAbsolutePath());
            pb = new ProcessBuilder(commandLine);
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
            File file = finalPKG;
            return file;
        }
        catch (Exception ignored) {
            Log.verbose(ignored);
            File file = null;
            return file;
        }
        finally {
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                this.cleanupPackagesFiles(params);
                this.cleanupConfigFiles(params);
                if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
                    this.cleanupPackageScripts(params);
                }
            }
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "pkg";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(MacAppBundler.getAppBundleParameters());
        results.addAll(this.getPKGBundleParameters());
        return results;
    }

    public Collection<BundlerParamInfo<?>> getPKGBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(MacAppBundler.getAppBundleParameters());
        results.addAll(Arrays.asList(DEVELOPER_ID_INSTALLER_SIGNING_KEY, INSTALLER_SUFFIX, StandardBundlerParam.LICENSE_FILE, SIGNING_KEYCHAIN));
        return results;
    }

    @Override
    public boolean validate(Map<String, ? super Object> params) throws UnsupportedPlatformException, ConfigException {
        try {
            String signingIdentity;
            if (params == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            this.validateAppImageAndBundeler(params);
            if (params.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                List appResourcesList = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params);
                for (String license : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(params)) {
                    boolean found = false;
                    for (RelativeFileSet appResources : appResourcesList) {
                        found = found || appResources.contains(license);
                    }
                    if (found) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), license));
                }
            }
            if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(params)).orElse(Boolean.FALSE).booleanValue() && (signingIdentity = DEVELOPER_ID_INSTALLER_SIGNING_KEY.fetchFrom(params)) == null) {
                throw new ConfigException(I18N.getString("error.explicit-sign-no-cert"), I18N.getString("error.explicit-sign-no-cert.advice"));
            }
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.bundle(params, outputParentDir);
    }
}

