#ifndef _EFL_CANVAS_ANIMATION_ALPHA_EO_H_
#define _EFL_CANVAS_ANIMATION_ALPHA_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_ALPHA_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_ALPHA_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation_Alpha;

#endif

#ifndef _EFL_CANVAS_ANIMATION_ALPHA_EO_TYPES
#define _EFL_CANVAS_ANIMATION_ALPHA_EO_TYPES


#endif
/** Efl alpha animation class
 *
 * @ingroup Efl_Canvas_Animation_Alpha
 */
#define EFL_CANVAS_ANIMATION_ALPHA_CLASS efl_canvas_animation_alpha_class_get()

EWAPI const Efl_Class *efl_canvas_animation_alpha_class_get(void);

/**
 * @brief Alpha property
 *
 * @param[in] obj The object.
 * @param[in] from_alpha Alpha value when animation starts
 * @param[in] to_alpha Alpha value when animation ends
 *
 * @ingroup Efl_Canvas_Animation_Alpha
 */
EOAPI void efl_animation_alpha_set(Eo *obj, double from_alpha, double to_alpha);

/**
 * @brief Alpha property
 *
 * @param[in] obj The object.
 * @param[out] from_alpha Alpha value when animation starts
 * @param[out] to_alpha Alpha value when animation ends
 *
 * @ingroup Efl_Canvas_Animation_Alpha
 */
EOAPI void efl_animation_alpha_get(const Eo *obj, double *from_alpha, double *to_alpha);

#endif
