#ifndef _EFL_LOOP_CONSUMER_EO_H_
#define _EFL_LOOP_CONSUMER_EO_H_

#ifndef _EFL_LOOP_CONSUMER_EO_CLASS_TYPE
#define _EFL_LOOP_CONSUMER_EO_CLASS_TYPE

typedef Eo Efl_Loop_Consumer;

#endif

#ifndef _EFL_LOOP_CONSUMER_EO_TYPES
#define _EFL_LOOP_CONSUMER_EO_TYPES


#endif
/** An Efl.Loop_Consumer is a class which requires one of the parents to
 * provide an Efl.Loop interface when performing provider_find. It will enforce
 * this by only allowing parents which provide such an interface or NULL.
 *
 * @ingroup Efl_Loop_Consumer
 */
#define EFL_LOOP_CONSUMER_CLASS efl_loop_consumer_class_get()

EWAPI const Efl_Class *efl_loop_consumer_class_get(void);

/**
 * @brief The loop to which this object belongs to.
 *
 * Gets a handle to the loop.
 *
 * @param[in] obj The object.
 *
 * @return Efl loop
 *
 * @ingroup Efl_Loop_Consumer
 */
EOAPI Efl_Loop *efl_loop_get(const Eo *obj);

#endif
