/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import java.io.File;
import java.util.Stack;
import org.protege.editor.owl.ui.util.ProgressDialog;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.slf4j.Logger;

public class ProgressDialogOntologyLoaderListener
implements OWLOntologyLoaderListener {
    private final Stack<IRI> loadStack = new Stack();
    private final ProgressDialog progressDialog;
    private final Logger logger;

    public ProgressDialogOntologyLoaderListener(ProgressDialog progressDialog, Logger logger) {
        this.progressDialog = progressDialog;
        this.logger = logger;
    }

    public void startedLoadingOntology(OWLOntologyLoaderListener.LoadingStartedEvent event) {
        IRI documentIRI = event.getDocumentIRI();
        this.loadStack.push(documentIRI);
        if (this.loadStack.size() == 1) {
            this.progressDialog.setMessage(String.format("Loading %s", ProgressDialogOntologyLoaderListener.formatIRI(documentIRI)));
        } else {
            this.progressDialog.setSubMessage(this.formatImportedDocumentIRIMessage(documentIRI));
        }
    }

    public void finishedLoadingOntology(OWLOntologyLoaderListener.LoadingFinishedEvent event) {
        if (event.isImported()) {
            if (event.isSuccessful()) {
                this.logger.info("Finished loading imported ontology at {}", (Object)event.getDocumentIRI());
            } else {
                this.logger.info("Failed to load imported ontology at {}", (Object)event.getDocumentIRI());
            }
        } else {
            this.logger.info("Finished loading {}", (Object)event.getDocumentIRI());
        }
        this.loadStack.pop();
        if (this.loadStack.size() > 1) {
            this.progressDialog.setSubMessage(this.formatImportedDocumentIRIMessage(this.loadStack.peek()));
        } else {
            this.progressDialog.clearSubMessage();
        }
    }

    private String formatImportedDocumentIRIMessage(IRI documentIRI) {
        return String.format("Loading imported ontology %s", ProgressDialogOntologyLoaderListener.formatIRI(documentIRI));
    }

    private static String formatIRI(IRI iri) {
        if ("file".equalsIgnoreCase(iri.getScheme())) {
            return new File(iri.toURI()).toString();
        }
        return iri.toString();
    }
}

