/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.jruby.util.ByteList;
import org.jvyamlb.TestBean;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLTestCase;
import org.jvyamlb.exceptions.ParserException;

public class YAMLLoadTest
extends YAMLTestCase {
    public YAMLLoadTest(String name) {
        super(name);
    }

    public void testBasicStringScalarLoad() throws Exception {
        ByteList str = this.s("str");
        this.assertLoad((Object)str, "--- str");
        this.assertLoad((Object)str, "---\nstr");
        this.assertLoad((Object)str, "--- \nstr");
        this.assertLoad((Object)str, "--- \n str");
        this.assertLoad((Object)str, "str");
        this.assertLoad((Object)str, " str");
        this.assertLoad((Object)str, "\nstr");
        this.assertLoad((Object)str, "\n str");
        this.assertLoad((Object)str, "\"str\"");
        this.assertLoad((Object)str, "'str'");
        this.assertLoad((Object)this.s("\u00fc"), "---\n\"\\xC3\\xBC\"");
    }

    public void testBasicIntegerScalarLoad() throws Exception {
        this.assertLoad((Object)new Long(47L), "47");
        this.assertLoad((Object)new Long(0L), "0");
        this.assertLoad((Object)new Long(-1L), "-1");
    }

    public void testBlockMappingLoad() throws Exception {
        HashMap<ByteList, ByteList> expected = new HashMap<ByteList, ByteList>();
        expected.put(this.s("a"), this.s("b"));
        expected.put(this.s("c"), this.s("d"));
        this.assertLoad(expected, "a: b\nc: d");
        this.assertLoad(expected, "c: d\na: b\n");
    }

    public void testFlowMappingLoad() throws Exception {
        HashMap<ByteList, ByteList> expected = new HashMap<ByteList, ByteList>();
        expected.put(this.s("a"), this.s("b"));
        expected.put(this.s("c"), this.s("d"));
        this.assertLoad(expected, "{a: b, c: d}");
        this.assertLoad(expected, "{c: d,\na: b}");
    }

    public void testInternalChar() throws Exception {
        HashMap<ByteList, ByteList> expected = new HashMap<ByteList, ByteList>();
        expected.put(this.s("bad_sample"), this.s("something:("));
        this.assertLoad(expected, "--- \nbad_sample: something:(\n");
    }

    public void testBuiltinTag() throws Exception {
        this.assertLoad((Object)this.s("str"), "!!str str");
        this.assertLoad((Object)this.s("str"), "%YAML 1.1\n---\n!!str str");
        this.assertLoad((Object)this.s("str"), "%YAML 1.0\n---\n!str str");
        this.assertLoad10(this.s("str"), "---\n!str str");
        this.assertLoad10(new Long(123L), "---\n!int 123");
        this.assertLoad10(new Long(123L), "%YAML 1.1\n---\n!!int 123");
    }

    public void testDirectives() throws Exception {
        this.assertLoad((Object)this.s("str"), "%YAML 1.1\n--- !!str str");
        this.assertLoad((Object)this.s("str"), "%YAML 1.1\n%TAG !yaml! tag:yaml.org,2002:\n--- !yaml!str str");
        try {
            YAML.load(this.s("%YAML 1.1\n%YAML 1.1\n--- !!str str"));
            YAMLLoadTest.fail((String)"should throw exception when repeating directive");
        }
        catch (ParserException e) {
            YAMLLoadTest.assertTrue((boolean)true);
        }
    }

    public void testJavaBeanLoad() throws Exception {
        DateTime dt = new DateTime(1982, 5, 3, 0, 0, 0, 0);
        TestBean expected = new TestBean(this.s("Ola Bini"), 24, dt);
        this.assertLoad((Object)expected, "--- !java/object:org.jvyamlb.TestBean\nname: Ola Bini\nage: 24\nborn: 1982-05-03\n");
    }

    public void testJavaBeanLoadRefs() throws Exception {
        DateTime dt = new DateTime(1982, 5, 3, 0, 0, 0, 0);
        TestBean bean = new TestBean(this.s("Ola Bini"), 24, dt);
        List result = (List)YAML.load(this.s("--- \n- &id001 !java/object:org.jvyamlb.TestBean\n  name: Ola Bini\n  age: 24\n  born: 1982-05-03\n- *id001"));
        YAMLLoadTest.assertEquals((Object)bean, result.get(0));
        YAMLLoadTest.assertSame(result.get(0), result.get(1));
    }

    public void testFlowSequenceWithFlowMappingLoad() throws Exception {
        ArrayList expectedOuter = new ArrayList();
        HashMap<ByteList, ByteList> expectedInner = new HashMap<ByteList, ByteList>();
        expectedInner.put(this.s("a"), this.s("b"));
        expectedOuter.add(expectedInner);
        this.assertLoad(expectedOuter, "[{a: b}]");
    }

    public void testNestedFlowMappingLoad() throws Exception {
        HashMap<ByteList, ByteList> expectedInner = new HashMap<ByteList, ByteList>();
        expectedInner.put(this.s("b"), this.s("c"));
        HashMap<ByteList, HashMap<ByteList, ByteList>> expectedOuter = new HashMap<ByteList, HashMap<ByteList, ByteList>>();
        expectedOuter.put(this.s("a"), expectedInner);
        this.assertLoad(expectedOuter, "{a: {b: c}}");
    }

    public void testNestedFlowSequenceFlowMappingLoad() throws Exception {
        ArrayList expectedOuterList = new ArrayList();
        HashMap<ByteList, ByteList> expectedInnerMap = new HashMap<ByteList, ByteList>();
        expectedInnerMap.put(this.s("b"), this.s("c"));
        HashMap<ByteList, HashMap<ByteList, ByteList>> expectedOuterMap = new HashMap<ByteList, HashMap<ByteList, ByteList>>();
        expectedOuterMap.put(this.s("a"), expectedInnerMap);
        expectedOuterList.add(expectedOuterMap);
        this.assertLoad(expectedOuterList, "[{a: {b: c}}]");
    }
}

