/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Dialog;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.debugger.ui.WatchPanel;
import org.netbeans.modules.debugger.ui.actions.ViewActions;
import org.netbeans.modules.debugger.ui.views.VariablesViewButtons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AddWatchAction
extends CallableSystemAction {
    private static String watchHistory = "";

    public AddWatchAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(AddWatchAction.class, (String)"CTL_New_Watch");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddWatchAction.class);
    }

    protected String iconResource() {
        return "org/netbeans/modules/debugger/resources/actions/NewWatch.gif";
    }

    public void performAction() {
        final AddWatchListener addWatchListener = AddWatchAction.performEngineAddWatchAction();
        if (addWatchListener != null) {
            if (addWatchListener.getTask().isFinished()) {
                if (addWatchListener.isWatchAdded()) {
                    AddWatchAction.openWatchesView();
                }
                DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)addWatchListener);
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        addWatchListener.getTask().waitFinished();
                        if (addWatchListener.isWatchAdded()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AddWatchAction.openWatchesView();
                                }
                            });
                        }
                        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)addWatchListener);
                    }
                });
            }
        } else {
            ResourceBundle bundle = NbBundle.getBundle(AddWatchAction.class);
            WatchPanel wp = new WatchPanel(watchHistory);
            JComponent panel = wp.getPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)panel, bundle.getString("CTL_WatchDialog_Title"), true, 2, null, 0, new HelpCtx("debug.add.watch"), null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            dialog.dispose();
            if (dd.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            String watch = wp.getExpression();
            if (watch == null || watch.trim().length() == 0) {
                return;
            }
            String s = watch;
            int i = s.indexOf(59);
            while (i > 0) {
                String ss = s.substring(0, i).trim();
                if (ss.length() > 0) {
                    DebuggerManager.getDebuggerManager().createWatch(ss);
                }
                s = s.substring(i + 1);
                i = s.indexOf(59);
            }
            if ((s = s.trim()).length() > 0) {
                DebuggerManager.getDebuggerManager().createWatch(s);
            }
            watchHistory = watch;
            AddWatchAction.openWatchesView();
        }
    }

    private static void openWatchesView() {
        Mode mw;
        TopComponent watchesView = WindowManager.getDefault().findTopComponent("watchesView");
        if (watchesView != null && watchesView.isOpened() && (mw = WindowManager.getDefault().findMode(watchesView)) != null && mw.getSelectedTopComponent() == watchesView) {
            return;
        }
        String viewName = VariablesViewButtons.isWatchesViewNested() ? "localsView" : "watchesView";
        ViewActions.openComponent(viewName, false).requestVisible();
    }

    private static AddWatchListener performEngineAddWatchAction() {
        ActionsManager manager;
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null && (manager = engine.getActionsManager()).isEnabled(ActionsManager.ACTION_NEW_WATCH)) {
            AddWatchListener addWatchListener = new AddWatchListener();
            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)addWatchListener);
            Task addWatchTask = manager.postAction(ActionsManager.ACTION_NEW_WATCH);
            addWatchListener.setTask(addWatchTask);
            return addWatchListener;
        }
        return null;
    }

    private static final class AddWatchListener
    extends DebuggerManagerAdapter {
        private boolean watchAdded;
        private Task addWatchTask;

        private AddWatchListener() {
        }

        public void watchAdded(Watch watch) {
            this.watchAdded = true;
        }

        public boolean isWatchAdded() {
            return this.watchAdded;
        }

        public void setTask(Task addWatchTask) {
            this.addWatchTask = addWatchTask;
        }

        public Task getTask() {
            return this.addWatchTask;
        }
    }
}

