/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.spi.tasklist.Task;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OpenTaskAction
extends AbstractAction {
    private Task task;

    public OpenTaskAction(Task task) {
        super(NbBundle.getMessage(OpenTaskAction.class, (String)"LBL_ShowSource"));
        assert (null != task);
        this.task = task;
        this.setEnabled(this.canOpenTask());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataObject dataObject;
        if (!this.canOpenTask()) {
            return;
        }
        ActionListener al = Accessor.getDefaultAction(this.task);
        if (null != al) {
            al.actionPerformed(e);
            return;
        }
        URL url = Accessor.getURL(this.task);
        if (null != url) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            return;
        }
        int line = Accessor.getLine(this.task) - 1;
        FileObject fileObject = Accessor.getFile(this.task);
        if (null == fileObject) {
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException donfE) {
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (null != lineCookie && this.openAt(lineCookie, line)) {
            return;
        }
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (null != editCookie) {
            editCookie.edit();
            return;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (null != openCookie) {
            openCookie.open();
            return;
        }
        ViewCookie viewCookie = (ViewCookie)dataObject.getCookie(ViewCookie.class);
        if (null != viewCookie) {
            viewCookie.view();
            return;
        }
    }

    private boolean openAt(LineCookie lineCookie, int lineNo) {
        Line.Set lines = lineCookie.getLineSet();
        try {
            Line line = lines.getCurrent(lineNo);
            if (null == line) {
                line = lines.getCurrent(0);
            }
            if (null != line) {
                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private boolean canOpenTask() {
        if (null != Accessor.getDefaultAction(this.task)) {
            return true;
        }
        URL url = Accessor.getURL(this.task);
        if (null != url) {
            return true;
        }
        FileObject fo = Accessor.getFile(this.task);
        if (null == fo) {
            return false;
        }
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException donfE) {
            return false;
        }
        if (Accessor.getLine(this.task) > 0) {
            return null != dob.getCookie(LineCookie.class);
        }
        return null != dob.getCookie(OpenCookie.class) || null != dob.getCookie(EditCookie.class) || null != dob.getCookie(ViewCookie.class);
    }
}

