/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.pdf.SetCommandForm;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class PDFOpenSupport
implements OpenCookie {
    private static final Logger LOG = Logger.getLogger(PDFOpenSupport.class.getName());
    static final String FILENAME_PLACEHOLDER = "$file";
    private static final String DATA_FOLDER = "org-netbeans-modules-pdf";
    private static final String DATA_FILE = "cmd.data";
    private static final String CMD_ATTR = "cmd";
    private File f;
    private DataObject dObj;

    public PDFOpenSupport(File f) {
        this.f = f;
        try {
            this.dObj = DataObject.find((FileObject)FileUtil.toFileObject((File)f));
        }
        catch (DataObjectNotFoundException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    public PDFOpenSupport(DataObject dObj) {
        this.dObj = dObj;
        this.f = FileUtil.toFile((FileObject)dObj.getPrimaryFile());
    }

    public void open() {
        if (this.dObj != null) {
            this.f = FileUtil.toFile((FileObject)this.dObj.getPrimaryFile());
        }
        try {
            Desktop.getDesktop().open(this.f);
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "java.awt.Desktop.open() failed.", ex);
            this.openFallback(this.f);
        }
    }

    private void openFallback(File file) {
        String customCommand = this.getCustomCommand();
        if (customCommand == null || customCommand.isEmpty()) {
            this.askForCustomCommand(file);
        } else if (customCommand.indexOf(FILENAME_PLACEHOLDER) == -1) {
            this.askForCustomCommand(file);
        } else {
            try {
                this.openWithCustomCommand(customCommand, file);
            }
            catch (Exception e) {
                this.askForCustomCommand(file);
            }
        }
    }

    private String getCustomCommand() {
        FileObject root = FileUtil.getConfigRoot();
        FileObject d = root.getFileObject("org-netbeans-modules-pdf/cmd.data");
        if (d != null) {
            return (String)d.getAttribute(CMD_ATTR);
        }
        return null;
    }

    private void storeCustomCommand(String customCommand) throws IOException {
        FileObject data;
        FileObject root = FileUtil.getConfigRoot();
        FileObject folder = root.getFileObject(DATA_FOLDER);
        if (folder == null) {
            folder = root.createFolder(DATA_FOLDER);
        }
        if ((data = folder.getFileObject(DATA_FILE)) == null) {
            data = folder.createData(DATA_FILE);
        }
        data.setAttribute(CMD_ATTR, (Object)customCommand);
    }

    private void askForCustomCommand(File f) {
        SetCommandForm scf = new SetCommandForm(this.getCustomCommand());
        DialogDescriptor desc = new DialogDescriptor((Object)scf, NbBundle.getMessage(PDFOpenSupport.class, (String)"SetCommandDialog.title"));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (result == DialogDescriptor.OK_OPTION) {
            String command = scf.getCommand();
            try {
                this.storeCustomCommand(command);
                try {
                    this.openWithCustomCommand(command, f);
                }
                catch (Exception e) {
                    this.askForCustomCommand(f);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void openWithCustomCommand(String command, File file) throws IOException {
        String[] cmds = command.split(" ");
        for (int i = 0; i < cmds.length; ++i) {
            if (!FILENAME_PLACEHOLDER.equals(cmds[i])) continue;
            cmds[i] = file.getAbsolutePath();
        }
        Runtime.getRuntime().exec(cmds);
    }
}

