/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryActionsHandler;
import org.netbeans.lib.profiler.ui.memory.LivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;

public class LiveLivenessResultsPanel
extends LivenessResultsPanel
implements LiveResultsPanel,
ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_LiveShowStackTracesPopupItemName");
    private static final String STOP_CLASS_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopClassPopupItemName");
    private static final String STOP_BELOW_LINE_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopBelowLinePopupItemName");
    private static final String STOP_CLASS_SPEC_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopClassSpecPopupItemName");
    private static final String STOP_BELOW_LINE_SPEC_POPUP_ITEM_NAME = messages.getString("LiveLivenessResultsPanel_StopBelowLineSpecPopupItemName");
    private static final String LOG_CLASS_HISTORY = messages.getString("LiveResultsPanel_LogClassHistory");
    protected TargetAppRunner runner;
    private ClassHistoryActionsHandler historyActionsHandler;
    private ClassHistoryDataManager classHistoryManager;
    private JMenuItem popupRemoveProfForClass;
    private JMenuItem popupRemoveProfForClassesBelow;
    private JMenuItem popupShowSource;
    private JMenuItem popupShowStacks;
    private JMenuItem startHisto;
    private JPopupMenu popup;
    private ProfilingSessionStatus status;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveLivenessResultsPanel(TargetAppRunner runner, MemoryResUserActionsHandler actionsHandler, ClassHistoryActionsHandler historyActionsHandler, ClassHistoryDataManager classHistoryManager) {
        super(actionsHandler);
        this.runner = runner;
        this.status = runner.getProfilerClient().getStatus();
        this.historyActionsHandler = historyActionsHandler;
        this.classHistoryManager = classHistoryManager;
        this.initColumnsData();
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    @Override
    public String getViewName() {
        return "memory-liveness-live";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.popupRemoveProfForClass) {
            final int clickedLineLocal = this.clickedLine;
            this.resTable.clearSelection();
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    MemoryCCTProvider olcgb = LiveLivenessResultsPanel.this.runner.getProfilerClient().getMemoryCCTProvider();
                    boolean[] newlyUnprofiledClasses = new boolean[LiveLivenessResultsPanel.this.sortedClassIds.length];
                    int line = (Integer)LiveLivenessResultsPanel.this.filteredToFullIndexes.get(clickedLineLocal);
                    if (!olcgb.classMarkedUnprofiled(LiveLivenessResultsPanel.this.sortedClassIds[line])) {
                        olcgb.markClassUnprofiled(LiveLivenessResultsPanel.this.sortedClassIds[line]);
                        newlyUnprofiledClasses[LiveLivenessResultsPanel.this.sortedClassIds[line]] = true;
                        if (line < LiveLivenessResultsPanel.this.nTrackedAllocObjects.length) {
                            LiveLivenessResultsPanel.this.nTrackedAllocObjects[line] = 0L;
                            LiveLivenessResultsPanel.this.nTrackedLiveObjects[line] = 0;
                            LiveLivenessResultsPanel.this.trackedLiveObjectsSize[line] = 0L;
                            LiveLivenessResultsPanel.this.avgObjectAge[line] = 0.0f;
                            LiveLivenessResultsPanel.this.maxSurvGen[line] = 0;
                        }
                        LiveLivenessResultsPanel.this.nTotalAllocObjects[line] = 0;
                        LiveLivenessResultsPanel.this.deinstrumentMemoryProfiledClasses(newlyUnprofiledClasses);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    LiveLivenessResultsPanel.this.prepareResults();
                    if (LiveLivenessResultsPanel.this.resTable.getSelectedRow() == -1) {
                        int selectedLine = clickedLineLocal;
                        if (LiveLivenessResultsPanel.this.resTable.getRowCount() == clickedLineLocal) {
                            --selectedLine;
                        }
                        if (selectedLine >= 0) {
                            LiveLivenessResultsPanel.this.resTable.setRowSelectionInterval(selectedLine, selectedLine);
                        }
                    }
                }
            }.execute();
        } else if (source == this.popupRemoveProfForClassesBelow) {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    int line = LiveLivenessResultsPanel.this.clickedLine;
                    MemoryCCTProvider olcgb = LiveLivenessResultsPanel.this.runner.getProfilerClient().getMemoryCCTProvider();
                    boolean[] newlyUnprofiledClasses = new boolean[LiveLivenessResultsPanel.this.sortedClassIds.length];
                    int nClasses = LiveLivenessResultsPanel.this.filteredToFullIndexes.size();
                    for (int i = line + 1; i < nClasses; ++i) {
                        int index = (Integer)LiveLivenessResultsPanel.this.filteredToFullIndexes.get(i);
                        if (olcgb.classMarkedUnprofiled(LiveLivenessResultsPanel.this.sortedClassIds[index])) continue;
                        olcgb.markClassUnprofiled(LiveLivenessResultsPanel.this.sortedClassIds[index]);
                        newlyUnprofiledClasses[LiveLivenessResultsPanel.this.sortedClassIds[index]] = true;
                        LiveLivenessResultsPanel.this.nTrackedAllocObjects[index] = 0L;
                        LiveLivenessResultsPanel.this.nTrackedLiveObjects[index] = 0;
                        LiveLivenessResultsPanel.this.trackedLiveObjectsSize[index] = 0L;
                        LiveLivenessResultsPanel.this.avgObjectAge[index] = 0.0f;
                        LiveLivenessResultsPanel.this.maxSurvGen[index] = 0;
                        LiveLivenessResultsPanel.this.nTotalAllocObjects[index] = 0;
                    }
                    LiveLivenessResultsPanel.this.deinstrumentMemoryProfiledClasses(newlyUnprofiledClasses);
                    return null;
                }

                @Override
                protected void done() {
                    LiveLivenessResultsPanel.this.prepareResults();
                }
            }.execute();
        } else if (source == this.popupShowSource && this.popupShowSource != null) {
            this.showSourceForClass(this.selectedClassId);
        } else if (source == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (e.getSource() == this.startHisto) {
            String selectedClassName = StringUtils.userFormClassName((String)this.getClassName(this.selectedClassId));
            this.historyActionsHandler.showClassHistory(this.selectedClassId, selectedClassName);
        }
    }

    public void fetchResultsFromTargetApp() throws ClientUtils.TargetAppOrVMTerminated {
        int i;
        MemoryCCTProvider olcgb = this.runner.getProfilerClient().getMemoryCCTProvider();
        if (olcgb == null) {
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        MemoryCCTProvider.ObjectNumbersContainer onc = olcgb.getLivenessObjectNumbers();
        this.nTrackedAllocObjects = onc.nTrackedAllocObjects;
        this.nTrackedLiveObjects = onc.nTrackedLiveObjects;
        this.trackedLiveObjectsSize = onc.trackedLiveObjectsSize;
        this.avgObjectAge = onc.avgObjectAge;
        this.maxSurvGen = onc.maxSurvGen;
        this.nInstrClasses = onc.nInstrClasses;
        if (this.nTrackedLiveObjects == null && this.nTrackedAllocObjects == null || this.avgObjectAge == null || this.maxSurvGen == null) {
            return;
        }
        this.nTotalAllocObjects = this.runner.getProfilerClient().getAllocatedObjectsCountResults();
        this.nTrackedItems = Math.min(this.nTrackedAllocObjects.length, this.nTrackedLiveObjects.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.trackedLiveObjectsSize.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.avgObjectAge.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.maxSurvGen.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nInstrClasses);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nTotalAllocObjects.length);
        for (i = 0; i < this.nTrackedItems; ++i) {
            if (this.nTrackedAllocObjects[i] != -1L) continue;
            this.nTotalAllocObjects[i] = 0;
        }
        this.maxValue = 0L;
        this.nTotalTrackedBytes = 0L;
        this.nTotalTracked = 0L;
        for (i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.trackedLiveObjectsSize[i]) {
                this.maxValue = this.trackedLiveObjectsSize[i];
            }
            this.nTotalTrackedBytes += this.trackedLiveObjectsSize[i];
            this.nTotalTracked += (long)this.nTrackedLiveObjects[i];
        }
        if (this.classHistoryManager.isTrackingClass()) {
            this.classHistoryManager.processData(this.nTotalAllocObjects, this.nTrackedLiveObjects, this.trackedLiveObjectsSize);
        }
        this.initDataUponResultsFetch();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    @Override
    public boolean hasView() {
        return this.resTable != null;
    }

    @Override
    public boolean supports(int instrumentationType) {
        return instrumentationType == 6;
    }

    @Override
    public void updateLiveResults() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        try {
            if (this.runner.getProfilingSessionStatus().targetAppRunning) {
                this.reset();
                this.fetchResultsFromTargetApp();
            }
            this.prepareResults();
            if (selectedRowString != null) {
                this.resTable.selectRowByContents(selectedRowString, 0, false);
            }
            if (this.resTable != null && this.resTable.isFocusOwner()) {
                this.resTable.requestFocusInWindow();
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)e.getMessage());
            ProfilerLogger.log((String)e.getMessage());
        }
        this.updateResultsInProgress = false;
    }

    @Override
    protected String getClassName(int classId) {
        return this.status.getClassNames()[classId];
    }

    @Override
    protected String[] getClassNames() {
        return this.status.getClassNames();
    }

    protected int getPercentsTracked() {
        return 100 / this.runner.getProfilerEngineSettings().getAllocTrackEvery();
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popupRemoveProfForClass = new JMenuItem();
            this.popupRemoveProfForClassesBelow = new JMenuItem();
            this.popupRemoveProfForClass.setText(STOP_CLASS_POPUP_ITEM_NAME);
            this.popupRemoveProfForClassesBelow.setText(STOP_BELOW_LINE_POPUP_ITEM_NAME);
            if (GoToSource.isAvailable()) {
                Font boldfont = this.popup.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
                this.popupShowSource.setFont(boldfont);
                this.popup.add(this.popupShowSource);
                this.popup.addSeparator();
            }
            if (this.runner.getProfilerEngineSettings().getAllocStackTraceLimit() != 0) {
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.popup.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
                this.popup.addSeparator();
            }
            this.popup.add(this.popupRemoveProfForClass);
            this.popup.add(this.popupRemoveProfForClassesBelow);
            if (this.popupShowSource != null) {
                this.popupShowSource.addActionListener(this);
            }
            this.popupRemoveProfForClass.addActionListener(this);
            this.popupRemoveProfForClassesBelow.addActionListener(this);
            this.popup.addSeparator();
            this.startHisto = new JMenuItem();
            this.startHisto.setText(LOG_CLASS_HISTORY);
            this.popup.add(this.startHisto);
            this.startHisto.addActionListener(this);
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (LiveLivenessResultsPanel.this.updateResultsPending) {
                                LiveLivenessResultsPanel.this.updateLiveResults();
                                LiveLivenessResultsPanel.this.updateResultsPending = false;
                            }
                        }
                    });
                }
            });
        }
        boolean jvmAlive = this.status.targetAppRunning;
        if (this.popupShowStacks != null) {
            this.popupShowStacks.setEnabled(jvmAlive);
        }
        this.popupRemoveProfForClass.setEnabled(jvmAlive);
        this.popupRemoveProfForClassesBelow.setEnabled(jvmAlive);
        this.startHisto.setEnabled(jvmAlive);
        return this.popup;
    }

    protected void adjustFramePopupMenuTextIfNecessary() {
        String name = this.sortedClassNames[this.clickedLine];
        this.popupRemoveProfForClass.setText(MessageFormat.format(STOP_CLASS_SPEC_POPUP_ITEM_NAME, name));
        this.popupRemoveProfForClassesBelow.setText(MessageFormat.format(STOP_BELOW_LINE_SPEC_POPUP_ITEM_NAME, name));
    }

    @Override
    protected void performDefaultAction(int classId) {
        this.showSourceForClass(classId);
    }

    private void deinstrumentMemoryProfiledClasses(boolean[] newlyUnprofiledClasses) {
        try {
            this.runner.getProfilerClient().deinstrumentMemoryProfiledClasses(newlyUnprofiledClasses);
        }
        catch (InstrumentationException ex1) {
            this.runner.getAppStatusHandler().displayError(ex1.getMessage());
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex2) {
            this.runner.getAppStatusHandler().displayWarning(ex2.getMessage());
            ProfilerLogger.log((String)ex2.getMessage());
        }
    }
}

