/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ActiveTaskPanel
extends JPanel {
    public ImageIcon iconShowRecently;
    private TaskNode taskNode;
    private LinkButton btnTaskName;
    private Deque<TaskNode> recentlyActivatedTasks;
    private JButton btnRecently;
    private ImageIcon iconHideRecently;
    private JToolBar toolBar;
    private TreeLabel activeTaskLabel;

    public ActiveTaskPanel(TaskNode taskNode) {
        this.taskNode = taskNode;
        this.recentlyActivatedTasks = new ArrayDeque<TaskNode>();
        this.iconHideRecently = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/arrow-down.png", (boolean)true);
        this.initComponents();
        this.setBackground(ColorManager.getDefault().getDefaultBackground());
        this.init();
    }

    private void init() {
        this.activeTaskLabel = new TreeLabel(NbBundle.getMessage(ActiveTaskPanel.class, (String)"LBL_ActiveTask"));
        this.activeTaskLabel.setFont(this.activeTaskLabel.getFont().deriveFont(1));
        this.add((Component)this.activeTaskLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setOpaque(false);
        this.btnRecently = new JButton(this.iconHideRecently);
        if (this.recentlyActivatedTasks != null) {
            this.btnRecently.setEnabled(!this.recentlyActivatedTasks.isEmpty());
        }
        this.btnRecently.setBorderPainted(false);
        this.btnRecently.setFocusable(false);
        this.btnRecently.setOpaque(false);
        this.btnRecently.setToolTipText(NbBundle.getMessage(ActiveTaskPanel.class, (String)"LBL_RecentlyTooltip"));
        final JPopupMenu recentlyPopup = this.createRecentlyPopup();
        this.btnRecently.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ActiveTaskPanel.this.btnRecently.isEnabled()) {
                    recentlyPopup.show(e.getComponent(), ActiveTaskPanel.this.btnRecently.getX(), ActiveTaskPanel.this.btnRecently.getY() + ActiveTaskPanel.this.btnRecently.getHeight());
                }
            }
        });
        this.toolBar.add(this.btnRecently);
        this.add((Component)this.toolBar, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.btnTaskName = new LinkButton("", (Action)new Actions.OpenTaskAction(this.taskNode));
        this.btnTaskName.setFont(this.btnTaskName.getFont().deriveFont(1));
        this.btnTaskName.setOpaque(false);
        this.btnTaskName.setToolTipText(this.taskNode.getTask().getTooltip());
        final JPopupMenu taskPopup = this.createTaskPopup();
        this.btnTaskName.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    taskPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.setTaskNameText();
        this.btnTaskName.setMinimumSize(new Dimension(0, this.btnTaskName.getMinimumSize().height));
        this.add((Component)this.btnTaskName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setTaskNameText() {
        this.btnTaskName.setText(DashboardUtils.getTaskPlainDisplayText(this.taskNode.getTask(), (JComponent)this.btnTaskName, this.getMaxTextWidth()));
    }

    public TaskNode getTaskNode() {
        return this.taskNode;
    }

    public void setTaskNode(TaskNode taskNode) {
        if (this.taskNode != null) {
            this.deactivatedTask(this.taskNode, taskNode);
        }
        this.taskNode = taskNode;
        this.removeAll();
        this.init();
    }

    private int getMaxTextWidth() {
        return this.getVisibleRect().width - this.iconHideRecently.getIconWidth() - 20;
    }

    private JPopupMenu createTaskPopup() {
        JPopupMenu popup = new JPopupMenu();
        List<Action> actions = Actions.getTaskPopupActions(this.taskNode);
        for (int i = 0; i < actions.size(); ++i) {
            popup.add(actions.get(i));
        }
        return popup;
    }

    private JPopupMenu createRecentlyPopup() {
        JPopupMenu popup = new JPopupMenu();
        Iterator<TaskNode> it = this.recentlyActivatedTasks.iterator();
        for (int i = 0; i < 5 && it.hasNext(); ++i) {
            TaskNode t = it.next();
            popup.add(new ActivateTaskInternal(t));
        }
        return popup;
    }

    private void deactivatedTask(TaskNode deactivated, TaskNode activated) {
        this.recentlyActivatedTasks.remove(deactivated);
        this.recentlyActivatedTasks.addFirst(deactivated);
        this.recentlyActivatedTasks.remove(activated);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private class ActivateTaskInternal
    extends AbstractAction {
        private TaskNode taskNode;

        public ActivateTaskInternal(TaskNode taskNode) {
            super(taskNode.getTask().getDisplayName());
            this.taskNode = taskNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.ActivateTaskAction action = new Actions.ActivateTaskAction(this.taskNode);
            action.actionPerformed(e);
        }
    }
}

