/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.catalog;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.lib.api.dtd.ReaderProvider;
import org.netbeans.modules.html.editor.lib.api.dtd.ReaderProviderFactory;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor2;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HtmlCatalog
implements CatalogReader,
CatalogDescriptor2,
EntityResolver {
    private Logger LOGGER = Logger.getLogger(HtmlCatalog.class.getSimpleName());
    private Collection<ReaderProvider> providers = new ArrayList<ReaderProvider>();

    public HtmlCatalog() {
        Collection factories = Lookup.getDefault().lookupAll(ReaderProviderFactory.class);
        for (ReaderProviderFactory factory : factories) {
            this.providers.addAll(factory.getProviders());
        }
        if (this.LOGGER.isLoggable(Level.FINE)) {
            for (ReaderProvider provider : this.providers) {
                this.LOGGER.log(Level.FINE, "adding provider" + provider.toString() + ", public ids:");
                for (String publicId : provider.getIdentifiers()) {
                    this.LOGGER.log(Level.FINE, "\tadding provider" + publicId);
                }
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.LOGGER.log(Level.FINE, "Resolving entity [publicId: '" + publicId + "', systemId: '" + systemId + "']");
        }
        for (ReaderProvider provider : this.providers) {
            FileObject systemIdFile = provider.getSystemId(publicId);
            if (systemIdFile == null) continue;
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.log(Level.FINE, "Got resource: " + systemIdFile.getPath());
            }
            return new InputSource(provider.getReaderForIdentifier(publicId, systemId));
        }
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.LOGGER.log(Level.FINE, "No resource found for publicId: " + publicId);
        }
        return null;
    }

    public Iterator getPublicIDs() {
        ArrayList result = new ArrayList();
        for (ReaderProvider each : this.providers) {
            result.addAll(each.getIdentifiers());
        }
        return result.iterator();
    }

    public String getSystemID(String publicId) {
        if (publicId == null) {
            return null;
        }
        for (ReaderProvider provider : this.providers) {
            URL url;
            FileObject systemIdFile = provider.getSystemId(publicId);
            if (systemIdFile == null || (url = URLMapper.findURL((FileObject)systemIdFile, (int)0)) == null) continue;
            return url.toExternalForm();
        }
        return null;
    }

    public String getIconResource(int type) {
        return "org/netbeans/modules/html/catalog/resources/DDCatalog.gif";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(HtmlCatalog.class, (String)"LBL_HtmlCatalog");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(HtmlCatalog.class, (String)"DESC_HtmlCatalog");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public void refresh() {
    }

    public String resolveURI(String name) {
        return null;
    }

    public String resolvePublic(String publicId) {
        return null;
    }

    public void addCatalogListener(CatalogListener l) {
    }

    public void removeCatalogListener(CatalogListener l) {
    }
}

