/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.RubyStringBuilder;

@JRubyClass(name={"Java::JavaClass"}, parent="Java::JavaObject", include={"Comparable"})
public class JavaClass
extends JavaObject {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private RubyArray constructors;

    public JavaClass(Ruby runtime2, Class<?> klass) {
        this(runtime2, runtime2.getJavaSupport().getJavaClassClass(), klass);
    }

    JavaClass(Ruby runtime2, RubyClass javaClassProxy, Class<?> klass) {
        super(runtime2, javaClassProxy, klass);
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JavaClass && this.getValue() == ((JavaClass)other).getValue();
    }

    @Override
    public final int hashCode() {
        return this.getValue().hashCode();
    }

    public final RubyModule getProxyModule() {
        return Java.getProxyClass(this.getRuntime(), this.javaClass());
    }

    public final RubyClass getProxyClass() {
        return (RubyClass)Java.getProxyClass(this.getRuntime(), this.javaClass());
    }

    private IRubyObject addProxyExtender(ThreadContext context, IRubyObject extender) {
        if (!extender.respondsTo("extend_proxy")) {
            throw context.runtime.newTypeError("proxy extender must have an extend_proxy method");
        }
        RubyModule proxy2 = Java.getProxyClass(context.runtime, this.javaClass());
        return extender.callMethod(context, "extend_proxy", proxy2);
    }

    @JRubyMethod(required=1)
    public IRubyObject extend_proxy(ThreadContext context, IRubyObject extender) {
        this.addProxyExtender(context, extender);
        return context.nil;
    }

    public static JavaClass get(Ruby runtime2, Class<?> klass) {
        return runtime2.getJavaSupport().getJavaClassFromCache(klass);
    }

    @Deprecated
    public static RubyArray getRubyArray(Ruby runtime2, Class<?>[] classes2) {
        return JavaClass.toRubyArray(runtime2, classes2);
    }

    public static RubyArray toRubyArray(Ruby runtime2, Class<?>[] classes2) {
        IRubyObject[] javaClasses = new IRubyObject[classes2.length];
        int i2 = classes2.length;
        while (--i2 >= 0) {
            javaClasses[i2] = JavaClass.get(runtime2, classes2[i2]);
        }
        return RubyArray.newArrayMayCopy(runtime2, javaClasses);
    }

    public static RubyClass createJavaClassClass(Ruby runtime2, RubyModule Java2) {
        return JavaClass.createJavaClassClass(runtime2, Java2, Java2.getClass("JavaObject"));
    }

    static RubyClass createJavaClassClass(Ruby runtime2, RubyModule Java2, RubyClass JavaObject2) {
        RubyClass JavaClass2 = Java2.defineClassUnder("JavaClass", JavaObject2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaClass2.includeModule(runtime2.getModule("Comparable"));
        JavaClass2.defineAnnotatedMethods(JavaClass.class);
        JavaClass2.getMetaClass().undefineMethod("new");
        JavaClass2.getMetaClass().undefineMethod("allocate");
        return JavaClass2;
    }

    public final Class javaClass() {
        return (Class)this.getValue();
    }

    public static Class<?> getJavaClass(ThreadContext context, RubyModule proxy2) {
        return ((JavaClass)JavaClass.java_class(context, proxy2)).javaClass();
    }

    public static Class<?> getJavaClassIfProxy(ThreadContext context, RubyModule proxy2) {
        JavaClass javaClass = JavaClass.getJavaClassIfProxyImpl(context, proxy2);
        return javaClass == null ? null : javaClass.javaClass();
    }

    private static JavaClass getJavaClassIfProxyImpl(ThreadContext context, RubyModule proxy2) {
        IRubyObject java_class2 = JavaClass.java_class(context, proxy2);
        return java_class2 instanceof JavaClass ? (JavaClass)java_class2 : null;
    }

    public static boolean isProxyType(ThreadContext context, RubyModule proxy2) {
        return JavaClass.getJavaClassIfProxyImpl(context, proxy2) != null;
    }

    public static IRubyObject java_class(ThreadContext context, RubyModule type2) {
        IRubyObject java_class2 = type2.getInstanceVariable("@java_class");
        if (java_class2 == null) {
            java_class2 = type2.respondsTo("java_class") ? Helpers.invoke(context, type2, "java_class") : context.nil;
        }
        return java_class2;
    }

    public static JavaClass resolveType(ThreadContext context, IRubyObject type2) {
        if (type2 instanceof RubyString || type2 instanceof RubySymbol) {
            Ruby runtime2 = context.runtime;
            String className = type2.toString();
            JavaClass targetType = runtime2.getJavaSupport().getNameClassMap().get(className);
            if (targetType == null) {
                targetType = JavaClass.forNameVerbose(runtime2, className);
            }
            return targetType;
        }
        return JavaClass.resolveClassType(context, type2);
    }

    private static JavaClass resolveClassType(ThreadContext context, IRubyObject type2) {
        if (type2 instanceof JavaProxy) {
            Object wrapped = ((JavaProxy)type2).getObject();
            if (wrapped instanceof Class) {
                return JavaClass.get(context.runtime, (Class)wrapped);
            }
            return null;
        }
        if (type2 instanceof JavaClass) {
            return (JavaClass)type2;
        }
        if (type2 instanceof RubyModule) {
            return JavaClass.getJavaClassIfProxyImpl(context, (RubyModule)type2);
        }
        return null;
    }

    static boolean isPrimitiveName(String name2) {
        return JavaUtil.getPrimitiveClass(name2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaClass forNameVerbose(Ruby runtime2, String className) {
        Class klass = null;
        if (className.length() < 8 && Character.isLowerCase(className.charAt(0))) {
            klass = JavaUtil.getPrimitiveClass(className);
        }
        Class<JavaClass> clazz = JavaClass.class;
        synchronized (JavaClass.class) {
            if (klass == null) {
                klass = runtime2.getJavaSupport().loadJavaClassVerbose(className);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return JavaClass.get(runtime2, klass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaClass forNameQuiet(Ruby runtime2, String className) {
        Class<JavaClass> clazz = JavaClass.class;
        synchronized (JavaClass.class) {
            Class klass = runtime2.getJavaSupport().loadJavaClassQuiet(className);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return JavaClass.get(runtime2, klass);
        }
    }

    @JRubyMethod(name={"for_name"}, required=1, meta=true)
    public static JavaClass for_name(IRubyObject recv2, IRubyObject name2) {
        return JavaClass.for_name(recv2, name2.asJavaString());
    }

    static JavaClass for_name(IRubyObject recv2, String name2) {
        return JavaClass.forNameVerbose(recv2.getRuntime(), name2);
    }

    @JRubyMethod
    public RubyModule ruby_class() {
        return Java.getProxyClass(this.getRuntime(), this.javaClass());
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"protected?"})
    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"interface?"})
    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    @JRubyMethod(name={"array?"})
    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    @JRubyMethod(name={"enum?"})
    public RubyBoolean enum_p() {
        return this.getRuntime().newBoolean(this.javaClass().isEnum());
    }

    @JRubyMethod(name={"annotation?"})
    public RubyBoolean annotation_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnnotation());
    }

    @JRubyMethod(name={"anonymous_class?"})
    public RubyBoolean anonymous_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnonymousClass());
    }

    @JRubyMethod(name={"local_class?"})
    public RubyBoolean local_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isLocalClass());
    }

    @JRubyMethod(name={"member_class?"})
    public RubyBoolean member_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isMemberClass());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(this.javaClass().isSynthetic());
    }

    @JRubyMethod(name={"name", "to_s"})
    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    @Override
    @JRubyMethod
    public RubyString inspect() {
        return this.getRuntime().newString("class " + this.javaClass().getName());
    }

    @JRubyMethod
    public IRubyObject canonical_name() {
        String canonicalName = this.javaClass().getCanonicalName();
        if (canonicalName != null) {
            return this.getRuntime().newString(canonicalName);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"package"})
    public IRubyObject get_package() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getPackage());
    }

    @JRubyMethod
    public IRubyObject class_loader() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getClassLoader());
    }

    @JRubyMethod
    public IRubyObject protection_domain() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getProtectionDomain());
    }

    @JRubyMethod(required=1)
    public IRubyObject resource(IRubyObject name2) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResource(name2.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_stream(IRubyObject name2) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResourceAsStream(name2.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_string(IRubyObject name2) {
        InputStream in = this.javaClass().getResourceAsStream(name2.asJavaString());
        if (in == null) {
            return this.getRuntime().getNil();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return this.getRuntime().newString(new ByteList(out.toByteArray(), false));
    }

    @JRubyMethod(required=1)
    public IRubyObject annotation(IRubyObject annoClass) {
        Ruby runtime2 = this.getRuntime();
        if (!(annoClass instanceof JavaClass)) {
            throw runtime2.newTypeError(annoClass, runtime2.getJavaSupport().getJavaClassClass());
        }
        Class annotation2 = ((JavaClass)annoClass).javaClass();
        return Java.getInstance(runtime2, this.javaClass().getAnnotation(annotation2));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"}, required=1)
    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        Ruby runtime2 = this.getRuntime();
        if (!(annoClass instanceof JavaClass)) {
            throw runtime2.newTypeError(annoClass, runtime2.getJavaSupport().getJavaClassClass());
        }
        Class annotation2 = ((JavaClass)annoClass).javaClass();
        return runtime2.newBoolean(this.javaClass().isAnnotationPresent(annotation2));
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(this.javaClass().getModifiers());
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = this.javaClass().getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_class() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnclosingClass());
    }

    @JRubyMethod
    public IRubyObject enclosing_constructor() {
        Constructor<?> ctor = this.javaClass().getEnclosingConstructor();
        if (ctor != null) {
            return new JavaConstructor(this.getRuntime(), ctor);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_method() {
        Method meth = this.javaClass().getEnclosingMethod();
        if (meth != null) {
            return new JavaMethod(this.getRuntime(), meth);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enum_constants() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnumConstants());
    }

    @JRubyMethod
    public IRubyObject generic_interfaces() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericInterfaces());
    }

    @JRubyMethod
    public IRubyObject generic_superclass() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericSuperclass());
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject signers() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getSigners());
    }

    public static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaClass.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int len = className.length();
        int i2 = className.lastIndexOf(36);
        if (i2 != -1) {
            while (++i2 < len && Character.isDigit(className.charAt(i2))) {
            }
            return className.substring(i2);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @JRubyMethod
    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    @JRubyMethod
    public IRubyObject superclass() {
        Class superclass2 = this.javaClass().getSuperclass();
        if (superclass2 == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass2);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject other) {
        ConcreteJavaProxy proxy2;
        Object wrapped;
        Class thisClass = this.javaClass();
        Class otherClass = null;
        if (other instanceof JavaClass) {
            otherClass = ((JavaClass)other).javaClass();
        } else if (other instanceof ConcreteJavaProxy && (wrapped = (proxy2 = (ConcreteJavaProxy)other).getObject()) instanceof Class) {
            otherClass = (Class)wrapped;
        }
        if (otherClass != null) {
            if (thisClass == otherClass) {
                return this.getRuntime().newFixnum(0);
            }
            if (otherClass.isAssignableFrom(thisClass)) {
                return this.getRuntime().newFixnum(-1);
            }
            if (thisClass.isAssignableFrom(otherClass)) {
                return this.getRuntime().newFixnum(1);
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyArray java_instance_methods() {
        return this.toJavaMethods(this.javaClass().getMethods(), false);
    }

    @JRubyMethod
    public RubyArray declared_instance_methods() {
        return this.toJavaMethods(this.javaClass().getDeclaredMethods(), false);
    }

    @JRubyMethod
    public RubyArray java_class_methods() {
        return this.toJavaMethods(this.javaClass().getMethods(), true);
    }

    @JRubyMethod
    public RubyArray declared_class_methods() {
        return this.toJavaMethods(this.javaClass().getDeclaredMethods(), true);
    }

    private RubyArray toJavaMethods(Method[] methods2, boolean isStatic) {
        Ruby runtime2 = this.getRuntime();
        RubyArray result2 = runtime2.newArray(methods2.length);
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            Method method2 = methods2[i2];
            if (isStatic != Modifier.isStatic(method2.getModifiers())) continue;
            result2.append(new JavaMethod(runtime2, method2));
        }
        return result2;
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod java_method(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        if (args2.length < 1) {
            throw runtime2.newArgumentError(args2.length, 1);
        }
        String methodName = args2[0].asJavaString();
        try {
            Class<?>[] argumentTypes = JavaClass.getArgumentTypes(runtime2, args2, 1);
            Method method2 = this.javaClass().getMethod(methodName, argumentTypes);
            return new JavaMethod(runtime2, method2);
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, this.javaClass().getName()), false), methodName);
        }
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod declared_method(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        if (args2.length < 1) {
            throw runtime2.newArgumentError(args2.length, 1);
        }
        String methodName = args2[0].asJavaString();
        try {
            Class<?>[] argumentTypes = JavaClass.getArgumentTypes(runtime2, args2, 1);
            Method method2 = this.javaClass().getDeclaredMethod(methodName, argumentTypes);
            return new JavaMethod(runtime2, method2);
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, this.javaClass().getName()), false), methodName);
        }
    }

    @JRubyMethod(required=1, rest=true)
    public JavaCallable declared_method_smart(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        if (args2.length < 1) {
            throw runtime2.newArgumentError(args2.length, 1);
        }
        String methodName = args2[0].asJavaString();
        Class<?>[] argumentTypes = JavaClass.getArgumentTypes(runtime2, args2, 1);
        JavaCallable callable = JavaClass.getMatchingCallable(runtime2, this.javaClass(), methodName, argumentTypes);
        if (callable != null) {
            return callable;
        }
        throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, this.javaClass().getName()), false), methodName);
    }

    public static JavaCallable getMatchingCallable(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        if (methodName.length() == 6 && "<init>".equals(methodName)) {
            return JavaConstructor.getMatchingConstructor(runtime2, javaClass, argumentTypes);
        }
        return JavaMethod.getMatchingDeclaredMethod(runtime2, javaClass, methodName, argumentTypes);
    }

    private static Class<?>[] getArgumentTypes(Ruby runtime2, IRubyObject[] args2, int offset2) {
        int length2 = args2.length;
        if (length2 == offset2) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] argumentTypes = new Class[length2 - offset2];
        for (int i2 = offset2; i2 < length2; ++i2) {
            IRubyObject arg2 = args2[i2];
            JavaClass type2 = arg2 instanceof JavaClass ? (JavaClass)arg2 : (arg2.respondsTo("java_class") ? (JavaClass)arg2.callMethod(runtime2.getCurrentContext(), "java_class") : JavaClass.forNameVerbose(runtime2, arg2.asJavaString()));
            argumentTypes[i2 - offset2] = type2.javaClass();
        }
        return argumentTypes;
    }

    @JRubyMethod
    public RubyArray constructors() {
        RubyArray constructors2 = this.constructors;
        if (constructors2 != null) {
            return constructors2;
        }
        this.constructors = JavaClass.buildConstructors(this.getRuntime(), this.javaClass().getConstructors());
        return this.constructors;
    }

    @JRubyMethod
    public RubyArray classes() {
        return JavaClass.toRubyArray(this.getRuntime(), this.javaClass().getClasses());
    }

    @JRubyMethod
    public RubyArray declared_classes() {
        Ruby runtime2 = this.getRuntime();
        Class javaClass = this.javaClass();
        try {
            Class<?>[] classes2 = javaClass.getDeclaredClasses();
            RubyArray result2 = runtime2.newArray(classes2.length);
            for (int i2 = 0; i2 < classes2.length; ++i2) {
                if (!Modifier.isPublic(classes2[i2].getModifiers())) continue;
                result2.append(JavaClass.get(runtime2, classes2[i2]));
            }
            return result2;
        }
        catch (SecurityException e) {
            try {
                Class<?>[] classes3 = javaClass.getClasses();
                RubyArray result3 = runtime2.newArray(classes3.length);
                for (int i3 = 0; i3 < classes3.length; ++i3) {
                    if (javaClass != classes3[i3].getDeclaringClass()) continue;
                    result3.append(JavaClass.get(runtime2, classes3[i3]));
                }
                return result3;
            }
            catch (SecurityException securityException) {
                return RubyArray.newEmptyArray(runtime2);
            }
        }
    }

    @JRubyMethod
    public RubyArray declared_constructors() {
        return JavaClass.buildConstructors(this.getRuntime(), this.javaClass().getDeclaredConstructors());
    }

    private static RubyArray buildConstructors(Ruby runtime2, Constructor<?>[] constructors2) {
        RubyArray result2 = RubyArray.newArray(runtime2, constructors2.length);
        for (int i2 = 0; i2 < constructors2.length; ++i2) {
            result2.append(new JavaConstructor(runtime2, constructors2[i2]));
        }
        return result2;
    }

    @JRubyMethod(rest=true)
    public JavaConstructor constructor(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        try {
            Class<?>[] parameterTypes = JavaClass.getArgumentTypes(runtime2, args2, 0);
            Constructor constructor2 = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(runtime2, constructor2);
        }
        catch (NoSuchMethodException nsme) {
            throw runtime2.newNameError("no matching java constructor", null);
        }
    }

    @JRubyMethod(rest=true)
    public JavaConstructor declared_constructor(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        try {
            Class<?>[] parameterTypes = JavaClass.getArgumentTypes(runtime2, args2, 0);
            Constructor constructor2 = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(runtime2, constructor2);
        }
        catch (NoSuchMethodException nsme) {
            throw runtime2.newNameError("no matching java constructor", null);
        }
    }

    @JRubyMethod
    public JavaClass array_class() {
        Class<?> arrayClass = Array.newInstance(this.javaClass(), 0).getClass();
        return JavaClass.get(this.getRuntime(), arrayClass);
    }

    @JRubyMethod(required=1)
    public JavaObject new_array(IRubyObject lengthArgument) {
        if (lengthArgument instanceof RubyInteger) {
            int length2 = ((RubyInteger)lengthArgument).getIntValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length2));
        }
        if (lengthArgument instanceof RubyArray) {
            IRubyObject[] aryLengths = ((RubyArray)lengthArgument).toJavaArrayMaybeUnsafe();
            int length3 = aryLengths.length;
            if (length3 == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] dimensions2 = new int[length3];
            int i2 = length3;
            while (--i2 >= 0) {
                IRubyObject dimLength = aryLengths[i2];
                if (!(dimLength instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(dimLength, this.getRuntime().getInteger());
                }
                dimensions2[i2] = ((RubyInteger)dimLength).getIntValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), dimensions2));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    public IRubyObject emptyJavaArray(ThreadContext context) {
        return ArrayUtils.emptyJavaArrayDirect(context, this.javaClass());
    }

    public IRubyObject javaArraySubarray(ThreadContext context, JavaArray fromArray, int index2, int size2) {
        return ArrayUtils.javaArraySubarrayDirect(context, this.getValue(), index2, size2);
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, JavaArray additional) {
        return ArrayUtils.concatArraysDirect(context, original.getValue(), additional.getValue());
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, IRubyObject additional) {
        return ArrayUtils.concatArraysDirect(context, original.getValue(), additional);
    }

    @Deprecated
    public IRubyObject javaArrayFromRubyArray(ThreadContext context, IRubyObject fromArray) {
        if (!(fromArray instanceof RubyArray)) {
            Ruby runtime2 = context.runtime;
            throw runtime2.newTypeError(fromArray, runtime2.getArray());
        }
        return this.javaArrayFromRubyArray(context, (RubyArray)fromArray);
    }

    public final IRubyObject javaArrayFromRubyArray(ThreadContext context, RubyArray fromArray) {
        Ruby runtime2 = context.runtime;
        Object newArray = this.javaArrayFromRubyArrayDirect(context, fromArray);
        return new ArrayJavaProxy(runtime2, Java.getProxyClassForObject(runtime2, newArray), newArray, JavaUtil.getJavaConverter(this.javaClass()));
    }

    public final Object javaArrayFromRubyArrayDirect(ThreadContext context, RubyArray fromArray) {
        Ruby runtime2 = context.runtime;
        Class type2 = this.javaClass();
        Object newArray = Array.newInstance(type2, fromArray.size());
        if (type2.isArray()) {
            for (int i2 = 0; i2 < fromArray.size(); ++i2) {
                Object nestedArray;
                Class<?> nestedType = type2.getComponentType();
                Object element = fromArray.eltInternal(i2);
                if (element instanceof RubyArray) {
                    JavaClass componentType = JavaClass.get(runtime2, nestedType);
                    nestedArray = componentType.javaArrayFromRubyArrayDirect(context, (IRubyObject)element);
                } else {
                    nestedArray = type2.isInstance(element) ? element : element.toJava(type2);
                }
                ArrayUtils.setWithExceptionHandlingDirect(runtime2, newArray, i2, nestedArray);
            }
        } else {
            ArrayUtils.copyDataToJavaArrayDirect(fromArray, newArray);
        }
        return newArray;
    }

    public final Object javaArrayFromRubyArrayDirect(ThreadContext context, IRubyObject fromArray) {
        if (!(fromArray instanceof RubyArray)) {
            Ruby runtime2 = context.runtime;
            throw runtime2.newTypeError(fromArray, runtime2.getArray());
        }
        return this.javaArrayFromRubyArrayDirect(context, (RubyArray)fromArray);
    }

    @JRubyMethod
    public RubyArray fields() {
        return JavaClass.buildFieldResults(this.getRuntime(), this.javaClass().getFields());
    }

    @JRubyMethod
    public RubyArray declared_fields() {
        return JavaClass.buildFieldResults(this.getRuntime(), this.javaClass().getDeclaredFields());
    }

    private static RubyArray buildFieldResults(Ruby runtime2, Field[] fields2) {
        RubyArray result2 = runtime2.newArray(fields2.length);
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            result2.append(new JavaField(runtime2, fields2[i2]));
        }
        return result2;
    }

    @JRubyMethod(required=1)
    public JavaField field(ThreadContext context, IRubyObject name2) {
        Class javaClass = this.javaClass();
        Ruby runtime2 = context.runtime;
        String stringName = name2.asJavaString();
        try {
            return new JavaField(runtime2, javaClass.getField(stringName));
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    return new JavaField(runtime2, javaClass.getField(newName));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            throw JavaClass.undefinedFieldError(runtime2, javaClass.getName(), stringName);
        }
    }

    @JRubyMethod(required=1)
    public JavaField declared_field(ThreadContext context, IRubyObject name2) {
        Class javaClass = this.javaClass();
        Ruby runtime2 = context.runtime;
        String stringName = name2.asJavaString();
        try {
            return new JavaField(runtime2, javaClass.getDeclaredField(stringName));
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    return new JavaField(runtime2, javaClass.getDeclaredField(newName));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            throw JavaClass.undefinedFieldError(runtime2, javaClass.getName(), stringName);
        }
    }

    public static RaiseException undefinedFieldError(Ruby runtime2, String javaClassName, String name2) {
        return runtime2.newNameError("undefined field '" + name2 + "' for class '" + javaClassName + "'", name2);
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return JavaClass.toRubyArray(this.getRuntime(), this.javaClass().getInterfaces());
    }

    @JRubyMethod(name={"primitive?"})
    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    @JRubyMethod(name={"assignable_from?"}, required=1)
    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        return this.isAssignableFrom(otherClass) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public final boolean isAssignableFrom(Class<?> clazz) {
        return JavaClass.assignable(this.javaClass(), clazz);
    }

    public static boolean assignable(Class<?> target, Class<?> from) {
        if (target.isPrimitive()) {
            target = CodegenUtils.getBoxType(target);
        } else if (from == Void.TYPE || target.isAssignableFrom(from)) {
            return true;
        }
        if (from.isPrimitive()) {
            from = CodegenUtils.getBoxType(from);
        }
        if (target.isAssignableFrom(from)) {
            return true;
        }
        if (Number.class.isAssignableFrom(target)) {
            if (Number.class.isAssignableFrom(from)) {
                return true;
            }
            if (from == Character.class) {
                return true;
            }
        } else if (target == Character.class && Number.class.isAssignableFrom(from)) {
            return true;
        }
        return false;
    }

    @JRubyMethod
    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    public static Constructor[] getConstructors(Class<?> clazz) {
        try {
            return clazz.getConstructors();
        }
        catch (SecurityException e) {
            return new Constructor[0];
        }
    }

    public static Class<?>[] getDeclaredClasses(Class<?> clazz) {
        try {
            return clazz.getDeclaredClasses();
        }
        catch (SecurityException e) {
            return new Class[0];
        }
        catch (NoClassDefFoundError cnfe) {
            return new Class[0];
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        try {
            return clazz.getDeclaredFields();
        }
        catch (SecurityException e) {
            return JavaClass.getFields(clazz);
        }
    }

    public static Field[] getFields(Class<?> clazz) {
        try {
            return clazz.getFields();
        }
        catch (SecurityException e) {
            return new Field[0];
        }
    }
}

