/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.outputs;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.Output;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.PluginHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;

@LogstashPlugin(name="java_stdout")
public class Stdout
implements Output {
    public static final PluginConfigSpec<Codec> CODEC_CONFIG = PluginConfigSpec.codecSetting("codec", "java-line");
    private Codec codec;
    private OutputStream outputStream;
    private final CountDownLatch done = new CountDownLatch(1);
    private String id;
    private ByteBuffer encodeBuffer = ByteBuffer.wrap(new byte[16384]);

    public Stdout(String id, Configuration configuration, Context context) {
        this(id, configuration, context, System.out);
    }

    Stdout(String id, Configuration configuration, Context context, OutputStream targetStream) {
        this.id = id;
        this.outputStream = targetStream;
        this.codec = configuration.get(CODEC_CONFIG);
        if (this.codec == null) {
            throw new IllegalStateException("Unable to obtain codec");
        }
    }

    @Override
    public void output(Collection<Event> events) {
        try {
            for (Event e : events) {
                boolean encodeCompleted;
                this.encodeBuffer.clear();
                do {
                    encodeCompleted = this.codec.encode(e, this.encodeBuffer);
                    this.outputStream.write(this.encodeBuffer.array(), this.encodeBuffer.position(), this.encodeBuffer.limit());
                    this.encodeBuffer.flip();
                } while (!encodeCompleted);
            }
        }
        catch (Codec.EncodeException | IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void stop() {
        this.done.countDown();
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.done.await();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return PluginHelper.commonOutputSettings(Collections.singletonList(CODEC_CONFIG));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

