/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.TypeIntersectionScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntersectionTypeConstructor
implements TypeConstructor {
    private final LinkedHashSet<KotlinType> intersectedTypes;
    private final int hashCode;

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.intersectedTypes;
    }

    @NotNull
    public final MemberScope createScopeForKotlinType() {
        return TypeIntersectionScope.Companion.create("member scope for intersection type " + this, (Collection<? extends KotlinType>)this.intersectedTypes);
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = ((KotlinType)this.intersectedTypes.iterator().next()).getConstructor().getBuiltIns();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuiltIns, (String)"intersectedTypes.iterato\u2026xt().constructor.builtIns");
        return kotlinBuiltIns;
    }

    @NotNull
    public String toString() {
        return this.makeDebugNameForIntersectionType((Iterable<? extends KotlinType>)this.intersectedTypes);
    }

    private final String makeDebugNameForIntersectionType(Iterable<? extends KotlinType> resultingTypes) {
        return CollectionsKt.joinToString$default(resultingTypes, (CharSequence)" & ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntersectionTypeConstructor)) {
            return false;
        }
        return Intrinsics.areEqual(this.intersectedTypes, ((IntersectionTypeConstructor)other).intersectedTypes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public IntersectionTypeConstructor(@NotNull Collection<? extends KotlinType> typesToIntersect) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(typesToIntersect, (String)"typesToIntersect");
        boolean bl2 = bl = !typesToIntersect.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Attempt to create an empty intersection";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.intersectedTypes = new LinkedHashSet<KotlinType>(typesToIntersect);
        this.hashCode = this.intersectedTypes.hashCode();
    }
}

