/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.lazy.DelegationFilter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmDelegationFilter;", "Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;", "()V", "filter", "", "interfaceMember", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isBuiltInMemberMappedToJavaDefault", "isJavaDefaultMethod", "frontend.java"})
public final class JvmDelegationFilter
implements DelegationFilter {
    public static final JvmDelegationFilter INSTANCE;

    @Override
    public boolean filter(@NotNull CallableMemberDescriptor interfaceMember, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(interfaceMember, "interfaceMember");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.NoDelegationToJavaDefaultInterfaceMembers)) {
            return true;
        }
        CallableMemberDescriptor realMember = DescriptorUtils.unwrapFakeOverride(interfaceMember);
        return !this.isJavaDefaultMethod(realMember) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(realMember) && !this.isBuiltInMemberMappedToJavaDefault(realMember);
    }

    private final boolean isJavaDefaultMethod(CallableMemberDescriptor interfaceMember) {
        return interfaceMember instanceof JavaMethodDescriptor && ((JavaMethodDescriptor)interfaceMember).getModality() != Modality.ABSTRACT;
    }

    private final boolean isBuiltInMemberMappedToJavaDefault(CallableMemberDescriptor interfaceMember) {
        return interfaceMember.getModality() != Modality.ABSTRACT && KotlinBuiltIns.isBuiltIn(interfaceMember) && interfaceMember.getAnnotations().hasAnnotation(PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME());
    }

    private JvmDelegationFilter() {
    }

    static {
        JvmDelegationFilter jvmDelegationFilter;
        INSTANCE = jvmDelegationFilter = new JvmDelegationFilter();
    }
}

