/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;
import com.sparshui.server.TouchPoint;

public class TouchEvent
implements Event {
    private static final long serialVersionUID = 370824346017492361L;
    private int _id;
    private float _x;
    private float _y;
    private int _state;
    private long _time;

    public TouchEvent() {
        this._id = Integer.MAX_VALUE;
        this._x = 0.0f;
        this._y = 0.0f;
        this._state = 0;
    }

    public TouchEvent(int n, float f, float f2, int n2) {
        this._id = n;
        this._x = f;
        this._y = f2;
        this._state = n2;
        this._time = System.currentTimeMillis();
    }

    public TouchEvent(TouchPoint touchPoint) {
        this._id = touchPoint.getID();
        this._x = touchPoint.getLocation().getX();
        this._y = touchPoint.getLocation().getY();
        this._state = touchPoint.getState();
        this._time = touchPoint.getTime();
    }

    public int getTouchID() {
        return this._id;
    }

    public long getTime() {
        return this._time;
    }

    public float getX() {
        return this._x;
    }

    public float getY() {
        return this._y;
    }

    public void setX(float f) {
        this._x = f;
    }

    public void setY(float f) {
        this._y = f;
    }

    public int getState() {
        return this._state;
    }

    @Override
    public int getEventType() {
        return 3;
    }

    public TouchEvent(byte[] byArray) {
        if (byArray.length < 24) {
            System.err.println("An error occurred while deserializing a TouchEvent.");
        } else {
            this._id = Converter.byteArrayToInt(byArray, 0);
            this._x = Converter.byteArrayToFloat(byArray, 4);
            this._y = Converter.byteArrayToFloat(byArray, 8);
            this._state = Converter.byteArrayToInt(byArray, 12);
            this._time = Converter.byteArrayToLong(byArray, 16);
        }
    }

    @Override
    public byte[] serialize() {
        byte[] byArray = new byte[28];
        Converter.intToByteArray(byArray, 0, this.getEventType());
        Converter.intToByteArray(byArray, 4, this._id);
        Converter.floatToByteArray(byArray, 8, this._x);
        Converter.floatToByteArray(byArray, 12, this._y);
        Converter.intToByteArray(byArray, 16, this._state);
        Converter.longToByteArray(byArray, 20, this._time);
        return byArray;
    }

    public String toString() {
        return "Touch Event: ID: " + this._id + ", X: " + this._x + ", Y: " + this._y + "State: " + this._state;
    }
}

