/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.utils.LangLocale;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class NLS {
    private static final Vector<LangLocale> i18nLocales = new Vector();
    private static final Map<LangLocale, ResourceBundle> i18nMessagesMap = new HashMap<LangLocale, ResourceBundle>();
    private static final ResourceBundle fallbackMessagesMap;
    private static final LangLocale localLocale;
    private static ResourceBundle localizedMessagesMap;
    private static LangLocale currentLocale;

    private NLS() {
    }

    private static void load(LangLocale locale) {
        PropertyResourceBundle bundle;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        String resName = String.format("i18n/Messages_%s.properties", locale.get());
        URL bundleUrl = classLoader.getResource(resName);
        if (bundleUrl == null) {
            throw new JadxRuntimeException("Locale resource not found: " + resName);
        }
        try (InputStreamReader reader = new InputStreamReader(bundleUrl.openStream(), StandardCharsets.UTF_8);){
            bundle = new PropertyResourceBundle(reader);
        }
        catch (IOException e) {
            throw new JadxRuntimeException("Failed to load " + resName, e);
        }
        i18nMessagesMap.put(locale, bundle);
    }

    public static String str(String key) {
        try {
            return localizedMessagesMap.getString(key);
        }
        catch (MissingResourceException e) {
            return fallbackMessagesMap.getString(key);
        }
    }

    public static String str(String key, LangLocale locale) {
        ResourceBundle bundle = i18nMessagesMap.get(locale);
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return fallbackMessagesMap.getString(key);
    }

    public static void setLocale(LangLocale locale) {
        currentLocale = i18nMessagesMap.containsKey(locale) ? locale : i18nLocales.get(0);
        localizedMessagesMap = i18nMessagesMap.get(currentLocale);
    }

    public static Vector<LangLocale> getI18nLocales() {
        return i18nLocales;
    }

    public static LangLocale currentLocale() {
        return currentLocale;
    }

    public static LangLocale defaultLocale() {
        if (i18nMessagesMap.containsKey(localLocale)) {
            return localLocale;
        }
        return i18nLocales.get(0);
    }

    static {
        localLocale = new LangLocale(Locale.getDefault());
        i18nLocales.add(new LangLocale("en", "US"));
        i18nLocales.add(new LangLocale("zh", "CN"));
        i18nLocales.add(new LangLocale("es", "ES"));
        i18nLocales.forEach(NLS::load);
        LangLocale defLang = i18nLocales.get(0);
        fallbackMessagesMap = i18nMessagesMap.get(defLang);
        localizedMessagesMap = i18nMessagesMap.get(defLang);
    }
}

