#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.7.0
id: esqueleto-2.7.0-GzTnoGLjrux19lyUE0IwHW
key: esqueleto-2.7.0-GzTnoGLjrux19lyUE0IwHW
license: BSD-3-Clause
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
author: Felipe Lessa
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.
category: Database
abi: eff7389ecb4609227c3961ef66997aef
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.MySQL
    Database.Esqueleto.PostgreSQL Database.Esqueleto.SQLite
hidden-modules: Database.Esqueleto.Internal.PersistentImport
                Paths_esqueleto
import-dirs: /usr/lib/ghc-8.6.4/site-local/esqueleto-2.7.0
library-dirs: /usr/lib/ghc-8.6.4/site-local/esqueleto-2.7.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.4/esqueleto-2.7.0
hs-libraries: HSesqueleto-2.7.0-GzTnoGLjrux19lyUE0IwHW
depends:
    base-4.12.0.0 blaze-html-0.9.1.1-A8LR7w4yS96GtRVO7i7OSl
    bytestring-0.10.8.2 conduit-1.3.1.1-8MOrAYt7hu26dsIPZTK6mr
    monad-logger-0.3.30-Aex7yRDTWJO7WHRozZygjo
    persistent-2.9.1-QRAxkco2ss4yrUMa1s3Aj
    resourcet-1.2.2-6zBKJcCUqdeLbP1UFGIV0t
    tagged-0.8.6-AoE7RQX12AwJxLvAxGYxtP text-1.2.3.1 time-1.8.0.2
    transformers-0.5.6.2 unliftio-0.2.10-5CtrP9qLpzqL8L0y8iRtf0
    unordered-containers-0.2.10.0-5bnYBnE7Vkj9Kd62fWith8
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

