/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.packages;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.php.composer.api.RepositoryPackage;
import org.eclipse.php.composer.api.packages.AsyncDownloadClient;
import org.eclipse.php.composer.api.packages.DownloadListenerAdapater;
import org.eclipse.php.composer.api.packages.PackageHelper;
import org.eclipse.php.composer.api.packages.PackageListenerInterface;

public class AsyncPackageDownloader
extends AsyncDownloadClient {
    private List<PackageListenerInterface> pkgListeners = new ArrayList<PackageListenerInterface>();

    public AsyncPackageDownloader(String baseUrl) {
        super(baseUrl);
    }

    public void addPackageListener(PackageListenerInterface listener) {
        if (!this.pkgListeners.contains(listener)) {
            this.pkgListeners.add(listener);
        }
    }

    public void removePackageListener(PackageListenerInterface listener) {
        this.pkgListeners.remove(listener);
    }

    protected void notifyPackageListener(Object obj) {
        for (PackageListenerInterface listener : this.pkgListeners) {
            if (obj instanceof RepositoryPackage) {
                listener.packageLoaded((RepositoryPackage)obj);
                continue;
            }
            if (!(obj instanceof Exception)) continue;
            listener.errorOccured((Exception)obj);
        }
    }

    public int loadPackage(String packageName) {
        this.downloader.setUrl(this.createUrl(packageName));
        if (this.downloadListener == null) {
            this.downloadListener = new DownloadListenerAdapater(){

                @Override
                public void dataReceived(InputStream content, String url) {
                    try {
                        AsyncPackageDownloader.this.notifyPackageListener(PackageHelper.getPackage(content));
                    }
                    catch (Exception e) {
                        AsyncPackageDownloader.this.notifyPackageListener(e);
                    }
                }

                @Override
                public void errorOccured(Exception e) {
                    AsyncPackageDownloader.this.notifyPackageListener(e);
                }
            };
            this.downloader.addDownloadListener(this.downloadListener);
        }
        return this.downloader.download();
    }
}

