/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public final class JavaVersion {
    public static final char SEPARATOR = '.';
    public static final char PATCH_SEPARATOR = '_';
    public static final String VM_VERSION_PROPERTY = "java.specification.version";
    private static final Pattern VM_VERSION_PATTERN = Pattern.compile("[^0-9]*([0-9]+)(\\.([0-9]+))*");
    private static final int VM_MIN_VERSION_TOKENS = 1;
    private static final String VERSION_CLASS_NAME = "java.lang.Runtime$Version";
    private static final String RUNTIME_VERSION_METHOD_NAME = "version";
    private final int major;
    private final int minor;

    public static String vmVersionString() {
        return PrivilegedAccessHelper.getSystemProperty(VM_VERSION_PROPERTY);
    }

    private static Object runtimeVersionObject() {
        try {
            Method m = Runtime.class.getMethod(RUNTIME_VERSION_METHOD_NAME, new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Integer getRuntimeVersionNumber(Object vObj, String name) {
        try {
            Method m = vObj.getClass().getMethod(name, new Class[0]);
            return (Integer)m.invoke(vObj, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static JavaVersion runtimeVersion() {
        Object vObj = JavaVersion.runtimeVersionObject();
        if (vObj == null) {
            return null;
        }
        Integer major = JavaVersion.getRuntimeVersionNumber(vObj, "major");
        Integer minor = JavaVersion.getRuntimeVersionNumber(vObj, "minor");
        if (major != null && minor != null) {
            return new JavaVersion(major, minor);
        }
        return null;
    }

    private static JavaVersion propertyVersionParser(String version) {
        Matcher matcher = VM_VERSION_PATTERN.matcher(version);
        int major = 0;
        int minor = 0;
        if (matcher.find()) {
            major = Integer.parseInt(matcher.group(1));
            String min = matcher.group(3);
            minor = min != null ? Integer.parseInt(min) : 0;
        }
        return new JavaVersion(major, minor);
    }

    private static JavaVersion propertyVersion() {
        return JavaVersion.propertyVersionParser(JavaVersion.vmVersionString());
    }

    public static JavaVersion vmVersion() {
        JavaVersion version = JavaVersion.runtimeVersion();
        return version != null ? version : JavaVersion.propertyVersion();
    }

    public JavaVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int comapreTo(JavaVersion version) {
        return this.major > version.major ? 1 : (this.major < version.major ? -1 : (this.minor > version.minor ? 1 : (this.minor < version.minor ? -1 : 0)));
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(3);
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        return sb.toString();
    }

    public final JavaSEPlatform toPlatform() {
        return JavaSEPlatform.toValue(this.major, this.minor);
    }
}

