/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.ClasspathShortener;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVM;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.util.NLS;

public class StandardVMRunner
extends AbstractVMRunner {
    public static final String XSTART_ON_FIRST_THREAD = "-XstartOnFirstThread";
    protected IVMInstall fVMInstance;

    public StandardVMRunner(IVMInstall vmInstance) {
        this.fVMInstance = vmInstance;
    }

    protected String renderDebugTarget(String classToRun, int host) {
        String format = LaunchingMessages.StandardVMRunner__0__at_localhost__1__1;
        return NLS.bind((String)format, (Object[])new String[]{classToRun, String.valueOf(host)});
    }

    public static String renderProcessLabel(String[] commandLine, String timestamp) {
        String format = LaunchingMessages.StandardVMRunner__0____1___2;
        return NLS.bind((String)format, (Object[])new String[]{commandLine[0], timestamp});
    }

    protected String renderCommandLine(String[] commandLine) {
        return DebugPlugin.renderArguments((String[])commandLine, null);
    }

    protected void addArguments(String[] args, List<String> v) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            v.add(args[i]);
            ++i;
        }
    }

    protected String[] validateCommandLine(ILaunchConfiguration configuration, String[] cmdLine) {
        try {
            return this.wrap(configuration, cmdLine);
        }
        catch (CoreException ce) {
            LaunchingPlugin.log(ce);
            return cmdLine;
        }
    }

    private String[] wrap(ILaunchConfiguration config, String[] cmdLine) throws CoreException {
        if (config != null && "macosx".equals(Platform.getOS())) {
            int i = 0;
            while (i < cmdLine.length) {
                if ("-ws".equals(cmdLine[i]) || cmdLine[i].indexOf("swt.jar") > -1 || cmdLine[i].indexOf("org.eclipse.swt") > -1) {
                    return this.createSWTlauncher(cmdLine, cmdLine[0], config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_START_ON_FIRST_THREAD, true));
                }
                ++i;
            }
        }
        return cmdLine;
    }

    private String[] createSWTlauncher(String[] cmdLine, String vmVersion, boolean startonfirstthread) {
        String java_swt = System.getProperty("org.eclipse.swtlauncher");
        if (java_swt == null) {
            boolean found = false;
            ArrayList<String> args = new ArrayList<String>();
            int i = 0;
            while (i < cmdLine.length) {
                if (XSTART_ON_FIRST_THREAD.equals(cmdLine[i])) {
                    found = true;
                }
                args.add(cmdLine[i]);
                ++i;
            }
            if (!found && startonfirstthread) {
                args.add(1, XSTART_ON_FIRST_THREAD);
            }
            return args.toArray(new String[args.size()]);
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/cp", java_swt, "/tmp"});
            process.waitFor();
            java_swt = "/tmp/java_swt";
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
        String[] newCmdLine = new String[cmdLine.length + 1];
        int argCount = 0;
        newCmdLine[argCount++] = java_swt;
        newCmdLine[argCount++] = "-XXvm=" + vmVersion;
        int i = 1;
        while (i < cmdLine.length) {
            newCmdLine[argCount++] = cmdLine[i];
            ++i;
        }
        return newCmdLine;
    }

    protected File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        String path = config.getWorkingDirectory();
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort(NLS.bind((String)LaunchingMessages.StandardVMRunner_Specified_working_directory_does_not_exist_or_is_not_a_directory___0__3, (Object[])new String[]{path}), null, 108);
        }
        return dir;
    }

    @Override
    protected String getPluginIdentifier() {
        return LaunchingPlugin.getUniqueIdentifier();
    }

    protected String constructProgramString(VMRunnerConfiguration config) throws CoreException {
        String installLocation;
        File exe;
        String command = null;
        Map<String, Object> map = config.getVMSpecificAttributesMap();
        if (map != null) {
            command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
        }
        if (command == null) {
            File exe2 = null;
            exe2 = this.fVMInstance instanceof StandardVM ? ((StandardVM)this.fVMInstance).getJavaExecutable() : StandardVMType.findJavaExecutable(this.fVMInstance.getInstallLocation());
            if (exe2 == null) {
                this.abort(NLS.bind((String)LaunchingMessages.StandardVMRunner_Unable_to_locate_executable_for__0__1, (Object[])new String[]{this.fVMInstance.getName()}), null, 150);
            } else {
                return exe2.getAbsolutePath();
            }
        }
        if (this.fileExists(exe = new File(String.valueOf(installLocation = String.valueOf(this.fVMInstance.getInstallLocation().getAbsolutePath()) + File.separatorChar) + "bin" + File.separatorChar + command))) {
            return exe.getAbsolutePath();
        }
        if (this.fileExists(exe = new File(String.valueOf(exe.getAbsolutePath()) + ".exe"))) {
            return exe.getAbsolutePath();
        }
        exe = new File(String.valueOf(installLocation) + "jre" + File.separatorChar + "bin" + File.separatorChar + command);
        if (this.fileExists(exe)) {
            return exe.getAbsolutePath();
        }
        if (this.fileExists(exe = new File(String.valueOf(exe.getAbsolutePath()) + ".exe"))) {
            return exe.getAbsolutePath();
        }
        this.abort(NLS.bind((String)LaunchingMessages.StandardVMRunner_Specified_executable__0__does_not_exist_for__1__4, (Object[])new String[]{command, this.fVMInstance.getName()}), null, 150);
        return null;
    }

    protected boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    protected String convertClassPath(String[] cp) {
        int pathCount = 0;
        StringBuilder buf = new StringBuilder();
        if (cp.length == 0) {
            return "";
        }
        int i = 0;
        while (i < cp.length) {
            if (pathCount > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(cp[i]);
            ++pathCount;
            ++i;
        }
        return buf.toString();
    }

    protected String[] ensureEncoding(ILaunch launch, String[] vmargs) {
        boolean foundencoding = false;
        int i = 0;
        while (i < vmargs.length) {
            if (vmargs[i].startsWith("-Dfile.encoding=")) {
                foundencoding = true;
            }
            ++i;
        }
        if (!foundencoding) {
            String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
            if (encoding == null) {
                return vmargs;
            }
            String[] newargs = new String[vmargs.length + 1];
            System.arraycopy(vmargs, 0, newargs, 0, vmargs.length);
            newargs[newargs.length - 1] = "-Dfile.encoding=" + encoding;
            return newargs;
        }
        return vmargs;
    }

    @Override
    public String showCommandLine(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        CommandDetails cmd = this.getCommandLine(configuration, launch, monitor);
        if (monitor.isCanceled() || cmd == null) {
            return "";
        }
        String[] cmdLine = cmd.getCommandLine();
        cmdLine = StandardVMRunner.quoteWindowsArgs(cmdLine);
        return this.getCmdLineAsString(cmdLine);
    }

    private CommandDetails getCommandLine(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] newCmdLine;
        String dependencies;
        String[] cp;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Constructing_command_line____2);
        String program = this.constructProgramString(config);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program);
        String[] allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(this.ensureEncoding(launch, allVMArgs), arguments);
        this.addBootClassPathArguments(arguments, config);
        String[] mp = config.getModulepath();
        if (mp != null && mp.length > 0) {
            arguments.add("-p");
            arguments.add(this.convertClassPath(mp));
        }
        if ((cp = config.getClassPath()).length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        if ((dependencies = config.getOverrideDependencies()) != null && dependencies.length() > 0) {
            String[] parseArguments;
            String[] stringArray = parseArguments = DebugPlugin.parseArguments((String)dependencies);
            int n = parseArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                arguments.add(string);
                ++n2;
            }
        }
        if (this.isModular(config, this.fVMInstance)) {
            arguments.add("-m");
            arguments.add(String.valueOf(config.getModuleDescription()) + "/" + config.getClassToLaunch());
        } else {
            arguments.add(config.getClassToLaunch());
        }
        int lastVMArgumentIndex = arguments.size() - 1;
        String[] programArgs = config.getProgramArguments();
        this.addArguments(programArgs, arguments);
        String[] envp = this.prependJREPath(config.getEnvironment());
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        File workingDir = this.getWorkingDir(config);
        ClasspathShortener classpathShortener = new ClasspathShortener(this.fVMInstance, launch, cmdLine, lastVMArgumentIndex, workingDir, envp);
        if (classpathShortener.shortenCommandLineIfNecessary()) {
            cmdLine = classpathShortener.getCmdLine();
            envp = classpathShortener.getEnvp();
        }
        if ((newCmdLine = this.validateCommandLine(launch.getLaunchConfiguration(), cmdLine)) != null) {
            cmdLine = newCmdLine;
        }
        CommandDetails cmd = new CommandDetails();
        cmd.setCommandLine(cmdLine);
        cmd.setEnvp(envp);
        cmd.setWorkingDir(workingDir);
        cmd.setClasspathShortener(classpathShortener);
        subMonitor.worked(1);
        return cmd;
    }

    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CommandDetails cmdDetails = this.getCommandLine(config, launch, monitor);
        if (monitor.isCanceled() || cmdDetails == null) {
            return;
        }
        String[] cmdLine = cmdDetails.getCommandLine();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.beginTask(LaunchingMessages.StandardVMRunner_Launching_VM____1, 2);
        subMonitor.subTask(LaunchingMessages.StandardVMRunner_Starting_virtual_machine____3);
        Process p = null;
        p = this.exec(cmdLine, cmdDetails.getWorkingDir(), cmdDetails.getEnvp());
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        String timestamp = DateFormat.getDateTimeInstance((int)2, (int)2).format(new Date(System.currentTimeMillis()));
        IProcess process = this.newProcess(launch, p, StandardVMRunner.renderProcessLabel(cmdLine, timestamp), this.getDefaultProcessMap());
        process.setAttribute("org.eclipse.debug.core.ATTR_PATH", cmdLine[0]);
        process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
        String ltime = launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        process.setAttribute("org.eclipse.debug.core.launch.timestamp", ltime != null ? ltime : timestamp);
        if (cmdDetails.getWorkingDir() != null) {
            process.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", cmdDetails.getWorkingDir().getAbsolutePath());
        }
        if (cmdDetails.getEnvp() != null) {
            Object[] envp = cmdDetails.getEnvp();
            Arrays.sort(envp);
            StringBuilder buff = new StringBuilder();
            int i = 0;
            while (i < envp.length) {
                buff.append((String)envp[i]);
                if (i < envp.length - 1) {
                    buff.append('\n');
                }
                ++i;
            }
            process.setAttribute("org.eclipse.debug.core.ATTR_ENVIRONMENT", buff.toString());
        }
        if (!cmdDetails.getClasspathShortener().getProcessTempFiles().isEmpty()) {
            String tempFiles = cmdDetails.getClasspathShortener().getProcessTempFiles().stream().map(file -> file.getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
            process.setAttribute("tempFiles", tempFiles);
        }
        subMonitor.worked(1);
        subMonitor.done();
    }

    int getCPIndex(String[] env) {
        if (env != null) {
            int i = 0;
            while (i < env.length) {
                if (env[i].regionMatches(true, 0, "CLASSPATH=", 0, 10)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected String[] prependJREPath(String[] env) {
        IVMInstall2 vm;
        String javaVersion;
        if ("macosx".equals(Platform.getOS()) && this.fVMInstance instanceof IVMInstall2 && (javaVersion = (vm = (IVMInstall2)((Object)this.fVMInstance)).getJavaVersion()) != null) {
            if (env == null) {
                Map map = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
                if (map.containsKey("JAVA_JVM_VERSION")) {
                    String[] env2 = new String[map.size()];
                    Iterator iterator = map.entrySet().iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String key = (String)entry.getKey();
                        env2[i] = "JAVA_JVM_VERSION".equals(key) ? String.valueOf(key) + "=" + javaVersion : String.valueOf(key) + "=" + (String)entry.getValue();
                        ++i;
                    }
                    env = env2;
                }
            } else {
                int i = 0;
                while (i < env.length) {
                    String string = env[i];
                    if (string.startsWith("JAVA_JVM_VERSION")) {
                        env[i] = "JAVA_JVM_VERSION=" + javaVersion;
                        break;
                    }
                    ++i;
                }
            }
        }
        return env;
    }

    protected void addBootClassPathArguments(List<String> arguments, VMRunnerConfiguration config) {
        String[] prependBootCP = null;
        String[] bootCP = null;
        String[] appendBootCP = null;
        Map<String, Object> map = config.getVMSpecificAttributesMap();
        if (map != null) {
            prependBootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND);
            bootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH);
            if (JavaRuntime.isModularJava(this.fVMInstance)) {
                if (prependBootCP != null && prependBootCP.length > 0) {
                    prependBootCP = null;
                    LaunchingPlugin.log(LaunchingMessages.RunnerBootpathPError);
                }
                if (bootCP != null && bootCP.length > 0) {
                    bootCP = null;
                    LaunchingPlugin.log(LaunchingMessages.RunnerBootpathError);
                }
            }
            appendBootCP = (String[])map.get(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_APPEND);
        }
        if (!JavaRuntime.isModularJava(this.fVMInstance) && prependBootCP == null && bootCP == null && appendBootCP == null) {
            bootCP = config.getBootClassPath();
        }
        if (prependBootCP != null) {
            arguments.add("-Xbootclasspath/p:" + this.convertClassPath(prependBootCP));
        }
        if (bootCP != null && bootCP.length > 0) {
            arguments.add("-Xbootclasspath:" + this.convertClassPath(bootCP));
        }
        if (appendBootCP != null) {
            arguments.add("-Xbootclasspath/a:" + this.convertClassPath(appendBootCP));
        }
    }

    protected class CommandDetails {
        private String[] commandLine;
        private String[] envp;
        private File workingDir;
        private ClasspathShortener classpathShortener;
        private int port;

        protected CommandDetails() {
        }

        public String[] getEnvp() {
            return this.envp;
        }

        public void setEnvp(String[] envp) {
            this.envp = envp;
        }

        public String[] getCommandLine() {
            return this.commandLine;
        }

        public void setCommandLine(String[] commandLine) {
            this.commandLine = commandLine;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir = workingDir;
        }

        public ClasspathShortener getClasspathShortener() {
            return this.classpathShortener;
        }

        public void setClasspathShortener(ClasspathShortener classpathShortener) {
            this.classpathShortener = classpathShortener;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

