/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2SchemaManager
extends SQLObjectEditor<DB2Schema, DB2DataSource> {
    private static final String SQL_CREATE_SCHEMA = "CREATE SCHEMA %s";
    private static final String SQL_DROP_SCHEMA = "DROP SCHEMA %s RESTRICT";

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2Schema> getObjectsCache(DB2Schema object) {
        return object.getDataSource().getSchemaCache();
    }

    protected DB2Schema createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final DB2DataSource parent, Object copyFrom) {
        return (DB2Schema)new UITask<DB2Schema>(){

            protected DB2Schema runTask() {
                NewSchemaDialog dialog = new NewSchemaDialog(UIUtils.getActiveWorkbenchShell());
                if (dialog.open() != 0) {
                    return null;
                }
                String schemaName = dialog.getSchemaName();
                if (schemaName.length() == 0) {
                    return null;
                }
                return new DB2Schema(parent, schemaName);
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        SQLDatabasePersistAction action = new SQLDatabasePersistAction("Create schema", String.format(SQL_CREATE_SCHEMA, DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
        actions.add((DBEPersistAction)action);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String schemaName = ((DB2Schema)command.getObject()).getName();
        SQLDatabasePersistAction action = new SQLDatabasePersistAction("Drop schema (SQL)", String.format(SQL_DROP_SCHEMA, DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
        actions.add((DBEPersistAction)action);
    }

    private static class NewSchemaDialog
    extends Dialog {
        private String schemaName;
        private Text nameText;

        public String getSchemaName() {
            return this.schemaName;
        }

        public NewSchemaDialog(Shell parentShell) {
            super(parentShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("New Schema Name");
            Control container = super.createDialogArea(parent);
            Composite composite = UIUtils.createPlaceholder((Composite)((Composite)container), (int)2);
            composite.setLayoutData((Object)new GridData(1808));
            this.nameText = UIUtils.createLabelText((Composite)composite, (String)"Schema Name", null);
            this.nameText.setLayoutData((Object)new GridData(768));
            return parent;
        }

        protected void okPressed() {
            this.schemaName = this.nameText.getText().trim().toUpperCase();
            super.okPressed();
        }
    }
}

