/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.MySQLIndexHint;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.MultiPartName;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.IntoTableVisitor;
import net.sf.jsqlparser.statement.select.Pivot;

public class Table
extends ASTNodeAccessImpl
implements FromItem,
MultiPartName {
    private Database database;
    private String schemaName;
    private String name;
    private Alias alias;
    private Pivot pivot;
    private MySQLIndexHint hint;

    public Table() {
    }

    public Table(String name) {
        this.name = name;
    }

    public Table(String schemaName, String name) {
        this.schemaName = schemaName;
        this.name = name;
    }

    public Table(Database database, String schemaName, String name) {
        this.database = database;
        this.schemaName = schemaName;
        this.name = name;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public String getFullyQualifiedName() {
        String fqn = "";
        if (this.database != null) {
            fqn = fqn + this.database.getFullyQualifiedName();
        }
        if (!fqn.isEmpty()) {
            fqn = fqn + ".";
        }
        if (this.schemaName != null) {
            fqn = fqn + this.schemaName;
        }
        if (!fqn.isEmpty()) {
            fqn = fqn + ".";
        }
        if (this.name != null) {
            fqn = fqn + this.name;
        }
        return fqn;
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public void accept(IntoTableVisitor intoTableVisitor) {
        intoTableVisitor.visit(this);
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    public MySQLIndexHint getIndexHint() {
        return this.hint;
    }

    public void setHint(MySQLIndexHint hint) {
        this.hint = hint;
    }

    public String toString() {
        return this.getFullyQualifiedName() + (this.alias != null ? this.alias.toString() : "") + (this.pivot != null ? " " + this.pivot : "") + (this.hint != null ? this.hint.toString() : "");
    }
}

