/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;

public class FireBirdSQLDialect
extends GenericSQLDialect {
    public static final String[] FB_BLOCK_HEADERS = new String[]{"EXECUTE BLOCK", "DECLARE"};
    public static final String[][] FB_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}};
    private static final String[] DDL_KEYWORDS = new String[]{"CREATE", "ALTER", "DROP", "EXECUTE"};

    public FireBirdSQLDialect() {
        super("FireBird");
    }

    public String[] getDDLKeywords() {
        return DDL_KEYWORDS;
    }

    public String[] getBlockHeaderStrings() {
        return FB_BLOCK_HEADERS;
    }

    public String[][] getBlockBoundStrings() {
        return FB_BEGIN_END_BLOCK;
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
    }

    public boolean validIdentifierPart(char c) {
        return super.validIdentifierPart(c) || c == '$';
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        return "select * from " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
    }
}

