/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftExternalSchema;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftExternalTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;

public class RedshiftExternalTable
extends JDBCTable<PostgreDataSource, RedshiftExternalSchema>
implements DBPRefreshableObject {
    private static final Log log = Log.getLog(RedshiftExternalTable.class);
    private String location;
    private String inputFormat;
    private String outputFormat;
    private String serializationLib;
    private String serdeParameters;
    private int compressed;
    private String parameters;

    protected RedshiftExternalTable(RedshiftExternalSchema catalog) {
        super((DBSObjectContainer)catalog, false);
    }

    protected RedshiftExternalTable(RedshiftExternalSchema catalog, ResultSet dbResult) {
        super((DBSObjectContainer)catalog, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tablename"), true);
        this.location = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"location");
        this.inputFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"input_format");
        this.outputFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"output_format");
        this.serializationLib = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"serialization_lib");
        this.serdeParameters = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"serde_parameters");
        this.compressed = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"compressed");
        this.parameters = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"parameters");
    }

    public RedshiftExternalTable(RedshiftExternalSchema container, DBSEntity source, boolean persisted) {
        super((DBSObjectContainer)container, source, persisted);
        if (source instanceof RedshiftExternalTable) {
            RedshiftExternalTable rsSource = (RedshiftExternalTable)source;
            this.location = rsSource.location;
            this.inputFormat = rsSource.inputFormat;
            this.outputFormat = rsSource.outputFormat;
            this.serializationLib = rsSource.serializationLib;
            this.serdeParameters = rsSource.serdeParameters;
            this.compressed = rsSource.compressed;
            this.parameters = rsSource.parameters;
        }
    }

    public JDBCStructCache<RedshiftExternalSchema, ? extends RedshiftExternalTable, ? extends RedshiftExternalTableColumn> getCache() {
        return ((RedshiftExternalSchema)this.getContainer()).externalTableCache;
    }

    @Property(viewable=true, order=10)
    public String getLocation() {
        return this.location;
    }

    @Property(viewable=true, order=11)
    public String getInputFormat() {
        return this.inputFormat;
    }

    @Property(viewable=true, order=12)
    public String getOutputFormat() {
        return this.outputFormat;
    }

    @Property(viewable=false, order=13)
    public String getSerializationLib() {
        return this.serializationLib;
    }

    @Property(viewable=false, order=14)
    public String getSerdeParameters() {
        return this.serdeParameters;
    }

    @Property(viewable=false, order=15)
    public int getCompressed() {
        return this.compressed;
    }

    @Property(viewable=false, order=16)
    public String getParameters() {
        return this.parameters;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @NotNull
    public RedshiftExternalSchema getSchema() {
        return (RedshiftExternalSchema)super.getContainer();
    }

    public List<RedshiftExternalTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((RedshiftExternalSchema)this.getContainer()).externalTableCache.getChildren(monitor, (RedshiftExternalSchema)this.getContainer(), (DBSObject)this);
    }

    public List<RedshiftExternalTableColumn> getCachedAttributes() {
        DBSObjectCache childrenCache = ((RedshiftExternalSchema)this.getContainer()).externalTableCache.getChildrenCache((DBSObject)this);
        if (childrenCache != null) {
            return childrenCache.getCachedObjects();
        }
        return Collections.emptyList();
    }

    public RedshiftExternalTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (RedshiftExternalTableColumn)((RedshiftExternalSchema)this.getContainer()).externalTableCache.getChild(monitor, (RedshiftExternalSchema)this.getContainer(), (DBSObject)this, attributeName);
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<PostgreTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public PostgreTableConstraintBase getConstraint(@NotNull DBRProgressMonitor monitor, String ukName) throws DBException {
        return null;
    }

    @Association
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Association
    public synchronized Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((RedshiftExternalSchema)this.getContainer()).externalTableCache.refreshObject(monitor, (RedshiftExternalSchema)this.getContainer(), (DBSObject)this);
    }
}

