/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.SimpleObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTable
extends PostgreTableReal
implements DBDPseudoAttributeContainer {
    private static final Log log = Log.getLog(PostgreTable.class);
    private SimpleObjectCache<PostgreTable, PostgreTableForeignKey> foreignKeys = new SimpleObjectCache();
    private boolean hasOids;
    private long tablespaceId;
    private List<PostgreTableInheritance> superTables;
    private List<PostgreTableInheritance> subTables;
    private boolean hasSubClasses;

    public PostgreTable(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreTable(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
        this.hasOids = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relhasoids");
        this.tablespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"reltablespace");
        this.hasSubClasses = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relhassubclass");
    }

    public PostgreTable(PostgreSchema container, DBSEntity source, boolean persisted) {
        super(container, source, persisted);
        if (source instanceof PostgreTable) {
            this.hasOids = ((PostgreTable)source).hasOids;
        }
    }

    public SimpleObjectCache<PostgreTable, PostgreTableForeignKey> getForeignKeyCache() {
        return this.foreignKeys;
    }

    public boolean isTablespaceSpecified() {
        return this.tablespaceId != 0L;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=PostgreTableBase.TablespaceListProvider.class)
    public PostgreTablespace getTablespace(DBRProgressMonitor monitor) throws DBException {
        if (this.tablespaceId == 0L) {
            return this.getDatabase().getDefaultTablespace(monitor);
        }
        return (PostgreTablespace)PostgreUtils.getObjectById(monitor, this.getDatabase().tablespaceCache, this.getDatabase(), this.tablespaceId);
    }

    public void setTablespace(PostgreTablespace tablespace) {
        this.tablespaceId = tablespace.getObjectId();
    }

    public boolean isView() {
        return false;
    }

    @Property(viewable=false, editable=true, updatable=true, order=40)
    public boolean isHasOids() {
        return this.hasOids;
    }

    public void setHasOids(boolean hasOids) {
        this.hasOids = hasOids;
    }

    public Collection<PostgreIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().indexCache.getObjects(monitor, this.getSchema(), this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return JDBCUtils.generateTableDDL((DBRProgressMonitor)monitor, (JDBCTable)this, options, (boolean)false);
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        if (this.hasOids && ((PostgreDataSource)this.getDataSource()).getServerType().supportsOids()) {
            return new DBDPseudoAttribute[]{PostgreConstants.PSEUDO_ATTR_OID};
        }
        return null;
    }

    @Override
    @Association
    public synchronized Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> superTables = this.getSuperInheritance(monitor);
        Collection<PostgreTableForeignKey> foreignKeys = this.getForeignKeys(monitor);
        if (CommonUtils.isEmpty(superTables)) {
            return foreignKeys;
        }
        if (CommonUtils.isEmpty(foreignKeys)) {
            return superTables;
        }
        ArrayList<PostgreTableConstraintBase> agg = new ArrayList<PostgreTableConstraintBase>(superTables.size() + foreignKeys.size());
        agg.addAll(superTables);
        agg.addAll(foreignKeys);
        return agg;
    }

    @Override
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<PostgreTableForeignKey> refs = new ArrayList<PostgreTableForeignKey>();
        refs.addAll(CommonUtils.safeList(this.getSubInheritance(monitor)));
        Collection allForeignKeys = ((PostgreSchema)this.getContainer()).constraintCache.getTypedObjects(monitor, (PostgreSchema)this.getContainer(), PostgreTableForeignKey.class);
        for (PostgreTableForeignKey constraint : allForeignKeys) {
            if (constraint.getAssociatedEntity() != this) continue;
            refs.add(constraint);
        }
        return refs;
    }

    public Collection<PostgreTableForeignKey> getForeignKeys(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().constraintCache.getTypedObjects(monitor, this.getSchema(), this, PostgreTableForeignKey.class);
    }

    @Property(viewable=false, optional=true, order=30)
    @Nullable
    public List<PostgreTableBase> getSuperTables(DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> si = this.getSuperInheritance(monitor);
        if (CommonUtils.isEmpty(si)) {
            return null;
        }
        ArrayList<PostgreTableBase> result = new ArrayList<PostgreTableBase>(si.size());
        int i1 = 0;
        while (i1 < si.size()) {
            result.add(si.get(i1).getAssociatedEntity());
            ++i1;
        }
        return result;
    }

    @Property(viewable=false, optional=true, order=31)
    @Nullable
    public List<PostgreTableBase> getSubTables(DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> si = this.getSubInheritance(monitor);
        if (CommonUtils.isEmpty(si)) {
            return null;
        }
        ArrayList<PostgreTableBase> result = new ArrayList<PostgreTableBase>(si.size());
        int i1 = 0;
        while (i1 < si.size()) {
            PostgreTableBase table = (PostgreTableBase)si.get(i1).getParentObject();
            if (!table.isPartition()) {
                result.add(table);
            }
            ++i1;
        }
        return result;
    }

    @NotNull
    public List<PostgreTableInheritance> getSuperInheritance(DBRProgressMonitor monitor) throws DBException {
        if (this.superTables == null && ((PostgreDataSource)this.getDataSource()).getServerType().supportsInheritance()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table inheritance info");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT i.*,c.relnamespace FROM pg_catalog.pg_inherits i,pg_catalog.pg_class c WHERE i.inhrelid=? AND c.oid=i.inhparent ORDER BY i.inhseqno");){
                        dbStat.setLong(1, this.getObjectId());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                long parentSchemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                                long parentTableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"inhparent");
                                PostgreSchema schema = this.getDatabase().getSchema(monitor, parentSchemaId);
                                if (schema == null) {
                                    log.warn((Object)("Can't find parent table's schema '" + parentSchemaId + "'"));
                                    continue;
                                }
                                PostgreTableBase parentTable = schema.getTable(monitor, parentTableId);
                                if (parentTable == null) {
                                    log.warn((Object)("Can't find parent table '" + parentTableId + "' in '" + schema.getName() + "'"));
                                    continue;
                                }
                                if (this.superTables == null) {
                                    this.superTables = new ArrayList<PostgreTableInheritance>();
                                }
                                this.superTables.add(new PostgreTableInheritance((PostgreTableBase)this, parentTable, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"inhseqno"), true));
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, this.getDataSource());
            }
            if (this.superTables == null) {
                this.superTables = Collections.emptyList();
            }
        }
        return this.superTables == null || this.superTables.isEmpty() ? null : this.superTables;
    }

    public boolean hasSubClasses() {
        return this.hasSubClasses;
    }

    @NotNull
    public List<PostgreTableInheritance> getSubInheritance(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.subTables == null && this.hasSubClasses && ((PostgreDataSource)this.getDataSource()).getServerType().supportsInheritance()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table inheritance info");){
                    String sql = "SELECT i.*,c.relnamespace FROM pg_catalog.pg_inherits i,pg_catalog.pg_class c WHERE i.inhparent=? AND c.oid=i.inhrelid";
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                        dbStat.setLong(1, this.getObjectId());
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                long subSchemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                                long subTableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"inhrelid");
                                PostgreSchema schema = this.getDatabase().getSchema(monitor, subSchemaId);
                                if (schema == null) {
                                    log.warn((Object)("Can't find sub-table's schema '" + subSchemaId + "'"));
                                    continue;
                                }
                                PostgreTableBase subTable = schema.getTable(monitor, subTableId);
                                if (subTable == null) {
                                    log.warn((Object)("Can't find sub-table '" + subTableId + "' in '" + schema.getName() + "'"));
                                    continue;
                                }
                                if (this.subTables == null) {
                                    this.subTables = new ArrayList<PostgreTableInheritance>();
                                }
                                this.subTables.add(new PostgreTableInheritance(subTable, this, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"inhseqno"), true));
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, this.getDataSource());
            }
            if (this.subTables == null) {
                this.subTables = Collections.emptyList();
            }
            DBUtils.orderObjects(this.subTables);
        }
        return this.subTables == null || this.subTables.isEmpty() ? null : this.subTables;
    }

    @Nullable
    @Association
    public Collection<PostgreTableBase> getPartitions(DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableInheritance> si = this.getSubInheritance(monitor);
        if (CommonUtils.isEmpty(si)) {
            return null;
        }
        ArrayList<PostgreTableBase> result = new ArrayList<PostgreTableBase>(si.size());
        int i1 = 0;
        while (i1 < si.size()) {
            PostgreTableBase table = (PostgreTableBase)si.get(i1).getParentObject();
            if (table.isPartition()) {
                result.add(table);
            }
            ++i1;
        }
        return result;
    }
}

