/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import org.jkiss.dbeaver.ext.greenplum.model.GreenplumTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;

public class GreenplumWithClauseBuilder {
    public static String generateWithClause(PostgreTableRegular table, PostgreTableBase tableBase) {
        StringBuilder withClauseBuilder = new StringBuilder();
        if (GreenplumWithClauseBuilder.tableSupportsAndHasOids(table) && GreenplumWithClauseBuilder.tableIsGreenPlumWithRelOptions(table, tableBase)) {
            withClauseBuilder.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
            withClauseBuilder.append(String.format(", %s\n)", String.join((CharSequence)", ", tableBase.getRelOptions())));
        } else if (GreenplumWithClauseBuilder.tableSupportsAndHasOids(table)) {
            withClauseBuilder.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
            withClauseBuilder.append("\n)");
        } else if (GreenplumWithClauseBuilder.tableIsGreenPlumWithRelOptions(table, tableBase)) {
            withClauseBuilder.append(String.format("\nWITH (\n\t%s\n)", String.join((CharSequence)", ", tableBase.getRelOptions())));
        }
        return withClauseBuilder.toString();
    }

    private static boolean tableSupportsAndHasOids(PostgreTableRegular table) {
        return ((PostgreDataSource)table.getDataSource()).getServerType().supportsOids() && table.isHasOids();
    }

    private static boolean tableIsGreenPlumWithRelOptions(PostgreTableRegular table, PostgreTableBase tableBase) {
        return table instanceof GreenplumTable && tableBase.getRelOptions() != null;
    }
}

