/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class GreenplumExternalTable
extends PostgreTableRegular {
    private final List<String> uriLocations;
    private final String execLocation;
    private final FormatType formatType;
    private final String formatOptions;
    private final String encoding;
    private final RejectLimitType rejectLimitType;
    private final int rejectLimit;

    public GreenplumExternalTable(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
        this.uriLocations = Arrays.asList(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"urilocation").trim().split(","));
        this.execLocation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"execlocation");
        this.formatType = FormatType.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"fmttype"));
        this.formatOptions = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"fmtopts");
        this.encoding = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"encoding");
        this.rejectLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"rejectlimit");
        String rejectlimittype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rejectlimittype");
        this.rejectLimitType = rejectlimittype != null && rejectlimittype.length() > 0 ? RejectLimitType.valueOf(rejectlimittype) : null;
    }

    public List<String> getUriLocations() {
        return this.uriLocations;
    }

    public String getExecLocation() {
        return this.execLocation;
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public String getFormatOptions() {
        return this.formatOptions;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public RejectLimitType getRejectLimitType() {
        return this.rejectLimitType;
    }

    public int getRejectLimit() {
        return this.rejectLimit;
    }

    public String generateDDL(DBRProgressMonitor monitor) throws DBException {
        StringBuilder ddlBuilder = new StringBuilder();
        ddlBuilder.append("CREATE EXTERNAL ").append(this.webUriLocationExists() ? "WEB " : "").append("TABLE ").append(this.getDatabase().getName()).append(".").append(this.getSchema().getName()).append(".").append(this.getName()).append(" (\n");
        List tableColumns = this.getAttributes(monitor).stream().filter(field -> field.getOrdinalPosition() >= 0).collect(Collectors.toList());
        if (tableColumns.size() == 1) {
            PostgreTableColumn column = (PostgreTableColumn)tableColumns.get(0);
            ddlBuilder.append("\t" + column.getName() + " " + column.getTypeName() + "\n)\n");
        } else {
            ddlBuilder.append(tableColumns.stream().map(field -> "\t" + field.getName() + " " + field.getTypeName()).collect(Collectors.joining(",\n")));
            ddlBuilder.append("\n)\n");
        }
        if (this.getUriLocations() != null && !this.getUriLocations().isEmpty()) {
            ddlBuilder.append("LOCATION (\n");
            ddlBuilder.append(this.getUriLocations().stream().map(location -> "\t'" + location + "'").collect(Collectors.joining(",\n")));
            ddlBuilder.append("\n) " + this.determineExecutionLocation() + "\n");
        }
        ddlBuilder.append("FORMAT '" + this.getFormatType().getValue() + "' ( " + this.generateFormatOptions(this.getFormatType(), this.getFormatOptions()) + " )");
        if (this.getEncoding() != null && this.getEncoding().length() > 0) {
            ddlBuilder.append("\nENCODING '" + this.getEncoding() + "'");
        }
        if (this.getRejectLimit() > 0 && this.getRejectLimitType() != null) {
            ddlBuilder.append("\nSEGMENT REJECT LIMIT " + this.getRejectLimit() + " " + this.getRejectLimitType().getValue());
        }
        return ddlBuilder.toString();
    }

    private boolean webUriLocationExists() {
        return this.uriLocations.stream().anyMatch(location -> location.startsWith("http"));
    }

    private String generateFormatOptions(FormatType formatType, String formatOptions) {
        if (formatType.equals((Object)FormatType.b)) {
            String[] formatSpecTokens = formatOptions.split(" ");
            String formatterSpec = formatSpecTokens.length >= 2 ? formatSpecTokens[1] : "";
            return "FORMATTER=" + formatterSpec;
        }
        return formatOptions;
    }

    private String determineExecutionLocation() {
        if (this.getExecLocation() != null && this.getExecLocation().equalsIgnoreCase("MASTER_ONLY")) {
            return "ON MASTER";
        }
        return "ON ALL";
    }

    public static enum FormatType {
        c("CSV"),
        t("TEXT"),
        b("CUSTOM");

        private String formatType;

        private FormatType(String formatTypeString) {
            this.formatType = formatTypeString;
        }

        public String getValue() {
            return this.formatType;
        }
    }

    public static enum RejectLimitType {
        r("ROWS");

        private String rejectLimitType;

        private RejectLimitType(String rejectLimitTypeString) {
            this.rejectLimitType = rejectLimitTypeString;
        }

        public String getValue() {
            return this.rejectLimitType;
        }
    }
}

