/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.resource;

import java.nio.file.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.resource.WorkspaceResourceResolver;
import org.jkiss.dbeaver.runtime.resource.links.CreateLinkedFilesRunnable;
import org.jkiss.dbeaver.runtime.resource.links.CreateLinkedFoldersRunnable;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class WorkspaceResources {
    public static IStatus createLinkedFiles(IContainer container, IProgressMonitor monitor, Path ... paths) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        CreateLinkedFilesRunnable action = new CreateLinkedFilesRunnable(container, paths);
        try {
            workspace.run((ICoreRunnable)action, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Throwable e) {
            return GeneralUtils.makeErrorStatus(action.composeErrorMessage((IResource)container, paths), e);
        }
        return Status.OK_STATUS;
    }

    public static IStatus createLinkedFolders(IContainer container, IProgressMonitor monitor, Path ... paths) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        CreateLinkedFoldersRunnable action = new CreateLinkedFoldersRunnable(container, paths);
        try {
            workspace.run((ICoreRunnable)action, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Throwable e) {
            return GeneralUtils.makeErrorStatus(action.composeErrorMessage((IResource)container, paths), e);
        }
        return Status.OK_STATUS;
    }

    public static IResource resolveWorkspaceResource(DBSObject dbsObject) {
        WorkspaceResourceResolver resolver = (WorkspaceResourceResolver)Adapters.adapt((Object)dbsObject, WorkspaceResourceResolver.class, (boolean)true);
        if (resolver != null) {
            return resolver.resolveResource(dbsObject);
        }
        return null;
    }
}

