/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.edit;

import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;

public class SQLDatabasePersistActionAtomic
extends SQLDatabasePersistAction {
    private boolean wasTransactional = false;

    public SQLDatabasePersistActionAtomic(String title, String script) {
        super(title, script);
    }

    public SQLDatabasePersistActionAtomic(String title, String script, boolean complex) {
        super(title, script, complex);
    }

    public SQLDatabasePersistActionAtomic(String title, String script, DBEPersistAction.ActionType type) {
        super(title, script, type);
    }

    public SQLDatabasePersistActionAtomic(String title, String script, DBEPersistAction.ActionType type, boolean complex) {
        super(title, script, type, complex);
    }

    public SQLDatabasePersistActionAtomic(String script) {
        super(script);
    }

    @Override
    public void beforeExecute(DBCSession session) throws DBCException {
        super.beforeExecute(session);
        DBCTransactionManager txnManager = DBUtils.getTransactionManager(session.getExecutionContext());
        if (!txnManager.isAutoCommit()) {
            txnManager.setAutoCommit(session.getProgressMonitor(), true);
            this.wasTransactional = true;
        }
    }

    @Override
    public void afterExecute(DBCSession session, Throwable error) throws DBCException {
        super.afterExecute(session, error);
        if (this.wasTransactional) {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager(session.getExecutionContext());
            txnManager.setAutoCommit(session.getProgressMonitor(), false);
        }
    }
}

