/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageDriver;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageGeneral;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageNetwork;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;

public class NewConnectionWizard
extends ConnectionWizard {
    private IStructuredSelection selection;
    private List<DataSourceProviderDescriptor> availableProvides = new ArrayList<DataSourceProviderDescriptor>();
    private ConnectionPageDriver pageDrivers;
    private Map<DataSourceProviderDescriptor, ConnectionPageSettings> settingsPages = new HashMap<DataSourceProviderDescriptor, ConnectionPageSettings>();
    private ConnectionPageGeneral pageGeneral;
    private ConnectionPageNetwork pageNetwork;

    public NewConnectionWizard() {
        this.setWindowTitle(CoreMessages.dialog_new_connection_wizard_title);
    }

    @Override
    public DBPDataSourceRegistry getDataSourceRegistry() {
        return DBWorkbench.getPlatform().getProjectManager().getDataSourceRegistry(this.pageDrivers.getConnectionProject());
    }

    List<DataSourceProviderDescriptor> getAvailableProvides() {
        return this.availableProvides;
    }

    ConnectionPageDriver getPageDrivers() {
        return this.pageDrivers;
    }

    ConnectionPageSettings getPageSettings(DriverDescriptor driver) {
        return this.settingsPages.get((Object)driver.getProviderDescriptor());
    }

    @Override
    public DriverDescriptor getSelectedDriver() {
        return this.getPageDrivers().getSelectedDriver();
    }

    @Override
    public ConnectionPageSettings getPageSettings() {
        if (this.pageDrivers.getSelectedDriver() == null) {
            return null;
        }
        return this.settingsPages.get((Object)this.pageDrivers.getSelectedDriver().getProviderDescriptor());
    }

    public void addPages() {
        Object element;
        this.pageDrivers = new ConnectionPageDriver(this);
        this.addPage((IWizardPage)this.pageDrivers);
        for (DataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders()) {
            this.availableProvides.add(provider);
            DataSourceViewDescriptor view = DataSourceViewRegistry.getInstance().findView(provider, "org.jkiss.dbeaver.ext.ui.newConnectionWizard");
            if (view == null) continue;
            ConnectionPageSettings pageSettings = new ConnectionPageSettings(this, view);
            this.settingsPages.put(provider, pageSettings);
            this.addPage((IWizardPage)pageSettings);
        }
        this.pageGeneral = new ConnectionPageGeneral(this);
        this.pageNetwork = new ConnectionPageNetwork(this);
        this.addPage((IWizardPage)this.pageGeneral);
        this.addPage((IWizardPage)this.pageNetwork);
        if (this.selection != null && !this.selection.isEmpty() && (element = this.selection.getFirstElement()) instanceof DBNLocalFolder) {
            this.pageGeneral.setDataSourceFolder(((DBNLocalFolder)element).getFolder());
        }
    }

    @Nullable
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageDrivers) {
            ConnectionPageSettings pageSettings = this.getPageSettings(this.pageDrivers.getSelectedDriver());
            if (pageSettings == null) {
                return this.pageDrivers.getSelectedDriver().isEmbedded() ? this.pageGeneral : this.pageNetwork;
            }
            return pageSettings;
        }
        if (page instanceof ConnectionPageSettings) {
            return null;
        }
        if (page instanceof ConnectionPageNetwork) {
            return null;
        }
        return null;
    }

    public boolean performFinish() {
        DriverDescriptor driver = this.getSelectedDriver();
        ConnectionPageSettings pageSettings = this.getPageSettings();
        DataSourceDescriptor dataSourceTpl = pageSettings == null ? this.getActiveDataSource() : pageSettings.getActiveDataSource();
        DBPDataSourceRegistry dataSourceRegistry = this.getDataSourceRegistry();
        DataSourceDescriptor dataSourceNew = new DataSourceDescriptor(dataSourceRegistry, dataSourceTpl.getId(), driver, dataSourceTpl.getConnectionConfiguration());
        dataSourceNew.copyFrom(dataSourceTpl);
        this.saveSettings(dataSourceNew);
        dataSourceRegistry.addDataSource((DBPDataSourceContainer)dataSourceNew);
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    @Override
    protected void saveSettings(DataSourceDescriptor dataSource) {
        ConnectionPageSettings pageSettings = this.getPageSettings(dataSource.getDriver());
        if (pageSettings != null) {
            pageSettings.saveSettings(dataSource);
        }
        this.pageGeneral.saveSettings(dataSource);
        this.pageNetwork.saveSettings(dataSource);
    }

    @Override
    public boolean isNew() {
        return true;
    }
}

