/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class ERDUtils {
    private static final Log log = Log.getLog(ERDUtils.class);

    public static String getFullAttributeLabel(EntityDiagram diagram, ERDEntityAttribute attribute, boolean includeType) {
        String comment;
        String attributeLabel = attribute.getName();
        if (includeType && diagram.hasAttributeStyle(ERDViewStyle.TYPES)) {
            attributeLabel = String.valueOf(attributeLabel) + ": " + ((DBSEntityAttribute)attribute.getObject()).getFullTypeName();
        }
        if (includeType && diagram.hasAttributeStyle(ERDViewStyle.NULLABILITY) && ((DBSEntityAttribute)attribute.getObject()).isRequired()) {
            attributeLabel = String.valueOf(attributeLabel) + " NOT NULL";
        }
        if (diagram.hasAttributeStyle(ERDViewStyle.COMMENTS) && !CommonUtils.isEmpty((String)(comment = ((DBSEntityAttribute)attribute.getObject()).getDescription()))) {
            attributeLabel = String.valueOf(attributeLabel) + " - " + comment;
        }
        return attributeLabel;
    }

    public static ERDEntity makeEntityFromObject(DBRProgressMonitor monitor, EntityDiagram diagram, DBSEntity entity, Object userData) {
        ERDEntity erdEntity = new ERDEntity(entity);
        erdEntity.setUserData(userData);
        diagram.getDecorator().fillEntityFromObject(monitor, diagram, erdEntity);
        return erdEntity;
    }

    @NotNull
    public static Collection<? extends DBSEntityAttribute> getBestTableIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        if (entity instanceof DBSTable && ((DBSTable)entity).isView()) {
            return Collections.emptyList();
        }
        if (CommonUtils.isEmpty((Collection)entity.getAttributes(monitor))) {
            return Collections.emptyList();
        }
        DBSEntityConstraint uniqueId = null;
        for (DBSEntityConstraint id : CommonUtils.safeCollection((Collection)entity.getConstraints(monitor))) {
            if (id instanceof DBSEntityReferrer && id.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)id));
            }
            if (id.getConstraintType().isUnique()) {
                uniqueId = id;
                continue;
            }
            if (!(id instanceof DBSTableIndex) || !((DBSTableIndex)id).isUnique()) continue;
            uniqueId = id;
        }
        if (uniqueId instanceof DBSEntityReferrer) {
            return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)uniqueId));
        }
        if (entity instanceof DBSTable) {
            try {
                Collection indexes = ((DBSTable)entity).getIndexes(monitor);
                if (!CommonUtils.isEmpty((Collection)indexes)) {
                    for (DBSTableIndex index : indexes) {
                        if (!DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)index)) continue;
                        return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)index);
                    }
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return Collections.emptyList();
    }

    public static boolean isIdentifyingAssociation(ERDAssociation association) {
        if (association.isLogical()) {
            return false;
        }
        try {
            return DBUtils.isIdentifyingAssociation((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAssociation)((DBSEntityAssociation)association.getObject()));
        }
        catch (DBException e) {
            log.debug((Object)e);
            return false;
        }
    }

    public static void openObjectEditor(@NotNull ERDObject object) {
        if (object.getObject() instanceof DBSObject) {
            UIUtils.runUIJob((String)"Open object editor", monitor -> {
                DBNDatabaseNode node = NavigatorUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((DBSObject)object.getObject()), (boolean)true);
                if (node != null) {
                    NavigatorUtils.openNavigatorNode((Object)node, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                }
            });
        }
    }

    public static ERDEntityAttribute getAttributeByModel(ERDEntity entity, DBSEntityAttribute attr) {
        for (ERDEntityAttribute erdAttr : entity.getAttributes()) {
            if (erdAttr.getObject() != attr) continue;
            return erdAttr;
        }
        return null;
    }
}

