/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDLogicalAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDLogicalPrimaryKey;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.utils.CommonUtils;

public class ERDAssociation
extends ERDObject<DBSEntityAssociation> {
    private static final Log log = Log.getLog(ERDAssociation.class);
    private ERDEntity sourceEntity;
    private ERDEntity targetEntity;
    private List<ERDEntityAttribute> sourceAttributes;
    private List<ERDEntityAttribute> targetAttributes;
    private List<Point> initBends;

    public ERDAssociation(ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        super(new ERDLogicalAssociation(sourceEntity, String.valueOf(((DBSEntity)sourceEntity.getObject()).getName()) + " -> " + ((DBSEntity)targetEntity.getObject()).getName(), "", new ERDLogicalPrimaryKey(targetEntity, "Logical primary key", "")));
        this.targetEntity = targetEntity;
        this.sourceEntity = sourceEntity;
        this.targetEntity.addReferenceAssociation(this, reflect);
        this.sourceEntity.addAssociation(this, reflect);
    }

    public ERDAssociation(DBSEntityAssociation association, ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        super(association);
        this.targetEntity = targetEntity;
        this.sourceEntity = sourceEntity;
        if (association instanceof DBSEntityReferrer) {
            this.resolveAttributes((DBSEntityReferrer)association, sourceEntity, targetEntity);
        }
        this.targetEntity.addReferenceAssociation(this, reflect);
        this.sourceEntity.addAssociation(this, reflect);
    }

    protected void resolveAttributes(DBSEntityReferrer association, ERDEntity sourceEntity, ERDEntity targetEntity) {
        try {
            List attrRefs = association.getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
            if (!CommonUtils.isEmpty((Collection)attrRefs)) {
                for (DBSEntityAttributeRef attrRef : attrRefs) {
                    if (!(attrRef instanceof DBSTableForeignKeyColumn)) continue;
                    DBSTableColumn targetAttr = ((DBSTableForeignKeyColumn)attrRef).getReferencedColumn();
                    DBSEntityAttribute sourceAttr = attrRef.getAttribute();
                    if (sourceAttr == null || targetAttr == null) continue;
                    ERDEntityAttribute erdSourceAttr = ERDUtils.getAttributeByModel(sourceEntity, sourceAttr);
                    ERDEntityAttribute erdTargetAttr = ERDUtils.getAttributeByModel(targetEntity, (DBSEntityAttribute)targetAttr);
                    if (erdSourceAttr == null || erdTargetAttr == null) continue;
                    this.addCondition(erdSourceAttr, erdTargetAttr);
                }
            }
        }
        catch (DBException e) {
            log.error((Object)"Error resolving ERD association attributes", (Throwable)e);
        }
    }

    public boolean isLogical() {
        return this.getObject() instanceof ERDLogicalAssociation;
    }

    public ERDEntity getSourceEntity() {
        return this.sourceEntity;
    }

    public ERDEntity getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(ERDEntity targetPrimaryKey) {
        this.targetEntity = targetPrimaryKey;
    }

    public void setSourceEntity(ERDEntity sourceForeignKey) {
        this.sourceEntity = sourceForeignKey;
    }

    @NotNull
    public List<ERDEntityAttribute> getSourceAttributes() {
        return this.sourceAttributes == null ? Collections.emptyList() : this.sourceAttributes;
    }

    @NotNull
    public List<ERDEntityAttribute> getTargetAttributes() {
        return this.targetAttributes == null ? Collections.emptyList() : this.targetAttributes;
    }

    public void addCondition(ERDEntityAttribute sourceAttribute, ERDEntityAttribute targetAttribute) {
        if (this.sourceAttributes == null) {
            this.sourceAttributes = new ArrayList<ERDEntityAttribute>();
        }
        this.sourceAttributes.add(sourceAttribute);
        if (this.targetAttributes == null) {
            this.targetAttributes = new ArrayList<ERDEntityAttribute>();
        }
        this.targetAttributes.add(targetAttribute);
    }

    public List<Point> getInitBends() {
        return this.initBends;
    }

    public void setInitBends(List<Point> bends) {
        this.initBends = bends;
    }

    public String toString() {
        return this.getObject() + " [" + this.sourceEntity + "->" + this.targetEntity + "]";
    }

    @NotNull
    public String getName() {
        return ((DBSEntityAssociation)this.getObject()).getName();
    }
}

