/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.plan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public class OraclePlanNode
implements DBCPlanNode {
    private final OracleDataSource dataSource;
    private String statementId;
    private long plan_id;
    private Timestamp timestamp;
    private String remarks;
    private String operation;
    private String options;
    private String objectNode;
    private String objectOwner;
    private String objectName;
    private String objectAlias;
    private long objectInstance;
    private String objectType;
    private String optimizer;
    private long searchColumns;
    private int id;
    private int parentId;
    private int depth;
    private int position;
    private long cost;
    private long cardinality;
    private long bytes;
    private String otherTag;
    private String partitionStart;
    private String partitionStop;
    private long partitionId;
    private String other;
    private String distribution;
    private long cpuCost;
    private long ioCost;
    private long tempSpace;
    private String accessPredicates;
    private String filterPredicates;
    private String projection;
    private long time;
    private String qblockName;
    private String otherXml;
    private OraclePlanNode parent;
    private List<OraclePlanNode> nested;

    public OraclePlanNode(OracleDataSource dataSource, IntKeyMap<OraclePlanNode> prevNodes, ResultSet dbResult) throws SQLException {
        this.dataSource = dataSource;
        this.statementId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"statement_id");
        this.plan_id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"plan_id");
        this.timestamp = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"timestamp");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"remarks");
        this.operation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"operation");
        this.options = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"options");
        this.objectNode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_node");
        this.objectOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_owner");
        this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_name");
        this.objectAlias = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_alias");
        this.objectInstance = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_instance");
        this.objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"object_type");
        this.optimizer = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"optimizer");
        this.searchColumns = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"search_columns");
        this.id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"id");
        this.depth = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"depth");
        this.position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"position");
        this.cost = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"cost");
        this.cardinality = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"cardinality");
        this.bytes = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"bytes");
        this.otherTag = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"other_tag");
        this.partitionStart = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_start");
        this.partitionStop = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_stop");
        this.partitionId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"partition_id");
        this.other = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"other");
        this.distribution = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"distribution");
        this.cpuCost = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"cpu_cost");
        this.ioCost = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"io_cost");
        this.tempSpace = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"temp_space");
        this.accessPredicates = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"access_predicates");
        this.filterPredicates = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"filter_predicates");
        this.projection = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"projection");
        this.time = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"time");
        this.qblockName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"qblock_name");
        this.otherXml = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"other_xml");
        Integer parent_id = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"parent_id");
        if (parent_id != null) {
            this.parent = (OraclePlanNode)prevNodes.get((Object)parent_id);
        }
        if (this.parent != null) {
            if (this.parent.nested == null) {
                this.parent.nested = new ArrayList<OraclePlanNode>();
            }
            this.parent.nested.add(this);
        }
    }

    public OraclePlanNode getParent() {
        return this.parent;
    }

    public Collection<OraclePlanNode> getNested() {
        return this.nested;
    }

    public int getId() {
        return this.id;
    }

    @Property(order=1, viewable=true)
    public String getOperation() {
        if (CommonUtils.isEmpty((String)this.options)) {
            return this.operation;
        }
        return String.valueOf(this.operation) + " (" + this.options + ")";
    }

    public String getOptions() {
        return this.options;
    }

    public String getObjectType() {
        return this.objectType;
    }

    @Property(order=5, viewable=true, supportsPreview=true)
    public Object getObject(DBRProgressMonitor monitor) throws DBException {
        int divPos;
        if (monitor == null || CommonUtils.isEmpty((String)this.objectOwner)) {
            return this.objectName == null ? "" : this.objectName;
        }
        String objectTypeName = this.objectType;
        int n = divPos = objectTypeName == null ? -1 : objectTypeName.indexOf(40);
        if (divPos != -1) {
            objectTypeName = objectTypeName.substring(0, divPos).trim();
        }
        if (OracleObjectType.INDEX.name().equals(objectTypeName)) {
            OraclePlanNode parentNode = this.parent;
            while (parentNode != null) {
                Object parentObject = parentNode.getObject(monitor);
                if (parentObject instanceof OracleTablePhysical) {
                    return ((OracleTablePhysical)parentObject).getIndex(monitor, this.objectName);
                }
                parentNode = parentNode.getParent();
            }
            return this.objectName;
        }
        objectTypeName = OracleObjectType.TABLE.name();
        if (this.objectName.startsWith("X$")) {
            return this.objectName;
        }
        divPos = this.objectName.indexOf("(");
        String name = divPos == -1 ? this.objectName : this.objectName.substring(0, divPos);
        return OracleObjectType.resolveObject(monitor, this.dataSource, this.objectNode, objectTypeName, this.objectOwner, name.trim());
    }

    public String getAlias() {
        return this.objectAlias;
    }

    @Property(order=7, viewable=true)
    public String getOptimizer() {
        return this.optimizer;
    }

    @Property(order=8, viewable=true)
    public long getCost() {
        return this.cost;
    }

    @Property(order=9, viewable=true)
    public long getCardinality() {
        return this.cardinality;
    }

    @Property(order=10, viewable=true)
    public long getBytes() {
        return this.bytes;
    }

    @Property(order=20)
    public String getPartitionStart() {
        return this.partitionStart;
    }

    @Property(order=21)
    public String getPartitionStop() {
        return this.partitionStop;
    }

    @Property(order=22)
    public long getPartitionId() {
        return this.partitionId;
    }

    @Property(order=23)
    public String getDistribution() {
        return this.distribution;
    }

    @Property(order=24)
    public long getCpuCost() {
        return this.cpuCost;
    }

    @Property(order=25)
    public long getIoCost() {
        return this.ioCost;
    }

    @Property(order=26)
    public long getTempSpace() {
        return this.tempSpace;
    }

    @Property(order=27)
    public String getAccessPredicates() {
        return this.accessPredicates;
    }

    @Property(order=28)
    public String getFilterPredicates() {
        return this.filterPredicates;
    }

    @Property(order=29)
    public String getProjection() {
        return this.projection;
    }

    @Property(order=30)
    public long getTime() {
        return this.time;
    }

    @Property(order=31)
    public String getQblockName() {
        return this.qblockName;
    }

    public String toString() {
        return String.valueOf(this.operation) + " " + CommonUtils.toString((Object)this.options) + " " + CommonUtils.toString((Object)this.objectName);
    }
}

