/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OraclePartitionBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;

public abstract class OracleTablePhysical
extends OracleTableBase
implements DBSObjectLazy<OracleDataSource> {
    private static final Log log = Log.getLog(OracleTablePhysical.class);
    public static final String CAT_STATISTICS = "Statistics";
    private long rowCount;
    private Long realRowCount;
    private Object tablespace;
    private boolean partitioned;
    private PartitionInfo partitionInfo;
    private PartitionCache partitionCache;

    protected OracleTablePhysical(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    protected OracleTablePhysical(OracleSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
        this.rowCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUM_ROWS");
        this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLESPACE_NAME");
        this.partitioned = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PARTITIONED", (String)"Y");
        this.partitionCache = this.partitioned ? new PartitionCache() : null;
    }

    @Property(category="Statistics", viewable=true, order=20)
    public long getRowCount() {
        return this.rowCount;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=21)
    public synchronized Long getRealRowCount(DBRProgressMonitor monitor) {
        if (this.realRowCount != null) {
            return this.realRowCount;
        }
        if (!this.isPersisted()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                this.realRowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't fetch row count", (Throwable)e);
        }
        if (this.realRowCount == null) {
            this.realRowCount = -1L;
        }
        return this.realRowCount;
    }

    public Object getLazyReference(Object propertyId) {
        return this.tablespace;
    }

    @Property(viewable=true, order=22, editable=true, updatable=true, listProvider=TablespaceListProvider.class)
    @LazyProperty(cacheValidator=OracleTablespace.TablespaceReferenceValidator.class)
    public Object getTablespace(DBRProgressMonitor monitor) throws DBException {
        return OracleTablespace.resolveTablespaceReference(monitor, this, null);
    }

    public Object getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(OracleTablespace tablespace) {
        this.tablespace = tablespace;
    }

    @Association
    public Collection<OracleTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).indexCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    public OracleTableIndex getIndex(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleTableIndex)((OracleSchema)this.getContainer()).indexCache.getObject(monitor, (OracleSchema)this.getContainer(), this, name);
    }

    @PropertyGroup
    @LazyProperty(cacheValidator=PartitionInfoValidator.class)
    public PartitionInfo getPartitionInfo(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionInfo == null && this.partitioned) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load partitioning info");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM ALL_PART_TABLES WHERE OWNER=? AND TABLE_NAME=?");){
                        dbStat.setString(1, ((OracleSchema)this.getContainer()).getName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                this.partitionInfo = new PartitionInfo(monitor, (OracleDataSource)this.getDataSource(), (ResultSet)dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, this.getDataSource());
            }
        }
        return this.partitionInfo;
    }

    @Association
    public Collection<OracleTablePartition> getPartitions(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionCache == null) {
            return null;
        }
        this.partitionCache.getAllObjects(monitor, this);
        this.partitionCache.loadChildren(monitor, this, null);
        return this.partitionCache.getAllObjects(monitor, this);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).indexCache.clearObjectCache(this);
        return super.refreshObject(monitor);
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.TABLE);
    }

    private static class PartitionCache
    extends JDBCStructCache<OracleTablePhysical, OracleTablePartition, OracleTablePartition> {
        protected PartitionCache() {
            super((Object)"PARTITION_NAME");
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTablePhysical table) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM SYS.ALL_TAB_PARTITIONS WHERE TABLE_OWNER=? AND TABLE_NAME=? ORDER BY PARTITION_POSITION");
            dbStat.setString(1, ((OracleSchema)table.getContainer()).getName());
            dbStat.setString(2, table.getName());
            return dbStat;
        }

        protected OracleTablePartition fetchObject(@NotNull JDBCSession session, @NotNull OracleTablePhysical table, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleTablePartition(table, false, (ResultSet)resultSet);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull OracleTablePhysical table, @Nullable OracleTablePartition forObject) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM SYS.ALL_TAB_SUBPARTITIONS WHERE TABLE_OWNER=? AND TABLE_NAME=? " + (forObject == null ? "" : "AND PARTITION_NAME=?") + "ORDER BY SUBPARTITION_POSITION");
            dbStat.setString(1, ((OracleSchema)table.getContainer()).getName());
            dbStat.setString(2, table.getName());
            if (forObject != null) {
                dbStat.setString(2, forObject.getName());
            }
            return dbStat;
        }

        protected OracleTablePartition fetchChild(@NotNull JDBCSession session, @NotNull OracleTablePhysical table, @NotNull OracleTablePartition parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleTablePartition(table, true, (ResultSet)dbResult);
        }
    }

    public static class PartitionInfo
    extends OraclePartitionBase.PartitionInfoBase {
        public PartitionInfo(DBRProgressMonitor monitor, OracleDataSource dataSource, ResultSet dbResult) throws DBException {
            super(monitor, dataSource, dbResult);
        }
    }

    public static class PartitionInfoValidator
    implements IPropertyCacheValidator<OracleTablePhysical> {
        public boolean isPropertyCached(OracleTablePhysical object, Object propertyId) {
            return object.partitioned && object.partitionInfo != null;
        }
    }

    public static class TablespaceListProvider
    implements IPropertyValueListProvider<OracleTablePhysical> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(OracleTablePhysical object) {
            ArrayList<OracleTablespace> tablespaces = new ArrayList<OracleTablespace>();
            try {
                tablespaces.addAll(((OracleDataSource)object.getDataSource()).getTablespaces((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.error((Object)e);
            }
            tablespaces.sort(DBUtils.nameComparator());
            return tablespaces.toArray(new OracleTablespace[tablespaces.size()]);
        }
    }
}

