/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.application.DBeaverApplication;
import org.jkiss.dbeaver.core.application.rpc.IInstanceController;
import org.jkiss.dbeaver.core.application.rpc.InstanceClient;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class DBeaverCommandLine {
    private static final Log log;
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.commandLine";
    public static final String PARAM_HELP = "help";
    public static final String PARAM_FILE = "f";
    public static final String PARAM_STOP = "stop";
    public static final String PARAM_THREAD_DUMP = "dump";
    public static final String PARAM_CONNECT = "con";
    public static final String PARAM_CLOSE_TABS = "closeTabs";
    public static final String PARAM_DISCONNECT_ALL = "disconnectAll";
    public static final String PARAM_REUSE_WORKSPACE = "reuseWorkspace";
    public static final String PARAM_NEW_INSTANCE = "newInstance";
    public static final Options ALL_OPTIONS;
    private static Map<String, ParameterDescriptor> customParameters;

    static {
        IConfigurationElement[] extElements;
        log = Log.getLog(DBeaverCommandLine.class);
        ALL_OPTIONS = new Options().addOption(PARAM_HELP, false, "Help").addOption(PARAM_FILE, "file", true, "File top open").addOption(PARAM_STOP, "quit", false, "Stop DBeaver running instance").addOption(PARAM_THREAD_DUMP, "thread-dump", false, "Print instance thread dump").addOption(PARAM_CONNECT, "connect", true, "Connects to a specified database").addOption(PARAM_DISCONNECT_ALL, PARAM_DISCONNECT_ALL, false, "Disconnect from all databases").addOption(PARAM_CLOSE_TABS, PARAM_CLOSE_TABS, false, "Close all open editors").addOption(PARAM_REUSE_WORKSPACE, PARAM_REUSE_WORKSPACE, false, "Force workspace reuse (do not show warnings)").addOption(PARAM_NEW_INSTANCE, PARAM_NEW_INSTANCE, false, "Force creating new application instance (do not try to activate already running)").addOption("product", true, "Product id").addOption("nl", true, "National locale").addOption("data", true, "Data directory").addOption("nosplash", false, "No splash screen").addOption("showlocation", false, "Show location");
        customParameters = new LinkedHashMap<String, ParameterDescriptor>();
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extElements = er.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("parameter".equals(ext.getName())) {
                try {
                    ParameterDescriptor parameter = new ParameterDescriptor(ext);
                    customParameters.put(parameter.name, parameter);
                }
                catch (Exception e) {
                    log.error((Object)"Can't load contributed parameter", (Throwable)e);
                }
            }
            ++n2;
        }
        for (ParameterDescriptor param : customParameters.values()) {
            ALL_OPTIONS.addOption(param.name, param.longName, param.hasArg, param.description);
        }
    }

    static boolean executeCommandLineCommands(CommandLine commandLine, IInstanceController controller, boolean uiActivated) throws Exception {
        Object[] connectParams;
        if (commandLine == null) {
            return false;
        }
        if (controller == null) {
            return false;
        }
        boolean exitAfterExecute = false;
        if (!uiActivated) {
            if (commandLine.hasOption(PARAM_STOP)) {
                controller.quit();
                return true;
            }
            if (commandLine.hasOption(PARAM_THREAD_DUMP)) {
                String threadDump = controller.getThreadDump();
                System.out.println(threadDump);
                return true;
            }
        }
        Object[] files = commandLine.getOptionValues(PARAM_FILE);
        Object[] fileArgs = commandLine.getArgs();
        if (!ArrayUtils.isEmpty((Object[])files) || !ArrayUtils.isEmpty((Object[])fileArgs)) {
            ArrayList fileNames = new ArrayList();
            if (!ArrayUtils.isEmpty((Object[])files)) {
                Collections.addAll(fileNames, files);
            }
            if (!ArrayUtils.isEmpty((Object[])fileArgs)) {
                Collections.addAll(fileNames, fileArgs);
            }
            controller.openExternalFiles(fileNames.toArray(new String[fileNames.size()]));
            exitAfterExecute = true;
        }
        if (!ArrayUtils.isEmpty((Object[])(connectParams = commandLine.getOptionValues(PARAM_CONNECT)))) {
            Object[] objectArray = connectParams;
            int n = connectParams.length;
            int n2 = 0;
            while (n2 < n) {
                Object cp = objectArray[n2];
                controller.openDatabaseConnection((String)cp);
                ++n2;
            }
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_CLOSE_TABS)) {
            controller.closeAllEditors();
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_DISCONNECT_ALL)) {
            controller.executeWorkbenchCommand("org.jkiss.dbeaver.core.disconnectAll");
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_REUSE_WORKSPACE) && DBeaverApplication.instance != null) {
            DBeaverApplication.instance.reuseWorkspace = true;
        }
        return exitAfterExecute;
    }

    static CommandLine getCommandLine() {
        try {
            return new DefaultParser().parse(ALL_OPTIONS, Platform.getApplicationArgs(), false);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing command line: " + e.getMessage()));
            return null;
        }
    }

    static boolean handleCommandLine(String instanceLoc) {
        CommandLine commandLine = DBeaverCommandLine.getCommandLine();
        if (commandLine == null || ArrayUtils.isEmpty((Object[])commandLine.getArgs()) && ArrayUtils.isEmpty((Object[])commandLine.getOptions())) {
            return false;
        }
        if (commandLine.hasOption(PARAM_HELP)) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.setWidth(120);
            helpFormatter.setOptionComparator((o1, o2) -> 0);
            helpFormatter.printHelp("dbeaver", GeneralUtils.getProductTitle(), ALL_OPTIONS, "(C) 2018 DBeaver Corp", true);
            return true;
        }
        if (commandLine.hasOption(PARAM_NEW_INSTANCE)) {
            return false;
        }
        IInstanceController controller = null;
        try {
            controller = InstanceClient.createClient(instanceLoc);
        }
        catch (Exception e) {
            log.debug((Object)("Error detecting DBeaver running instance: " + e.getMessage()));
        }
        if (controller == null) {
            log.debug((Object)"No running DBeaver instance found");
            return false;
        }
        try {
            return DBeaverCommandLine.executeCommandLineCommands(commandLine, controller, false);
        }
        catch (RemoteException e) {
            log.error((Object)"Error calling remote server", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error while calling remote server", e);
        }
        return false;
    }

    public static void handleCustomParameters() {
        CommandLine commandLine = DBeaverCommandLine.getCommandLine();
        if (commandLine == null) {
            return;
        }
        for (ParameterDescriptor param : customParameters.values()) {
            boolean cfr_ignored_0 = param.exitAfterExecute;
            if (!commandLine.hasOption(param.name)) continue;
            param.handler.handleParameter(param.name, param.hasArg ? commandLine.getOptionValue(param.name) : null);
        }
    }

    private static class ParameterDescriptor {
        String name;
        String longName;
        String description;
        boolean hasArg;
        boolean exitAfterExecute;
        ParameterHandler handler;

        public ParameterDescriptor(IConfigurationElement config) throws Exception {
            this.name = config.getAttribute("name");
            this.longName = config.getAttribute("longName");
            this.description = config.getAttribute("description");
            this.hasArg = CommonUtils.toBoolean((Object)config.getAttribute("hasArg"));
            this.exitAfterExecute = CommonUtils.toBoolean((Object)config.getAttribute("exitAfterExecute"));
            Bundle cBundle = Platform.getBundle((String)config.getContributor().getName());
            Class implClass = cBundle.loadClass(config.getAttribute("handler"));
            this.handler = (ParameterHandler)implClass.newInstance();
        }
    }

    public static interface ParameterHandler {
        public void handleParameter(String var1, String var2);
    }
}

