/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeLoadService;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeLoadVisualizer;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeLazyExpander;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.ArrayUtils;

class DatabaseNavigatorContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private static final Log log = Log.getLog(DatabaseNavigatorContentProvider.class);
    private static final Object[] EMPTY_CHILDREN = new Object[0];
    private DatabaseNavigatorTree navigatorTree;
    private boolean showRoot;

    DatabaseNavigatorContentProvider(DatabaseNavigatorTree navigatorTree, boolean showRoot) {
        this.navigatorTree = navigatorTree;
        this.showRoot = showRoot;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof DatabaseNavigatorContent) {
            if (this.showRoot) {
                return new Object[]{((DatabaseNavigatorContent)parent).getRootNode()};
            }
            return this.getChildren(((DatabaseNavigatorContent)parent).getRootNode());
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof DBNNode) {
            return ((DBNNode)child).getParentNode();
        }
        if (child instanceof TreeNodeSpecial) {
            return ((TreeNodeSpecial)child).getParent();
        }
        log.warn((Object)("Unknown node type: " + child));
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeNodeSpecial) {
            return null;
        }
        if (!(parent instanceof DBNNode)) {
            log.error((Object)("Bad parent type: " + parent));
            return null;
        }
        DBNNode parentNode = (DBNNode)parent;
        if (!parentNode.hasChildren(true)) {
            return EMPTY_CHILDREN;
        }
        if (parentNode instanceof DBNDatabaseNode && ((DBNDatabaseNode)parentNode).needsInitialization()) {
            return TreeLoadVisualizer.expandChildren((AbstractTreeViewer)this.navigatorTree.getViewer(), new TreeLoadService("Loading", (DBNDatabaseNode)parentNode));
        }
        try {
            Object[] children = NavigatorUtils.getNodeChildrenFiltered((DBRProgressMonitor)new VoidProgressMonitor(), parentNode, true);
            if (ArrayUtils.isEmpty((Object[])children)) {
                return EMPTY_CHILDREN;
            }
            int longListFetchSize = DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.long.list.fetch.size");
            if (children.length > longListFetchSize) {
                Object[] curChildren = new Object[longListFetchSize + 1];
                System.arraycopy(children, 0, curChildren, 0, longListFetchSize);
                curChildren[longListFetchSize] = new TreeNodeLazyExpander(parentNode, (DBNNode[])children, longListFetchSize);
                return curChildren;
            }
            return children;
        }
        catch (Throwable ex) {
            DBWorkbench.getPlatformUI().showError("Navigator error", ex.getMessage(), ex);
            UIUtils.asyncExec(() -> {
                this.navigatorTree.getViewer().collapseToLevel(parent, 1);
                this.navigatorTree.getViewer().refresh(parent);
            });
            return EMPTY_CHILDREN;
        }
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof DBNDatabaseNode && this.navigatorTree.getNavigatorFilter() != null && this.navigatorTree.getNavigatorFilter().isLeafObject(((DBNDatabaseNode)parent).getObject())) {
            return false;
        }
        return parent instanceof DBNNode && ((DBNNode)parent).hasChildren(true);
    }
}

