/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGController;
import org.jkiss.dbeaver.debug.DBGResolver;
import org.jkiss.dbeaver.debug.core.model.DatabaseStackFrame;
import org.jkiss.dbeaver.debug.internal.core.DebugCoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DebugUtils {
    private static Log log = Log.getLog(DebugUtils.class);

    public static CoreException abort(String message, Throwable th) {
        return new CoreException((IStatus)DebugUtils.newErrorStatus(message, th));
    }

    public static CoreException abort(String message) {
        return DebugUtils.abort(message, null);
    }

    public static boolean canLaunch(ILaunchConfiguration configuration, String mode) {
        if (configuration == null || !configuration.exists()) {
            return false;
        }
        try {
            return configuration.supportsMode(mode);
        }
        catch (CoreException e) {
            String message = NLS.bind((String)DebugCoreMessages.DebugCore_e_unable_to_retrieve_modes, (Object)configuration);
            log.error((Object)message, (Throwable)e);
            return false;
        }
    }

    public static List<DBSObject> extractLaunchable(Object[] scope) {
        ArrayList<DBSObject> extracted = new ArrayList<DBSObject>();
        if (scope == null) {
            return extracted;
        }
        Object[] objectArray = scope;
        int n = scope.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            DBSObject adapted = (DBSObject)Adapters.adapt((Object)object, DBSObject.class, (boolean)true);
            if (adapted != null) {
                extracted.add(adapted);
            }
            ++n2;
        }
        return extracted;
    }

    public static Status newErrorStatus(String message, Throwable th) {
        return new Status(4, "org.jkiss.dbeaver.debug.core", message, th);
    }

    public static Status newErrorStatus(String message) {
        return DebugUtils.newErrorStatus(message, null);
    }

    public static DBSObject resolveDatabaseObject(DBPDataSourceContainer container, Map<String, Object> context, Object identifier, DBRProgressMonitor monitor) throws DBException {
        DBGResolver finder = (DBGResolver)Adapters.adapt((Object)container, DBGResolver.class);
        if (finder == null) {
            return null;
        }
        return finder.resolveObject(context, identifier, monitor);
    }

    public static Map<String, Object> resolveDatabaseContext(DBSObject databaseObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (databaseObject == null) {
            return result;
        }
        DBPDataSource dataSource = databaseObject.getDataSource();
        if (dataSource == null) {
            return result;
        }
        DBGResolver finder = (DBGResolver)Adapters.adapt((Object)dataSource.getContainer(), DBGResolver.class);
        if (finder == null) {
            return result;
        }
        Map<String, Object> context = finder.resolveContext(databaseObject);
        result.putAll(context);
        return result;
    }

    public static String getSourceName(Object object) throws CoreException {
        if (object instanceof DatabaseStackFrame) {
            DBSObject dbsObject;
            DatabaseStackFrame frame = (DatabaseStackFrame)((Object)object);
            Object sourceIdentifier = frame.getSourceIdentifier();
            try {
                dbsObject = DebugUtils.findDatabaseObject(frame.getController(), sourceIdentifier, (DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBException e) {
                Status error = DebugUtils.newErrorStatus(e.getMessage(), e);
                throw new CoreException((IStatus)error);
            }
            if (dbsObject == null) {
                return null;
            }
            DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
            DBNDatabaseNode node = navigatorModel.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), dbsObject, false);
            if (node != null) {
                return node.getNodeItemPath();
            }
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static Map<String, Object> toBreakpointDescriptor(Map<String, Object> attributes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("lineNumber", attributes.get("lineNumber"));
        return result;
    }

    public static DBSObject findDatabaseObject(DBGController controller, Object identifier, DBRProgressMonitor monitor) throws DBException {
        DBPDataSourceContainer container = controller.getDataSourceContainer();
        Map<String, Object> context = controller.getDebugConfiguration();
        return DebugUtils.resolveDatabaseObject(container, context, identifier, monitor);
    }

    public static void putContextInConfiguration(ILaunchConfigurationWorkingCopy configuration, Map<String, Object> attrs) {
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                configuration.removeAttribute(entry.getKey());
                continue;
            }
            if (value instanceof Integer) {
                configuration.setAttribute(entry.getKey(), (Object)((Integer)value));
                continue;
            }
            if (value instanceof Boolean) {
                configuration.setAttribute(entry.getKey(), (Object)((Boolean)value));
                continue;
            }
            if (value instanceof List) {
                configuration.setAttribute(entry.getKey(), (List)value);
                continue;
            }
            configuration.setAttribute(entry.getKey(), value.toString());
        }
    }

    public static void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    public static void fireTerminate(Object source) {
        DebugUtils.fireEvent(new DebugEvent(source, 8));
    }
}

