/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.debug.ui.DatabaseLaunchContributionItem;

public abstract class DatabaseLaunchContributionFactory
extends ExtensionContributionFactory {
    private final String id;
    private String text;
    private ImageDescriptor imageDescriptor;

    public DatabaseLaunchContributionFactory(String id) {
        this.id = id;
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        String identifierId = this.createContributionIdentifier();
        IIdentifier identifier = activitySupport.getActivityManager().getIdentifier(identifierId);
        if (!identifier.isEnabled()) {
            return;
        }
        MenuManager menuManager = new MenuManager(this.text, this.imageDescriptor, this.id);
        DatabaseLaunchContributionItem item = this.createContributionItem();
        item.setVisible(true);
        menuManager.add((IContributionItem)item);
        additions.addContributionItem((IContributionItem)menuManager, null);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    protected String createContributionIdentifier() {
        return "org.jkiss.dbeaver.debug.ui/" + this.id;
    }

    protected abstract DatabaseLaunchContributionItem createContributionItem();
}

