/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLServerTable
extends SQLServerTableBase
implements DBPScriptObject {
    private static final Log log = Log.getLog(SQLServerTable.class);
    private CheckConstraintCache checkConstraintCache = new CheckConstraintCache();
    private String ddl;

    public SQLServerTable(SQLServerSchema schema) {
        super(schema);
    }

    public SQLServerTable(DBRProgressMonitor monitor, SQLServerSchema schema, SQLServerTable source) throws DBException {
        super(monitor, schema, source);
        DBSObjectCache colCache = ((SQLServerSchema)this.getContainer()).getTableCache().getChildrenCache((DBSObject)this);
        for (DBSEntityAttribute srcColumn : CommonUtils.safeCollection(source.getAttributes(monitor))) {
            if (DBUtils.isHiddenObject((Object)srcColumn)) continue;
            SQLServerTableColumn column = new SQLServerTableColumn(monitor, (SQLServerTableBase)this, srcColumn);
            colCache.cacheObject((DBSObject)column);
        }
    }

    public SQLServerTable(SQLServerSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    public boolean isView() {
        return false;
    }

    @Nullable
    @Association
    public Collection<SQLServerTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((SQLServerSchema)this.getContainer()).getUniqueConstraintCache().getObjects(monitor, (DBSObject)this.getSchema(), (DBSObject)this);
    }

    @Nullable
    @Association
    public synchronized Collection<SQLServerTableCheckConstraint> getCheckConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.checkConstraintCache.getAllObjects(monitor, (DBSObject)this);
    }

    public CheckConstraintCache getCheckConstraintCache() {
        return this.checkConstraintCache;
    }

    @Association
    public Collection<SQLServerTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<SQLServerTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getForeignKeyCache().getObjects(monitor, (DBSObject)this.getSchema(), (DBSObject)this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"refresh")) {
            this.ddl = null;
        }
        if (this.ddl == null) {
            this.ddl = JDBCUtils.generateTableDDL((DBRProgressMonitor)monitor, (JDBCTable)this, options, (boolean)false);
        }
        return this.ddl;
    }

    @Association
    public Collection<SQLServerTableTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        Collection allTriggers = this.getSchema().getTriggerCache().getAllObjects(monitor, (DBSObject)this.getSchema());
        return allTriggers.stream().filter(p -> p.getTable() == this).collect(Collectors.toList());
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((SQLServerSchema)this.getContainer()).getIndexCache().clearObjectCache((DBSObject)this);
        ((SQLServerSchema)this.getContainer()).getUniqueConstraintCache().clearObjectCache((DBSObject)this);
        ((SQLServerSchema)this.getContainer()).getForeignKeyCache().clearObjectCache((DBSObject)this);
        ((SQLServerSchema)this.getContainer()).getTriggerCache().clearChildrenOf((DBSObject)this);
        return ((SQLServerSchema)this.getContainer()).getTableCache().refreshObject(monitor, (DBSObject)((SQLServerSchema)this.getContainer()), (DBSObject)this);
    }

    static class CheckConstraintCache
    extends JDBCObjectCache<SQLServerTable, SQLServerTableCheckConstraint> {
        CheckConstraintCache() {
        }

        protected JDBCStatement prepareObjectsStatement(JDBCSession session, SQLServerTable table) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + SQLServerUtils.getSystemTableName(table.getDatabase(), "check_constraints") + " WHERE parent_object_id=?");
            dbStat.setLong(1, table.getObjectId());
            return dbStat;
        }

        protected SQLServerTableCheckConstraint fetchObject(JDBCSession session, SQLServerTable table, JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerTableCheckConstraint(table, resultSet);
        }
    }
}

